/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.progress.ProgressTaskIds;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class DownloadWmsAlongTrackAction
extends AbstractAction {
    private final transient GpxData data;

    public DownloadWmsAlongTrackAction(GpxData data) {
        super(I18n.tr("Precache imagery tiles along this track", new Object[0]));
        new ImageProvider("downloadalongtrack").getResource().attachImageIcon(this, true);
        this.data = data;
    }

    PrecacheWmsTask createTask() {
        List<LatLon> points = this.data.tracks.stream().flatMap(trk -> trk.getSegments().stream()).flatMap(segment -> segment.getWayPoints().stream()).map(WayPoint::getCoor).collect(Collectors.toList());
        for (WayPoint p : this.data.waypoints) {
            points.add(p.getCoor());
        }
        AbstractTileSourceLayer<? extends AbstractTMSTileSource> layer = this.askedLayer();
        return layer != null ? new PrecacheWmsTask(layer, points) : null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PrecacheWmsTask task = this.createTask();
        if (task != null) {
            MainApplication.worker.execute(task);
        }
    }

    protected AbstractTileSourceLayer<? extends AbstractTMSTileSource> askedLayer() {
        List<AbstractTileSourceLayer> targetLayers = MainApplication.getLayerManager().getLayersOfType(AbstractTileSourceLayer.class);
        if (targetLayers.isEmpty()) {
            this.warnNoImageryLayers();
            return null;
        }
        return (AbstractTileSourceLayer)AbstractMergeAction.askTargetLayer((Layer[])targetLayers.toArray(new AbstractTileSourceLayer[0]), (String)I18n.tr("Please select the imagery layer.", new Object[0]), (String)I18n.tr("Select imagery layer", new Object[0]), (String)I18n.tr("Download", new Object[0]), (String)"dialogs/down");
    }

    protected void warnNoImageryLayers() {
        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("There are no imagery layers.", new Object[0]), I18n.tr("No imagery layers", new Object[0]), 2);
    }

    static class PrecacheWmsTask
    extends PleaseWaitRunnable {
        private final AbstractTileSourceLayer<? extends AbstractTMSTileSource> layer;
        private final List<LatLon> points;
        private AbstractTileSourceLayer.PrecacheTask precacheTask;

        protected PrecacheWmsTask(AbstractTileSourceLayer<? extends AbstractTMSTileSource> layer, List<LatLon> points) {
            super(I18n.tr("Precaching WMS", new Object[0]));
            this.layer = layer;
            this.points = points;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            this.precacheTask = this.layer.getDownloadAreaToCacheTask(this.progressMonitor, this.points, 0.0, 0.0);
            this.precacheTask.run();
            PrecacheWmsTask precacheWmsTask = this;
            synchronized (precacheWmsTask) {
                try {
                    while (!this.precacheTask.isFinished() && !this.progressMonitor.isCanceled()) {
                        this.wait(200L);
                    }
                }
                catch (InterruptedException ex) {
                    Logging.warn("InterruptedException in " + this.getClass().getSimpleName() + " while precaching WMS");
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        protected void finish() {
        }

        @Override
        protected void cancel() {
            this.precacheTask.cancel();
        }

        @Override
        public ProgressTaskId canRunInBackground() {
            return ProgressTaskIds.PRECACHE_WMS;
        }
    }
}

