/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dev.psiViewer;

import com.intellij.dev.psiViewer.ViewerNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ViewerTreeStructure
extends AbstractTreeStructure {
    private boolean myShowWhiteSpaces;
    private boolean myShowTreeNodes;
    private final Project myProject;
    private PsiElement myRootPsiElement;
    private final Object myRootElement;

    public ViewerTreeStructure(@NotNull Project project) {
        if (project == null) {
            ViewerTreeStructure.$$$reportNull$$$0(0);
        }
        this.myShowWhiteSpaces = true;
        this.myShowTreeNodes = true;
        this.myRootElement = ObjectUtils.sentinel((String)"Psi Viewer Root");
        this.myProject = project;
    }

    public void setRootPsiElement(PsiElement rootPsiElement) {
        this.myRootPsiElement = rootPsiElement;
    }

    public PsiElement getRootPsiElement() {
        return this.myRootPsiElement;
    }

    @NotNull
    public Object getRootElement() {
        Object object = this.myRootElement;
        if (object == null) {
            ViewerTreeStructure.$$$reportNull$$$0(1);
        }
        return object;
    }

    public Object @NotNull [] getChildElements(@NotNull Object element) {
        if (element == null) {
            ViewerTreeStructure.$$$reportNull$$$0(2);
        }
        if (this.myRootElement == element) {
            if (this.myRootPsiElement == null) {
                if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                    ViewerTreeStructure.$$$reportNull$$$0(3);
                }
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            if (!(this.myRootPsiElement instanceof PsiFile)) {
                Object[] objectArray = new Object[]{this.myRootPsiElement};
                if (objectArray == null) {
                    ViewerTreeStructure.$$$reportNull$$$0(4);
                }
                return objectArray;
            }
            List files = ((PsiFile)this.myRootPsiElement).getViewProvider().getAllFiles();
            Object[] objectArray = PsiUtilCore.toPsiFileArray((Collection)files);
            if (objectArray == null) {
                ViewerTreeStructure.$$$reportNull$$$0(5);
            }
            return objectArray;
        }
        Object[] objectArray = (Object[])ApplicationManager.getApplication().runReadAction(() -> {
            if (this.myShowTreeNodes) {
                ASTNode root;
                ArrayList<ASTNode> list = new ArrayList<ASTNode>();
                Object object = element instanceof PsiElement ? SourceTreeToPsiMap.psiElementToTree((PsiElement)((PsiElement)element)) : (root = element instanceof ASTNode ? (ASTNode)element : null);
                if (element instanceof Inject) {
                    root = SourceTreeToPsiMap.psiElementToTree((PsiElement)((Inject)element).getPsi());
                }
                if (root != null) {
                    for (ASTNode child = root.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                        if (!this.myShowWhiteSpaces && child.getElementType() == TokenType.WHITE_SPACE) continue;
                        PsiElement childElement = child.getPsi();
                        list.add((ASTNode)(childElement == null ? child : childElement));
                    }
                    PsiElement psi = root.getPsi();
                    if (psi instanceof PsiLanguageInjectionHost) {
                        InjectedLanguageManager.getInstance((Project)this.myProject).enumerate(psi, (injectedPsi, places) -> list.add((ASTNode)new Inject(psi, (PsiElement)injectedPsi)));
                    }
                }
                return ArrayUtil.toObjectArray(list);
            }
            Object[] elementChildren = ((PsiElement)element).getChildren();
            if (!this.myShowWhiteSpaces) {
                ArrayList<Object> childrenList = new ArrayList<Object>(elementChildren.length);
                for (Object psiElement : elementChildren) {
                    if (psiElement instanceof PsiWhiteSpace) continue;
                    childrenList.add(psiElement);
                }
                return PsiUtilCore.toPsiElementArray(childrenList);
            }
            return elementChildren;
        });
        if (objectArray == null) {
            ViewerTreeStructure.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    public Object getParentElement(@NotNull Object element) {
        PsiLanguageInjectionHost host;
        if (element == null) {
            ViewerTreeStructure.$$$reportNull$$$0(7);
        }
        if (element == this.myRootElement) {
            return null;
        }
        if (element == this.myRootPsiElement) {
            return this.myRootElement;
        }
        if (element instanceof PsiFile && (host = InjectedLanguageManager.getInstance((Project)((PsiFile)element).getProject()).getInjectionHost((PsiElement)((PsiFile)element))) != null) {
            return new Inject((PsiElement)host, (PsiElement)element);
        }
        if (element instanceof Inject) {
            return ((Inject)element).getParent();
        }
        if (element instanceof PsiElement) {
            return ((PsiElement)element).getContext();
        }
        return null;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    @NotNull
    public NodeDescriptor<?> createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            ViewerTreeStructure.$$$reportNull$$$0(8);
        }
        if (element == this.myRootElement) {
            return new NodeDescriptor<Object>(this.myProject, null){

                public boolean update() {
                    return false;
                }

                public Object getElement() {
                    return ViewerTreeStructure.this.myRootElement;
                }
            };
        }
        return new ViewerNodeDescriptor(this.myProject, element, parentDescriptor);
    }

    public void setShowWhiteSpaces(boolean showWhiteSpaces) {
        this.myShowWhiteSpaces = showWhiteSpaces;
    }

    public void setShowTreeNodes(boolean showTreeNodes) {
        this.myShowTreeNodes = showTreeNodes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dev/psiViewer/ViewerTreeStructure";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dev/psiViewer/ViewerTreeStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    static class Inject {
        @NotNull
        private final PsiElement myParent;
        @NotNull
        private final PsiElement myPsi;

        Inject(@NotNull PsiElement parent, @NotNull PsiElement psi) {
            if (parent == null) {
                Inject.$$$reportNull$$$0(0);
            }
            if (psi == null) {
                Inject.$$$reportNull$$$0(1);
            }
            this.myParent = parent;
            this.myPsi = psi;
        }

        @NotNull
        public PsiElement getParent() {
            PsiElement psiElement = this.myParent;
            if (psiElement == null) {
                Inject.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        @NotNull
        public PsiElement getPsi() {
            PsiElement psiElement = this.myPsi;
            if (psiElement == null) {
                Inject.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        public String toString() {
            return "INJECTION " + String.valueOf(this.myPsi.getLanguage());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Inject inject = (Inject)o;
            if (!this.myParent.equals((Object)inject.myParent)) {
                return false;
            }
            return this.myPsi.equals((Object)inject.myPsi);
        }

        public int hashCode() {
            int result = this.myParent.hashCode();
            result = 31 * result + this.myPsi.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dev/psiViewer/ViewerTreeStructure$Inject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dev/psiViewer/ViewerTreeStructure$Inject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsi";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

