/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewEmptyTreeSuggestion;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.execution.serviceView.AddServiceEmptyTreeSuggestion;
import com.intellij.platform.execution.serviceView.ServiceModel;
import com.intellij.platform.execution.serviceView.ServiceView;
import com.intellij.platform.execution.serviceView.ServiceViewActionProvider;
import com.intellij.platform.execution.serviceView.ServiceViewDragHelper;
import com.intellij.platform.execution.serviceView.ServiceViewManagerImpl;
import com.intellij.platform.execution.serviceView.ServiceViewModel;
import com.intellij.platform.execution.serviceView.ServiceViewNavBarPanel;
import com.intellij.platform.execution.serviceView.ServiceViewNavBarService;
import com.intellij.platform.execution.serviceView.ServiceViewState;
import com.intellij.platform.execution.serviceView.ServiceViewTree;
import com.intellij.platform.execution.serviceView.ServiceViewTreeModel;
import com.intellij.platform.execution.serviceView.ServiceViewUi;
import com.intellij.platform.navbar.frontend.vm.NavBarVm;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

final class ServiceTreeView
extends ServiceView {
    private final ServiceViewTree myTree;
    private final ServiceViewTreeModel myTreeModel;
    private final ServiceViewModel.ServiceViewModelListener myListener;
    private final ServiceViewNavBarPanel myNavBarPanel;
    private volatile ServiceModel.ServiceViewItem myLastSelection;
    private boolean mySelected;
    private volatile Promise<?> myUpdateSelectionPromise;

    ServiceTreeView(@NotNull Project project, @NotNull ServiceViewModel model, @NotNull ServiceViewUi ui, @NotNull ServiceViewState state) {
        if (project == null) {
            ServiceTreeView.$$$reportNull$$$0(0);
        }
        if (model == null) {
            ServiceTreeView.$$$reportNull$$$0(1);
        }
        if (ui == null) {
            ServiceTreeView.$$$reportNull$$$0(2);
        }
        if (state == null) {
            ServiceTreeView.$$$reportNull$$$0(3);
        }
        super(new BorderLayout(), project, model, ui);
        this.myTreeModel = new ServiceViewTreeModel(model);
        this.myTree = new ServiceViewTree((TreeModel)((Object)this.myTreeModel), this);
        ServiceViewActionProvider actionProvider = ServiceViewActionProvider.getInstance();
        ui.setServiceToolbar(actionProvider);
        ui.setMasterComponent((JComponent)((Object)this.myTree), actionProvider);
        this.myTree.setDragEnabled(true);
        DnDManager.getInstance().registerSource(ServiceViewDragHelper.createSource(this), (JComponent)((Object)this.myTree));
        DnDManager.getInstance().registerTarget(ServiceViewDragHelper.createTarget((JTree)((Object)this.myTree)), (JComponent)((Object)this.myTree));
        this.add((Component)this.myUi.getComponent(), "Center");
        this.myTree.addTreeSelectionListener((TreeSelectionListener)new RestoreSelectionListener());
        this.myTree.addTreeSelectionListener(e -> this.onSelectionChanged());
        ServiceViewNavBarService.ServiceViewNavBarSelector selector = new ServiceViewNavBarService.ServiceViewNavBarSelector(){

            @Override
            public void select(@NotNull ServiceModel.ServiceViewItem item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                ServiceTreeView.this.select(item.getValue(), item.getRootContributor().getClass()).onSuccess(result -> ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)ServiceTreeView.this)).submit(() -> {
                    JComponent component = ServiceTreeView.this.getUi().getDetailsComponent();
                    if (component != null) {
                        IdeFocusManager.getInstance((Project)ServiceTreeView.this.getProject()).requestFocus((Component)component, false);
                    }
                }));
            }

            @Override
            @Nullable
            public ServiceModel.ServiceViewItem getSelectedItem() {
                return ServiceTreeView.this.myLastSelection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/platform/execution/serviceView/ServiceTreeView$1", "select"));
            }
        };
        this.myNavBarPanel = ServiceViewNavBarService.getInstance(project).createNavBarPanel(this, selector);
        this.myUi.setNavBar((JComponent)((Object)this.myNavBarPanel));
        this.myListener = new ServiceViewTreeModelListener();
        model.addModelListener(this.myListener);
        if (model instanceof ServiceViewModel.AllServicesModel) {
            ServiceTreeView.setEmptyText((JComponent)((Object)this.myTree), this.myTree.getEmptyText());
        }
        if (state.expandedPaths.isEmpty()) {
            state.treeState.applyTo((JTree)((Object)this.myTree), this.myTreeModel.getRoot());
        } else {
            HashSet<? extends ServiceModel.ServiceViewItem> roots = new HashSet<ServiceModel.ServiceViewItem>(model.getVisibleRoots());
            List<TreePath> adjusted = ServiceTreeView.adjustPaths(state.expandedPaths, roots, this.myTreeModel.getRoot());
            if (!adjusted.isEmpty()) {
                TreeUtil.promiseExpand((JTree)((Object)this.myTree), (TreeVisitor)new PathExpandVisitor(adjusted));
            }
        }
    }

    @Override
    public void dispose() {
        this.getModel().removeModelListener(this.myListener);
        super.dispose();
    }

    @Override
    void saveState(@NotNull ServiceViewState state) {
        if (state == null) {
            ServiceTreeView.$$$reportNull$$$0(4);
        }
        super.saveState(state);
        this.myUi.saveState(state);
        state.treeState = TreeState.createOn((JTree)((Object)this.myTree));
        state.expandedPaths = TreeUtil.collectExpandedPaths((JTree)((Object)this.myTree));
    }

    @Override
    @NotNull
    @Unmodifiable List<ServiceModel.ServiceViewItem> getSelectedItems() {
        int[] rows = this.myTree.getSelectionRows();
        if (rows == null || rows.length == 0) {
            List<ServiceModel.ServiceViewItem> list = Collections.emptyList();
            if (list == null) {
                ServiceTreeView.$$$reportNull$$$0(5);
            }
            return list;
        }
        List objects = TreeUtil.collectSelectedUserObjects((JTree)((Object)this.myTree));
        if (objects.size() != rows.length) {
            List list = ContainerUtil.mapNotNull((Collection)objects, o -> (ServiceModel.ServiceViewItem)ObjectUtils.tryCast((Object)o, ServiceModel.ServiceViewItem.class));
            if (list == null) {
                ServiceTreeView.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<Pair> objectRows = new ArrayList<Pair>();
        for (int i = 0; i < rows.length; ++i) {
            objectRows.add(Pair.create(objects.get(i), (Object)rows[i]));
        }
        objectRows.sort(Pair.comparingBySecond());
        List list = ContainerUtil.mapNotNull(objectRows, pair -> (ServiceModel.ServiceViewItem)ObjectUtils.tryCast((Object)pair.first, ServiceModel.ServiceViewItem.class));
        if (list == null) {
            ServiceTreeView.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    Promise<Void> select(@NotNull Object service, @NotNull Class<?> contributorClass) {
        if (service == null) {
            ServiceTreeView.$$$reportNull$$$0(8);
        }
        if (contributorClass == null) {
            ServiceTreeView.$$$reportNull$$$0(9);
        }
        return this.doSelect(service, contributorClass, false);
    }

    private Promise<Void> selectSafe(@NotNull Object service, @NotNull Class<?> contributorClass) {
        if (service == null) {
            ServiceTreeView.$$$reportNull$$$0(10);
        }
        if (contributorClass == null) {
            ServiceTreeView.$$$reportNull$$$0(11);
        }
        return this.doSelect(service, contributorClass, true);
    }

    private Promise<Void> doSelect(@NotNull Object service, @NotNull Class<?> contributorClass, boolean safe) {
        ServiceModel.ServiceViewItem selectedItem;
        if (service == null) {
            ServiceTreeView.$$$reportNull$$$0(12);
        }
        if (contributorClass == null) {
            ServiceTreeView.$$$reportNull$$$0(13);
        }
        if ((selectedItem = this.myLastSelection) == null || !selectedItem.getValue().equals(service)) {
            AsyncPromise result = new AsyncPromise();
            Promise<TreePath> pathPromise = safe ? this.myTreeModel.findPathSafe(service, contributorClass) : this.myTreeModel.findPath(service, contributorClass);
            pathPromise.onError(arg_0 -> ((AsyncPromise)result).setError(arg_0)).onSuccess(path -> {
                TreeUtil.promiseSelect((JTree)((Object)this.myTree), (TreeVisitor)new PathSelectionVisitor((TreePath)path)).onError(arg_0 -> ((AsyncPromise)result).setError(arg_0)).onSuccess(selectedPath -> {
                    result.setResult(null);
                    this.cancelSelectionUpdate();
                });
                this.cancelSelectionUpdate();
            });
            return result;
        }
        return Promises.resolvedPromise();
    }

    @Override
    Promise<Void> expand(@NotNull Object service, @NotNull Class<?> contributorClass) {
        if (service == null) {
            ServiceTreeView.$$$reportNull$$$0(14);
        }
        if (contributorClass == null) {
            ServiceTreeView.$$$reportNull$$$0(15);
        }
        AsyncPromise result = new AsyncPromise();
        this.myTreeModel.findPath(service, contributorClass).onError(arg_0 -> ((AsyncPromise)result).setError(arg_0)).onSuccess(path -> TreeUtil.promiseExpand((JTree)((Object)this.myTree), (TreeVisitor)new PathSelectionVisitor((TreePath)path)).onError(arg_0 -> ((AsyncPromise)result).setError(arg_0)).onSuccess(expandedPath -> result.setResult(null)));
        return result;
    }

    @Override
    Promise<Void> extract(@NotNull Object service, @NotNull Class<?> contributorClass) {
        if (service == null) {
            ServiceTreeView.$$$reportNull$$$0(16);
        }
        if (contributorClass == null) {
            ServiceTreeView.$$$reportNull$$$0(17);
        }
        AsyncPromise result = new AsyncPromise();
        this.myTreeModel.findPath(service, contributorClass).onError(arg_0 -> ((AsyncPromise)result).setError(arg_0)).onSuccess(path -> {
            ServiceModel.ServiceNode node;
            ServiceModel.ServiceViewItem item = (ServiceModel.ServiceViewItem)path.getLastPathComponent();
            if (item instanceof ServiceModel.ServiceNode && (node = (ServiceModel.ServiceNode)item).isLoaded() && !node.isChildrenInitialized()) {
                node.getChildren();
            }
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this)).submit(() -> {
                ServiceViewManagerImpl manager = (ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)this.getProject());
                manager.extract(new ServiceViewDragHelper.ServiceViewDragBean(this, Collections.singletonList(item)));
                result.setResult(null);
            });
        });
        return result;
    }

    @Override
    void onViewSelected() {
        this.mySelected = true;
        if (this.myLastSelection != null) {
            ServiceViewDescriptor descriptor = this.myLastSelection.getViewDescriptor();
            this.onViewSelected(descriptor);
            this.myUi.setDetailsComponentVisible(descriptor.isContentPartVisible());
            this.myUi.setDetailsComponent(descriptor.getContentComponent());
        } else {
            this.myUi.setDetailsComponent(null);
        }
    }

    @Override
    void onViewUnselected() {
        this.mySelected = false;
        if (this.myLastSelection != null) {
            this.myLastSelection.getViewDescriptor().onNodeUnselected();
        }
    }

    @Override
    void jumpToServices() {
        if (this.myTree.isShowing()) {
            IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)((Object)this.myTree), false);
        } else {
            NavBarVm vm = this.myNavBarPanel.getModel();
            if (vm != null) {
                this.myNavBarPanel.updateModel();
                vm.selectTail(false);
            }
        }
    }

    private void onSelectionChanged() {
        ServiceViewDescriptor oldDescriptor;
        ServiceViewDescriptor newDescriptor;
        ServiceModel.ServiceViewItem newSelection;
        List<ServiceModel.ServiceViewItem> selected = this.getSelectedItems();
        if (selected.size() == 1) {
            newSelection = selected.get(0);
            newDescriptor = newSelection.getViewDescriptor();
        } else {
            newSelection = null;
            ServiceViewContributor contributor = ServiceViewDragHelper.getTheOnlyRootContributor(selected);
            ServiceViewDescriptor serviceViewDescriptor = newDescriptor = contributor == null ? null : contributor.getViewDescriptor(this.getProject());
        }
        if (newSelection != null && newSelection.equals(this.myLastSelection)) {
            return;
        }
        ServiceViewDescriptor serviceViewDescriptor = oldDescriptor = this.myLastSelection == null ? null : this.myLastSelection.getViewDescriptor();
        if (Comparing.equal((Object)newDescriptor, (Object)oldDescriptor)) {
            return;
        }
        if (oldDescriptor != null && this.mySelected) {
            oldDescriptor.onNodeUnselected();
        }
        this.myLastSelection = newSelection;
        this.myNavBarPanel.updateModel();
        if (!this.mySelected) {
            return;
        }
        if (newDescriptor != null) {
            newDescriptor.onNodeSelected(ContainerUtil.map(selected, ServiceModel.ServiceViewItem::getValue));
        }
        if (newDescriptor != null) {
            this.myUi.setDetailsComponentVisible(newDescriptor.isContentPartVisible());
        }
        this.myUi.setDetailsComponent(newDescriptor == null ? null : newDescriptor.getContentComponent());
    }

    private void selectFirstItemIfNeeded() {
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this)).submit(() -> {
            ServiceModel.ServiceViewItem item;
            List<ServiceModel.ServiceViewItem> selected = this.getSelectedItems();
            if (selected.isEmpty() && (item = (ServiceModel.ServiceViewItem)ContainerUtil.getFirstItem(this.getModel().getRoots())) != null) {
                this.select(item.getValue(), item.getRootContributor().getClass());
            }
        });
    }

    private void updateLastSelection() {
        ServiceModel.ServiceViewItem lastSelection = this.myLastSelection;
        WeakReference<Object> itemRef = new WeakReference<Object>((lastSelection == null ? null : this.getModel().findItemSafe(lastSelection)));
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this)).submit(() -> {
            ServiceModel.ServiceViewItem item;
            List<ServiceModel.ServiceViewItem> selected = this.getSelectedItems();
            if (selected.isEmpty() && (item = (ServiceModel.ServiceViewItem)ContainerUtil.getFirstItem(this.getModel().getRoots())) != null) {
                this.selectSafe(item.getValue(), item.getRootContributor().getClass());
                return;
            }
            ServiceModel.ServiceViewItem updatedItem = (ServiceModel.ServiceViewItem)itemRef.get();
            ServiceModel.ServiceViewItem newSelection = (ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(selected);
            if (Comparing.equal((Object)newSelection, (Object)updatedItem)) {
                newSelection = updatedItem;
            }
            if (Comparing.equal((Object)newSelection, (Object)this.myLastSelection)) {
                this.myLastSelection = newSelection;
                if (this.mySelected && (updatedItem == null || !updatedItem.isRemoved())) {
                    ServiceViewDescriptor descriptor;
                    ServiceViewDescriptor serviceViewDescriptor = descriptor = newSelection == null || newSelection.isRemoved() && updatedItem == null ? null : newSelection.getViewDescriptor();
                    if (descriptor != null) {
                        this.myUi.setDetailsComponentVisible(descriptor.isContentPartVisible());
                    }
                    this.myUi.setDetailsComponent(descriptor == null ? null : descriptor.getContentComponent());
                }
            }
        });
    }

    private void updateSelectionPaths() {
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this)).submit(() -> {
            TreePath[] currentPaths = this.myTree.getSelectionPaths();
            List selectedPaths = currentPaths == null || currentPaths.length == 0 ? Collections.emptyList() : Arrays.asList(currentPaths);
            this.myTreeModel.rootsChanged();
            if (selectedPaths.isEmpty()) {
                return;
            }
            this.myTreeModel.getInvoker().invokeLater(() -> {
                List pathPromises = ContainerUtil.mapNotNull((Collection)selectedPaths, path -> {
                    ServiceModel.ServiceViewItem item = (ServiceModel.ServiceViewItem)ObjectUtils.tryCast((Object)path.getLastPathComponent(), ServiceModel.ServiceViewItem.class);
                    return item == null ? null : this.myTreeModel.findPathSafe(item.getValue(), item.getRootContributor().getClass());
                });
                Promises.collectResults((Collection)pathPromises, (boolean)true).onProcessed(paths -> {
                    if (paths != null && !paths.isEmpty()) {
                        if (!paths.equals(selectedPaths)) {
                            Promise newSelectPromise = TreeUtil.promiseSelect((JTree)((Object)this.myTree), paths.stream().map(PathSelectionVisitor::new));
                            this.cancelSelectionUpdate();
                            if (newSelectPromise instanceof AsyncPromise) {
                                ((AsyncPromise)newSelectPromise).onError(t -> {
                                    if (t instanceof CancellationException) {
                                        TreeUtil.promiseExpand((JTree)((Object)this.myTree), paths.stream().map(path -> new PathSelectionVisitor(path.getParentPath())));
                                    }
                                });
                            }
                            this.myUpdateSelectionPromise = newSelectPromise;
                        } else {
                            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this)).submit(() -> {
                                Object[] selectionPaths = this.myTree.getSelectionPaths();
                                if (selectionPaths != null && ServiceTreeView.isSelectionUpdateNeeded((List<? extends TreePath>)new SmartList(selectionPaths), paths)) {
                                    this.myTree.setSelectionPaths(paths.toArray(new TreePath[0]));
                                }
                            });
                        }
                    }
                });
            });
        });
    }

    private static boolean isSelectionUpdateNeeded(List<? extends TreePath> selectionPaths, List<? extends TreePath> updatedPaths) {
        if (selectionPaths.size() != updatedPaths.size()) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < selectionPaths.size(); ++i) {
            TreePath selectionPath = selectionPaths.get(i);
            TreePath updatedPath = updatedPaths.get(i);
            do {
                Object updatedComponent;
                if (updatedPath == null) {
                    return false;
                }
                Object selectedComponent = selectionPath.getLastPathComponent();
                if (selectedComponent != (updatedComponent = updatedPath.getLastPathComponent())) {
                    if (!selectedComponent.equals(updatedComponent)) {
                        return false;
                    }
                    result = true;
                }
                selectionPath = selectionPath.getParentPath();
                updatedPath = updatedPath.getParentPath();
            } while (selectionPath != null);
            if (updatedPath == null) continue;
            return false;
        }
        return result;
    }

    @Override
    void setAutoScrollToSourceHandler(@NotNull AutoScrollToSourceHandler autoScrollToSourceHandler) {
        if (autoScrollToSourceHandler == null) {
            ServiceTreeView.$$$reportNull$$$0(18);
        }
        super.setAutoScrollToSourceHandler(autoScrollToSourceHandler);
        autoScrollToSourceHandler.install((JTree)((Object)this.myTree));
    }

    @Override
    @Unmodifiable List<Object> getChildrenSafe(@NotNull List<Object> valueSubPath, @NotNull Class<?> contributorClass) {
        LinkedList<Object> values;
        Object visibleRoot;
        if (valueSubPath == null) {
            ServiceTreeView.$$$reportNull$$$0(19);
        }
        if (contributorClass == null) {
            ServiceTreeView.$$$reportNull$$$0(20);
        }
        if ((visibleRoot = (values = new LinkedList<Object>(valueSubPath)).poll()) == null) {
            return Collections.emptyList();
        }
        List<? extends ServiceModel.ServiceViewItem> roots = this.getModel().getVisibleRoots();
        ServiceModel.ServiceViewItem item = (ServiceModel.ServiceViewItem)((JBTreeTraverser)JBTreeTraverser.from(node -> contributorClass.isInstance(node.getRootContributor()) ? new ArrayList<ServiceModel.ServiceViewItem>(this.getModel().getChildren((ServiceModel.ServiceViewItem)node)) : null).withRoots(roots)).traverse(ServiceModel.ONLY_LOADED_BFS).filter(node -> node.getValue().equals(visibleRoot)).first();
        if (item == null) {
            return Collections.emptyList();
        }
        while (!values.isEmpty()) {
            Object value = values.poll();
            item = (ServiceModel.ServiceViewItem)ContainerUtil.find(this.getModel().getChildren(item), child -> value.equals(child.getValue()));
            if (item != null) continue;
            return Collections.emptyList();
        }
        return ContainerUtil.map(this.getModel().getChildren(item), ServiceModel.ServiceViewItem::getValue);
    }

    private void cancelSelectionUpdate() {
        Promise<?> selectPromise = this.myUpdateSelectionPromise;
        if (selectPromise instanceof AsyncPromise) {
            ((AsyncPromise)selectPromise).cancel();
        }
    }

    private static void setEmptyText(JComponent component, StatusText emptyText) {
        emptyText.withUnscaledGapAfter(5);
        emptyText.setText(ExecutionBundle.message((String)"service.view.empty.tree.text", (Object[])new Object[0]));
        List<ServiceViewEmptyTreeSuggestion> sortedSuggestions = ServiceTreeView.getEmptyTreeSuggestions();
        for (int i = 0; i < sortedSuggestions.size(); ++i) {
            ServiceViewEmptyTreeSuggestion suggestion = sortedSuggestions.get(i);
            String suggestionText = suggestion.getText();
            Icon icon = suggestion.getIcon();
            emptyText.appendText(0, i + 1, icon, suggestionText, SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> {
                InputEvent ie;
                Object patt0$temp = e.getSource();
                InputEvent inputEvent = patt0$temp instanceof InputEvent ? (ie = (InputEvent)patt0$temp) : null;
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)component);
                suggestion.onActivate(dataContext, inputEvent);
            });
            String shortcutText = suggestion.getShortcutText();
            if (shortcutText == null) continue;
            String paddedText = " " + shortcutText;
            emptyText.appendText(0, i + 1, icon, paddedText, SimpleTextAttributes.GRAYED_ATTRIBUTES, null);
        }
    }

    @NotNull
    private static List<ServiceViewEmptyTreeSuggestion> getEmptyTreeSuggestions() {
        List externalSuggestions = ContainerUtil.mapNotNull((Collection)ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList(), ServiceViewContributor::getEmptyTreeSuggestion);
        List allSuggestions = ContainerUtil.append((List)externalSuggestions, (Object[])new ServiceViewEmptyTreeSuggestion[]{new AddServiceEmptyTreeSuggestion()});
        Comparator<ServiceViewEmptyTreeSuggestion> highWeightFirst = Comparator.comparingInt(ServiceViewEmptyTreeSuggestion::getWeight).reversed();
        List list = ContainerUtil.sorted((Collection)allSuggestions, highWeightFirst);
        if (list == null) {
            ServiceTreeView.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static List<TreePath> adjustPaths(List<? extends TreePath> paths, Collection<? extends ServiceModel.ServiceViewItem> roots, Object treeRoot) {
        SmartList result = new SmartList();
        block0: for (TreePath treePath : paths) {
            Object[] items = treePath.getPath();
            for (int i = 1; i < items.length; ++i) {
                if (!roots.contains(items[i])) continue;
                Object[] adjustedItems = ArrayUtil.insert((Object[])items, (int)0, (Object)treeRoot);
                result.add(new TreePath(adjustedItems));
                continue block0;
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceTreeView";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoScrollToSourceHandler";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSubPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceTreeView";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedItems";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyTreeSuggestions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 21: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "selectSafe";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doSelect";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setAutoScrollToSourceHandler";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenSafe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 21 -> new IllegalStateException(string);
        };
    }

    private final class ServiceViewTreeModelListener
    implements ServiceViewModel.ServiceViewModelListener {
        private ServiceViewTreeModelListener() {
        }

        @Override
        public void eventProcessed(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ServiceEventListener.ServiceEvent e) {
            if (e == null) {
                ServiceViewTreeModelListener.$$$reportNull$$$0(0);
            }
            if (e.type == ServiceEventListener.EventType.UNLOAD_SYNC_RESET) {
                ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)ServiceTreeView.this)).submit(() -> {
                    this.resetTreeModel();
                    this.updateNavBar();
                });
                ServiceTreeView.this.updateLastSelection();
            } else {
                this.updateNavBar();
                ServiceModel.ServiceViewItem lastSelection = ServiceTreeView.this.myLastSelection;
                if (lastSelection != null && lastSelection.getRootContributor().getClass().equals(e.contributorClass)) {
                    ServiceTreeView.this.updateLastSelection();
                } else {
                    ServiceTreeView.this.selectFirstItemIfNeeded();
                }
            }
            ServiceTreeView.this.updateSelectionPaths();
        }

        @Override
        public void structureChanged() {
            ServiceTreeView.this.selectFirstItemIfNeeded();
            ServiceTreeView.this.updateSelectionPaths();
        }

        private void resetTreeModel() {
            TreeModel model = ServiceTreeView.this.myTree.getModel();
            if (model instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)model));
            }
            ServiceTreeView.this.myTree.setModel(null);
            AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)((Object)ServiceTreeView.this.myTreeModel), (Disposable)ServiceTreeView.this);
            ServiceTreeView.this.myTree.setModel((TreeModel)asyncTreeModel);
        }

        private void updateNavBar() {
            ServiceTreeView.this.myNavBarPanel.updateModel();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/platform/execution/serviceView/ServiceTreeView$ServiceViewTreeModelListener", "eventProcessed"));
        }
    }

    private static final class PathExpandVisitor
    implements TreeVisitor {
        private final List<? extends TreePath> myPaths;

        PathExpandVisitor(List<? extends TreePath> paths) {
            this.myPaths = paths;
        }

        @NotNull
        public TreeVisitor.Action visit(@NotNull TreePath path) {
            if (path == null) {
                PathExpandVisitor.$$$reportNull$$$0(0);
            }
            if (path.getParentPath() == null) {
                TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                if (action == null) {
                    PathExpandVisitor.$$$reportNull$$$0(1);
                }
                return action;
            }
            for (TreePath treePath : this.myPaths) {
                if (!treePath.equals(path)) continue;
                this.myPaths.remove(treePath);
                TreeVisitor.Action action = this.myPaths.isEmpty() ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
                if (action == null) {
                    PathExpandVisitor.$$$reportNull$$$0(2);
                }
                return action;
            }
            TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
            if (action == null) {
                PathExpandVisitor.$$$reportNull$$$0(3);
            }
            return action;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceTreeView$PathExpandVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceTreeView$PathExpandVisitor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class PathSelectionVisitor
    implements TreeVisitor {
        private final Queue<Object> myPath;

        PathSelectionVisitor(TreePath path) {
            this.myPath = ContainerUtil.newLinkedList((Object[])path.getPath());
        }

        @NotNull
        public TreeVisitor.Action visit(@NotNull TreePath path) {
            Object node;
            if (path == null) {
                PathSelectionVisitor.$$$reportNull$$$0(0);
            }
            if ((node = path.getLastPathComponent()).equals(this.myPath.peek())) {
                this.myPath.poll();
                TreeVisitor.Action action = this.myPath.isEmpty() ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
                if (action == null) {
                    PathSelectionVisitor.$$$reportNull$$$0(1);
                }
                return action;
            }
            TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
            if (action == null) {
                PathSelectionVisitor.$$$reportNull$$$0(2);
            }
            return action;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceTreeView$PathSelectionVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceTreeView$PathSelectionVisitor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

