/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.action;

import com.intellij.debugger.streams.core.lib.LibrarySupportProvider;
import com.intellij.debugger.streams.core.wrapper.StreamChain;
import com.intellij.debugger.streams.shared.ChainStatus;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0003\u000f\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/debugger/streams/core/action/ChainResolver;", "", "<init>", "()V", "mySearchResult", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/debugger/streams/core/action/ChainResolver$ChainsSearchResult;", "tryFindChain", "Lcom/intellij/debugger/streams/shared/ChainStatus;", "elementAtDebugger", "Lcom/intellij/psi/PsiElement;", "getChains", "", "Lcom/intellij/debugger/streams/core/action/ChainResolver$StreamChainWithLibrary;", "getChains$intellij_debugger_streams_core", "StreamChainWithLibrary", "ChainsSearchResult", "Companion", "intellij.debugger.streams.core"})
@SourceDebugExtension(value={"SMAP\nChainResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChainResolver.kt\ncom/intellij/debugger/streams/core/action/ChainResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1563#2:140\n1634#2,3:141\n*S KotlinDebug\n*F\n+ 1 ChainResolver.kt\ncom/intellij/debugger/streams/core/action/ChainResolver\n*L\n46#1:140\n46#1:141,3\n*E\n"})
public final class ChainResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<ChainsSearchResult> mySearchResult = new AtomicReference<ChainsSearchResult>(new ChainsSearchResult(0L, -1L, null));
    @NotNull
    private static final Logger LOG;

    @NotNull
    public final ChainStatus tryFindChain(@NotNull PsiElement elementAtDebugger) {
        Intrinsics.checkNotNullParameter((Object)elementAtDebugger, (String)"elementAtDebugger");
        ChainsSearchResult result = this.mySearchResult.get();
        if (result.isSuitableFor(elementAtDebugger)) {
            return result.getChainsStatus();
        }
        result = ChainsSearchResult.Companion.of(elementAtDebugger);
        ChainResolver.Companion.checkChainsExistenceInBackground(elementAtDebugger, result);
        this.mySearchResult.set(result);
        return result.getChainsStatus();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<StreamChainWithLibrary> getChains$intellij_debugger_streams_core(@NotNull PsiElement elementAtDebugger) {
        Intrinsics.checkNotNullParameter((Object)elementAtDebugger, (String)"elementAtDebugger");
        ChainsSearchResult result = this.mySearchResult.get();
        if (!result.isSuitableFor(elementAtDebugger) || result.getChainsStatus() != ChainStatus.FOUND) {
            LOG.error("Cannot build chains: " + result.getChainsStatus());
            return CollectionsKt.emptyList();
        }
        String string = elementAtDebugger.getLanguage().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        String elementLanguageId = string;
        LibrarySupportProvider provider = (LibrarySupportProvider)LibrarySupportProvider.EP_NAME.findFirstSafe(arg_0 -> ChainResolver.getChains$lambda$1(arg_0 -> ChainResolver.getChains$lambda$0(elementLanguageId, elementAtDebugger, arg_0), arg_0));
        if (provider != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = provider.getChainBuilder().build(elementAtDebugger);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StreamChain streamChain = (StreamChain)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new StreamChainWithLibrary((StreamChain)it, provider));
            }
            List result2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            return result2;
        }
        return CollectionsKt.emptyList();
    }

    private static final boolean getChains$lambda$0(String $elementLanguageId, PsiElement $elementAtDebugger, LibrarySupportProvider it) {
        return Intrinsics.areEqual((Object)it.getLanguageId(), (Object)$elementLanguageId) && it.getChainBuilder().isChainExists($elementAtDebugger);
    }

    private static final boolean getChains$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(ChainResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0015J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/intellij/debugger/streams/core/action/ChainResolver$ChainsSearchResult;", "", "elementHash", "", "offset", "containingFile", "Lcom/intellij/psi/PsiFile;", "<init>", "(JJLcom/intellij/psi/PsiFile;)V", "getElementHash", "()J", "getOffset", "fileModificationStamp", "getFileModificationStamp", "chainsStatus", "Lcom/intellij/debugger/streams/shared/ChainStatus;", "getChainsStatus", "()Lcom/intellij/debugger/streams/shared/ChainStatus;", "setChainsStatus", "(Lcom/intellij/debugger/streams/shared/ChainStatus;)V", "updateStatus", "", "found", "", "markUnsupportedLanguage", "isSuitableFor", "element", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.debugger.streams.core"})
    private static final class ChainsSearchResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long elementHash;
        private final long offset;
        private final long fileModificationStamp;
        @NotNull
        private volatile ChainStatus chainsStatus;

        public ChainsSearchResult(long elementHash, long offset, @Nullable PsiFile containingFile) {
            this.elementHash = elementHash;
            this.offset = offset;
            this.chainsStatus = ChainStatus.COMPUTING;
            this.fileModificationStamp = ChainsSearchResult.Companion.getModificationStamp(containingFile);
        }

        public final long getElementHash() {
            return this.elementHash;
        }

        public final long getOffset() {
            return this.offset;
        }

        public final long getFileModificationStamp() {
            return this.fileModificationStamp;
        }

        @NotNull
        public final ChainStatus getChainsStatus() {
            return this.chainsStatus;
        }

        public final void setChainsStatus(@NotNull ChainStatus chainStatus) {
            Intrinsics.checkNotNullParameter((Object)chainStatus, (String)"<set-?>");
            this.chainsStatus = chainStatus;
        }

        public final void updateStatus(boolean found) {
            LOG.assertTrue(ChainStatus.COMPUTING == this.chainsStatus);
            this.chainsStatus = found ? ChainStatus.FOUND : ChainStatus.NOT_FOUND;
        }

        public final void markUnsupportedLanguage() {
            LOG.assertTrue(ChainStatus.COMPUTING == this.chainsStatus);
            this.chainsStatus = ChainStatus.LANGUAGE_NOT_SUPPORTED;
        }

        public final boolean isSuitableFor(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.elementHash == (long)element.hashCode() && this.offset == (long)element.getTextOffset() && this.fileModificationStamp == ChainsSearchResult.Companion.getModificationStamp(element.getContainingFile());
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/streams/core/action/ChainResolver$ChainsSearchResult$Companion;", "", "<init>", "()V", "getModificationStamp", "", "file", "Lcom/intellij/psi/PsiFile;", "of", "Lcom/intellij/debugger/streams/core/action/ChainResolver$ChainsSearchResult;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.debugger.streams.core"})
        public static final class Companion {
            private Companion() {
            }

            private final long getModificationStamp(PsiFile file) {
                PsiFile psiFile = file;
                return psiFile == null ? -1L : psiFile.getModificationStamp();
            }

            @NotNull
            public final ChainsSearchResult of(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return new ChainsSearchResult(element.hashCode(), element.getTextOffset(), element.getContainingFile());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/debugger/streams/core/action/ChainResolver$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkChainsExistenceInBackground", "", "elementAtDebugger", "Lcom/intellij/psi/PsiElement;", "searchResult", "Lcom/intellij/debugger/streams/core/action/ChainResolver$ChainsSearchResult;", "forLanguage", "", "Lcom/intellij/debugger/streams/core/lib/LibrarySupportProvider;", "language", "Lcom/intellij/lang/Language;", "intellij.debugger.streams.core"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresBackgroundThread
        private final void checkChainsExistenceInBackground(PsiElement elementAtDebugger, ChainsSearchResult searchResult) {
            Language language = elementAtDebugger.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            List<LibrarySupportProvider> extensions = this.forLanguage(language);
            if (extensions.isEmpty()) {
                searchResult.markUnsupportedLanguage();
            } else {
                ReadAction.nonBlocking(() -> Companion.checkChainsExistenceInBackground$lambda$0(extensions, elementAtDebugger, searchResult)).inSmartMode(elementAtDebugger.getProject()).executeSynchronously();
            }
        }

        private final List<LibrarySupportProvider> forLanguage(Language language) {
            String string = language.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            return LibrarySupportProvider.EP_NAME.getByGroupingKey((Object)string, ChainResolver.class, Companion::forLanguage$lambda$0);
        }

        private static final void checkChainsExistenceInBackground$lambda$0(List $extensions, PsiElement $elementAtDebugger, ChainsSearchResult $searchResult) {
            boolean found = false;
            for (LibrarySupportProvider provider : $extensions) {
                try {
                    if (!provider.getChainBuilder().isChainExists($elementAtDebugger)) continue;
                    found = true;
                    break;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (PsiInvalidElementAccessException e) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Chains found:" + found);
            }
            $searchResult.updateStatus(found);
        }

        private static final String forLanguage$lambda$0(LibrarySupportProvider obj) {
            LibrarySupportProvider librarySupportProvider = obj;
            Intrinsics.checkNotNull((Object)librarySupportProvider);
            return librarySupportProvider.getLanguageId();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/streams/core/action/ChainResolver$StreamChainWithLibrary;", "", "chain", "Lcom/intellij/debugger/streams/core/wrapper/StreamChain;", "provider", "Lcom/intellij/debugger/streams/core/lib/LibrarySupportProvider;", "<init>", "(Lcom/intellij/debugger/streams/core/wrapper/StreamChain;Lcom/intellij/debugger/streams/core/lib/LibrarySupportProvider;)V", "intellij.debugger.streams.core"})
    public static final class StreamChainWithLibrary {
        @JvmField
        @NotNull
        public final StreamChain chain;
        @JvmField
        @NotNull
        public final LibrarySupportProvider provider;

        public StreamChainWithLibrary(@NotNull StreamChain chain, @NotNull LibrarySupportProvider provider) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            this.chain = chain;
            this.provider = provider;
        }
    }
}

