# frozen_string_literal: true

module GitlabQuality
  module TestTooling
    module GitlabClient
      class GroupLabelsClient < GitlabClient
        def initialize(token:, group:, endpoint: nil, **_kwargs)
          @token = token
          @group = group
          @endpoint = endpoint
        end

        def group_labels(options: {})
          client.group_labels(group, options)
        end

        def create_group_label(name:, color: '#428BCA', description: nil)
          client.create_group_label(group, name, color, description: description)
        end

        private

        attr_reader :group, :token, :endpoint

        def client
          @client ||= Gitlab.client(
            endpoint: endpoint || ENV['GITLAB_API_BASE'] || Runtime::Env.gitlab_api_base,
            private_token: token
          )
        end
      end
    end
  end
end
