---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンのSlackボットユーザーOAuthトークンの漏洩'
---

## 説明 {#description}

応答本文に、SlackボットユーザーのOAuthトークンのパターンに一致するコンテンツが含まれていることが判明しました。Slackアプリの機能と権限は、リクエストするスコープによって管理されます。権限の完全なリストは、[Slackのスコープに関するドキュメント](https://api.slack.com/scopes)に記載されています。このトークンにアクセスできる悪意のある攻撃者は、割り当てられた機能を実行できます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

漏洩したキーに関するセキュリティインシデントの処理に関する一般的なガイダンスについては、[認証情報のインターネットへの公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)に関するGitLabドキュメントを参照してください。

SlackボットユーザーのOAuthトークンを失効するには（注: これには、すべてのユーザーにアプリケーションの再認証をリクエストする必要があります）:

- Slackにサインインして、<https://api.slack.com/apps>にアクセスします
- 識別されたトークンを持つアプリケーションを見つけて、名前を選択します
- 左側のメニューで、「OAuth & Permissions」を選択します
- 「Revoke All OAuth Tokens」までスクロールし、「Revoke tokens」を選択します
- プロンプトが表示されたら、「Are you sure?」ダイアログで「Yes, I'm sure」を選択します
- しばらくしてから、「OAuth Tokens」セクションまでスクロールして戻り、「Reinstall to XXX」を選択します。XXXはワークスペース名です

詳細については、[OAuthに関するSlackのドキュメント](https://api.slack.com/authentication/oauth-v2)を参照してください

## 詳細 {#details}

| ID | 集計 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.109 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
