---
stage: Runtime
group: Organizations
info: For assistance with this tutorial, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
title: 'チュートリアル: パーソナルネームスペースをグループに変換する'
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com

{{< /details >}}

個人[ネームスペース](../../user/namespace/_index.md)から始めたものの、その機能が物足りなくなった場合は、代わりにグループネームスペースに切り替えることができます。グループネームスペースを使用すると、複数のサブグループを作成し、そのメンバーと権限を管理できます。

最初からやり直す必要はありません。新しいグループを作成し、既存のプロジェクトをそのグループに移動して、追加のメリットを得ることができます。方法については、[チュートリアルをご覧ください: パーソナルプロジェクトをグループに移動する](../move_personal_project_to_group/_index.md)。

さらに一歩進んで、個人のネームスペースをグループネームスペースに変換することもできます。ネームスペースを変換すると、既存のユーザー名とURLを維持できます。たとえば、ユーザー名が`alex`の場合、グループに`https://gitlab.example.com/alex`のURLを引き続き使用できます。

このチュートリアルでは、次の手順で、個人のネームスペースをグループネームスペースに変換する方法を説明します:

1. [グループを作成する](#create-a-group)。
1. [個人のネームスペースからグループにプロジェクトを転送する](#transfer-projects-from-the-personal-namespace-to-the-group)。
1. [元のユーザー名を変更する](#rename-the-original-username)。
1. [新しいグループネームスペースを元のユーザー名に変更する](#rename-the-new-group-namespace-to-the-original-username)。

たとえば、個人のネームスペースのユーザー名が`alex`の場合、最初に`alex-group`という名前のグループネームスペースを作成します。次に、すべてのプロジェクトを`alex`から`alex-group`ネームスペースに移動します。最後に、`alex`ネームスペースの名前を`alex-user`に、`alex-group`ネームスペースの名前を現在使用可能な`alex`ユーザー名に変更します。

## グループを作成する {#create-a-group}

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新規グループ**を選択します。
1. **グループ名**に、グループの名前を入力します。
1. **グループURL**に、グループのパスを入力します。これは、ネームスペースとして使用されます。実際のパスについては、一時的なものなのでご心配はいりません。このURLは、[最後の手順](#rename-the-new-group-namespace-to-the-original-username)で、個人のネームスペースのユーザー名に変更します。
1. [表示レベル](../../user/public_access.md)を選択します。
1. オプション。情報を入力して、エクスペリエンスをパーソナライズします。
1. **グループを作成**を選択します。

## 個人のネームスペースからグループにプロジェクトを転送する {#transfer-projects-from-the-personal-namespace-to-the-group}

次に、プロジェクトを個人のネームスペースから新しいグループに転送する必要があります。一度に転送できるプロジェクトは1つのみです。複数のプロジェクトを転送する場合は、プロジェクトごとに以下の手順を実行する必要があります。

転送プロセスを開始する前に、次のことを確認してください:

- プロジェクトのオーナーロールが必要です。
- [コンテナイメージ](../../user/packages/container_registry/_index.md#move-or-rename-container-registry-repositories)を削除します。コンテナイメージを含むプロジェクトは転送できません。
- npmパッケージを削除します。npmパッケージを含むプロジェクトのルートネームスペースは更新できません。

プロジェクトをグループに転送するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **一般**を選択します。
1. **高度な設定**を展開します。
1. **プロジェクトの転送**で、プロジェクトの転送先のグループを選択します。
1. **プロジェクトの転送**を選択します。
1. プロジェクトの名前を入力し、**確認**を選択します。

## 元のユーザー名を変更する {#rename-the-original-username}

次に、新しいグループネームスペースでユーザー名が使用可能になるように、個人のネームスペースの元のユーザー名を変更します。個人のネームスペースを他の個人プロジェクトに使用し続けるか、[そのユーザーアカウントを削除する](../../user/profile/account/delete_account.md)

個人のネームスペースの名前を変更した瞬間から、ユーザー名が利用可能になるため、他の誰かがそのユーザー名でアカウントを登録する可能性があります。これを避けるために、できるだけ早く[新しいグループの名前を変更](#rename-the-new-group-namespace-to-the-original-username)する必要があります。

[ユーザーのユーザー名を変更する](../../user/profile/_index.md#change-your-username)方法:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。
1. **ユーザー名を変更**セクションで、パスとして新しいユーザー名を入力します。
1. **ユーザー名を更新**を選択します。

## 新しいグループネームスペースの名前を元のユーザー名に変更する {#rename-the-new-group-namespace-to-the-original-username}

最後に、新しいグループのURLの名前を、元の個人のネームスペースのユーザー名に変更します。

[グループ（グループURL）を変更](../../user/group/manage.md#change-a-groups-path)するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **設定** > **一般**を選択します。
1. **高度な設定**セクションを展開します。
1. **グループのURLの変更**で、ユーザーの元のユーザー名を入力します。
1. **グループのURLの変更**を選択します。

以上です。これで、個人のネームスペースをグループに変換し、プロジェクトに取り組み、より多くのメンバーとコラボレーションする新しい可能性が開かれました。
