# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network watcher show-security-group-view",
)
class ShowSecurityGroupView(AAZCommand):
    """Get detailed security information on a VM for the currently configured network security group.

    For more information on using security group view visit https://learn.microsoft.com/en-us/azure/network-watcher/network-watcher-security-group-view-cli.

    :example: Get the network security group information for the specified VM.
        az network watcher show-security-group-view -g MyResourceGroup --vm MyVm
    """

    _aaz_info = {
        "version": "2022-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/networkwatchers/{}/securitygroupview", "2022-01-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.watcher_name = AAZStrArg(
            options=["--watcher-name"],
            help="Name of the network watcher.",
            required=True,
            id_part="name",
        )
        _args_schema.watcher_rg = AAZResourceGroupNameArg(
            options=["--watcher-rg"],
            help="Name of the resource group the watcher is in.",
            required=True,
        )
        _args_schema.vm = AAZStrArg(
            options=["--vm"],
            help="Name or ID of the VM to target. If the name of the VM is provided, the `--resource-group` is required.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.NetworkWatchersGetVMSecurityRules(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class NetworkWatchersGetVMSecurityRules(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/securityGroupView",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "networkWatcherName", self.ctx.args.watcher_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.watcher_rg,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("targetResourceId", AAZStrType, ".vm", typ_kwargs={"flags": {"required": True}})

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _ShowSecurityGroupViewHelper._build_schema_security_group_view_result_read(cls._schema_on_200)

            return cls._schema_on_200


class _ShowSecurityGroupViewHelper:
    """Helper class for ShowSecurityGroupView"""

    _schema_application_security_group_read = None

    @classmethod
    def _build_schema_application_security_group_read(cls, _schema):
        if cls._schema_application_security_group_read is not None:
            _schema.etag = cls._schema_application_security_group_read.etag
            _schema.id = cls._schema_application_security_group_read.id
            _schema.location = cls._schema_application_security_group_read.location
            _schema.name = cls._schema_application_security_group_read.name
            _schema.properties = cls._schema_application_security_group_read.properties
            _schema.tags = cls._schema_application_security_group_read.tags
            _schema.type = cls._schema_application_security_group_read.type
            return

        cls._schema_application_security_group_read = _schema_application_security_group_read = AAZObjectType()

        application_security_group_read = _schema_application_security_group_read
        application_security_group_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        application_security_group_read.id = AAZStrType()
        application_security_group_read.location = AAZStrType()
        application_security_group_read.name = AAZStrType(
            flags={"read_only": True},
        )
        application_security_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        application_security_group_read.tags = AAZDictType()
        application_security_group_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_application_security_group_read.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )

        tags = _schema_application_security_group_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_application_security_group_read.etag
        _schema.id = cls._schema_application_security_group_read.id
        _schema.location = cls._schema_application_security_group_read.location
        _schema.name = cls._schema_application_security_group_read.name
        _schema.properties = cls._schema_application_security_group_read.properties
        _schema.tags = cls._schema_application_security_group_read.tags
        _schema.type = cls._schema_application_security_group_read.type

    _schema_security_group_view_result_read = None

    @classmethod
    def _build_schema_security_group_view_result_read(cls, _schema):
        if cls._schema_security_group_view_result_read is not None:
            _schema.network_interfaces = cls._schema_security_group_view_result_read.network_interfaces
            return

        cls._schema_security_group_view_result_read = _schema_security_group_view_result_read = AAZObjectType()

        security_group_view_result_read = _schema_security_group_view_result_read
        security_group_view_result_read.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
        )

        network_interfaces = _schema_security_group_view_result_read.network_interfaces
        network_interfaces.Element = AAZObjectType()

        _element = _schema_security_group_view_result_read.network_interfaces.Element
        _element.id = AAZStrType()
        _element.security_rule_associations = AAZObjectType(
            serialized_name="securityRuleAssociations",
        )

        security_rule_associations = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations
        security_rule_associations.default_security_rules = AAZListType(
            serialized_name="defaultSecurityRules",
        )
        security_rule_associations.effective_security_rules = AAZListType(
            serialized_name="effectiveSecurityRules",
        )
        security_rule_associations.network_interface_association = AAZObjectType(
            serialized_name="networkInterfaceAssociation",
        )
        security_rule_associations.subnet_association = AAZObjectType(
            serialized_name="subnetAssociation",
        )

        default_security_rules = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.default_security_rules
        default_security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(default_security_rules.Element)

        effective_security_rules = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.effective_security_rules
        effective_security_rules.Element = AAZObjectType()

        _element = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.effective_security_rules.Element
        _element.access = AAZStrType()
        _element.destination_address_prefix = AAZStrType(
            serialized_name="destinationAddressPrefix",
        )
        _element.destination_address_prefixes = AAZListType(
            serialized_name="destinationAddressPrefixes",
        )
        _element.destination_port_range = AAZStrType(
            serialized_name="destinationPortRange",
        )
        _element.destination_port_ranges = AAZListType(
            serialized_name="destinationPortRanges",
        )
        _element.direction = AAZStrType()
        _element.expanded_destination_address_prefix = AAZListType(
            serialized_name="expandedDestinationAddressPrefix",
        )
        _element.expanded_source_address_prefix = AAZListType(
            serialized_name="expandedSourceAddressPrefix",
        )
        _element.name = AAZStrType()
        _element.priority = AAZIntType()
        _element.protocol = AAZStrType()
        _element.source_address_prefix = AAZStrType(
            serialized_name="sourceAddressPrefix",
        )
        _element.source_address_prefixes = AAZListType(
            serialized_name="sourceAddressPrefixes",
        )
        _element.source_port_range = AAZStrType(
            serialized_name="sourcePortRange",
        )
        _element.source_port_ranges = AAZListType(
            serialized_name="sourcePortRanges",
        )

        destination_address_prefixes = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.effective_security_rules.Element.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrType()

        destination_port_ranges = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.effective_security_rules.Element.destination_port_ranges
        destination_port_ranges.Element = AAZStrType()

        expanded_destination_address_prefix = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.effective_security_rules.Element.expanded_destination_address_prefix
        expanded_destination_address_prefix.Element = AAZStrType()

        expanded_source_address_prefix = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.effective_security_rules.Element.expanded_source_address_prefix
        expanded_source_address_prefix.Element = AAZStrType()

        source_address_prefixes = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.effective_security_rules.Element.source_address_prefixes
        source_address_prefixes.Element = AAZStrType()

        source_port_ranges = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.effective_security_rules.Element.source_port_ranges
        source_port_ranges.Element = AAZStrType()

        network_interface_association = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.network_interface_association
        network_interface_association.id = AAZStrType(
            flags={"read_only": True},
        )
        network_interface_association.security_rules = AAZListType(
            serialized_name="securityRules",
        )

        security_rules = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.network_interface_association.security_rules
        security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(security_rules.Element)

        subnet_association = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.subnet_association
        subnet_association.id = AAZStrType(
            flags={"read_only": True},
        )
        subnet_association.security_rules = AAZListType(
            serialized_name="securityRules",
        )

        security_rules = _schema_security_group_view_result_read.network_interfaces.Element.security_rule_associations.subnet_association.security_rules
        security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(security_rules.Element)

        _schema.network_interfaces = cls._schema_security_group_view_result_read.network_interfaces

    _schema_security_rule_read = None

    @classmethod
    def _build_schema_security_rule_read(cls, _schema):
        if cls._schema_security_rule_read is not None:
            _schema.etag = cls._schema_security_rule_read.etag
            _schema.id = cls._schema_security_rule_read.id
            _schema.name = cls._schema_security_rule_read.name
            _schema.properties = cls._schema_security_rule_read.properties
            _schema.type = cls._schema_security_rule_read.type
            return

        cls._schema_security_rule_read = _schema_security_rule_read = AAZObjectType()

        security_rule_read = _schema_security_rule_read
        security_rule_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        security_rule_read.id = AAZStrType()
        security_rule_read.name = AAZStrType()
        security_rule_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        security_rule_read.type = AAZStrType()

        properties = _schema_security_rule_read.properties
        properties.access = AAZStrType(
            flags={"required": True},
        )
        properties.description = AAZStrType()
        properties.destination_address_prefix = AAZStrType(
            serialized_name="destinationAddressPrefix",
        )
        properties.destination_address_prefixes = AAZListType(
            serialized_name="destinationAddressPrefixes",
        )
        properties.destination_application_security_groups = AAZListType(
            serialized_name="destinationApplicationSecurityGroups",
        )
        properties.destination_port_range = AAZStrType(
            serialized_name="destinationPortRange",
        )
        properties.destination_port_ranges = AAZListType(
            serialized_name="destinationPortRanges",
        )
        properties.direction = AAZStrType(
            flags={"required": True},
        )
        properties.priority = AAZIntType()
        properties.protocol = AAZStrType(
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.source_address_prefix = AAZStrType(
            serialized_name="sourceAddressPrefix",
        )
        properties.source_address_prefixes = AAZListType(
            serialized_name="sourceAddressPrefixes",
        )
        properties.source_application_security_groups = AAZListType(
            serialized_name="sourceApplicationSecurityGroups",
        )
        properties.source_port_range = AAZStrType(
            serialized_name="sourcePortRange",
        )
        properties.source_port_ranges = AAZListType(
            serialized_name="sourcePortRanges",
        )

        destination_address_prefixes = _schema_security_rule_read.properties.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrType()

        destination_application_security_groups = _schema_security_rule_read.properties.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(destination_application_security_groups.Element)

        destination_port_ranges = _schema_security_rule_read.properties.destination_port_ranges
        destination_port_ranges.Element = AAZStrType()

        source_address_prefixes = _schema_security_rule_read.properties.source_address_prefixes
        source_address_prefixes.Element = AAZStrType()

        source_application_security_groups = _schema_security_rule_read.properties.source_application_security_groups
        source_application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(source_application_security_groups.Element)

        source_port_ranges = _schema_security_rule_read.properties.source_port_ranges
        source_port_ranges.Element = AAZStrType()

        _schema.etag = cls._schema_security_rule_read.etag
        _schema.id = cls._schema_security_rule_read.id
        _schema.name = cls._schema_security_rule_read.name
        _schema.properties = cls._schema_security_rule_read.properties
        _schema.type = cls._schema_security_rule_read.type


__all__ = ["ShowSecurityGroupView"]
