/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.CommonVcsLogUiImpl;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.frame.MainFrame;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUiImpl
extends CommonVcsLogUiImpl
implements MainVcsLogUi {
    @NotNull
    private final MainFrame myMainFrame;

    public VcsLogUiImpl(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @Nullable VcsLogFilterCollection initialFilters) {
        if (id == null) {
            VcsLogUiImpl.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VcsLogUiImpl.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            VcsLogUiImpl.$$$reportNull$$$0(2);
        }
        if (uiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(3);
        }
        if (refresher == null) {
            VcsLogUiImpl.$$$reportNull$$$0(4);
        }
        this(id, logData, manager, uiProperties, refresher, initialFilters, true);
    }

    public VcsLogUiImpl(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, final @NotNull MainVcsLogUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @Nullable VcsLogFilterCollection initialFilters, boolean isEditorDiffPreview) {
        if (id == null) {
            VcsLogUiImpl.$$$reportNull$$$0(5);
        }
        if (logData == null) {
            VcsLogUiImpl.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            VcsLogUiImpl.$$$reportNull$$$0(7);
        }
        if (uiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(8);
        }
        if (refresher == null) {
            VcsLogUiImpl.$$$reportNull$$$0(9);
        }
        super(id, logData, manager, uiProperties, refresher);
        VcsLogFilterUiEx filterUi = this.createFilterUi(filters -> this.applyFiltersAndUpdateUi((VcsLogFilterCollection)filters), initialFilters, this);
        this.myMainFrame = this.createMainFrame(logData, uiProperties, filterUi, isEditorDiffPreview);
        LOG_HIGHLIGHTER_FACTORY_EP.addChangeListener(this::updateHighlighters, (Disposable)this);
        ApplicationManager.getApplication().invokeLater(this::updateHighlighters, o -> this.myDisposableFlag.isDisposed());
        VcsLogUiProperties.PropertiesChangeListener detailsStateListener = new VcsLogUiProperties.PropertiesChangeListener(){

            @Override
            public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
                if (property == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                    VcsLogUiImpl.this.myMainFrame.showDetails(uiProperties.get(CommonUiProperties.SHOW_DETAILS));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/VcsLogUiImpl$1", "onPropertyChanged"));
            }
        };
        uiProperties.addChangeListener(detailsStateListener, this);
        this.applyFiltersAndUpdateUi(this.myMainFrame.getFilterUi().getFilters());
    }

    @NotNull
    protected MainFrame createMainFrame(@NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogFilterUiEx filterUi, boolean isEditorDiffPreview) {
        if (logData == null) {
            VcsLogUiImpl.$$$reportNull$$$0(10);
        }
        if (uiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(11);
        }
        if (filterUi == null) {
            VcsLogUiImpl.$$$reportNull$$$0(12);
        }
        return new MainFrame(logData, this, uiProperties, filterUi, this.myColorManager, isEditorDiffPreview, this);
    }

    @NotNull
    protected VcsLogFilterUiEx createFilterUi(@NotNull Consumer<VcsLogFilterCollection> filterConsumer, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
        if (filterConsumer == null) {
            VcsLogUiImpl.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            VcsLogUiImpl.$$$reportNull$$$0(14);
        }
        return new VcsLogClassicFilterUi(this.myLogData, filterConsumer, this.getProperties(), this.myColorManager, filters, parentDisposable);
    }

    @Override
    protected void updateDataPack(boolean permGraphChanged) {
        this.myMainFrame.updateDataPack(this.myVisiblePack, permGraphChanged);
    }

    @NotNull
    protected MainFrame getMainFrame() {
        MainFrame mainFrame = this.myMainFrame;
        if (mainFrame == null) {
            VcsLogUiImpl.$$$reportNull$$$0(15);
        }
        return mainFrame;
    }

    @Override
    protected <T> void handleCommitNotFound(@NotNull T commitId, boolean commitExists, @NotNull BiFunction<? super VisiblePack, ? super T, Integer> rowGetter) {
        if (commitId == null) {
            VcsLogUiImpl.$$$reportNull$$$0(16);
        }
        if (rowGetter == null) {
            VcsLogUiImpl.$$$reportNull$$$0(17);
        }
        if (this.getFilterUi().getFilters().isEmpty() || !commitExists) {
            super.handleCommitNotFound(commitId, commitExists, rowGetter);
            return;
        }
        ArrayList<NotificationAction> actions2 = new ArrayList<NotificationAction>();
        actions2.add(NotificationAction.createSimple((String)VcsLogBundle.message("vcs.log.commit.does.not.match.view.and.reset.link", new Object[0]), () -> {
            this.getFilterUi().clearFilters();
            VcsLogUtil.invokeOnChange(this, () -> this.jumpTo(commitId, rowGetter, (SettableFuture<VcsLogUiEx.JumpResult>)SettableFuture.create(), false, true), (Condition<? super VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
        }));
        VcsProjectLog projectLog = VcsProjectLog.getInstance(this.myProject);
        if (projectLog.getDataManager() == this.myLogData) {
            actions2.add(NotificationAction.createSimple((String)VcsLogBundle.message("vcs.log.commit.does.not.match.view.in.tab.link", new Object[0]), () -> {
                MainVcsLogUi ui = projectLog.openLogTab(VcsLogFilterObject.collection(new VcsLogFilter[0]));
                if (ui != null) {
                    VcsLogUtil.invokeOnChange(ui, () -> ui.jumpTo(commitId, rowGetter, (SettableFuture<VcsLogUiEx.JumpResult>)SettableFuture.create(), false, true), (Condition<? super VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
                }
            }));
        }
        VcsNotifier.getInstance((Project)this.myProject).notifyWarning("vcs.log.commit.not.found", "", VcsLogUiImpl.getCommitNotFoundMessage(commitId, true), (NotificationAction[])actions2.toArray(NotificationAction[]::new));
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myMainFrame.getGraphTable();
        if (vcsLogGraphTable == null) {
            VcsLogUiImpl.$$$reportNull$$$0(18);
        }
        return vcsLogGraphTable;
    }

    @Override
    @NotNull
    public JComponent getMainComponent() {
        MainFrame mainFrame = this.myMainFrame;
        if (mainFrame == null) {
            VcsLogUiImpl.$$$reportNull$$$0(19);
        }
        return mainFrame;
    }

    @Override
    @NotNull
    public VcsLogFilterUiEx getFilterUi() {
        VcsLogFilterUiEx vcsLogFilterUiEx = this.myMainFrame.getFilterUi();
        if (vcsLogFilterUiEx == null) {
            VcsLogUiImpl.$$$reportNull$$$0(20);
        }
        return vcsLogFilterUiEx;
    }

    @Override
    @NotNull
    public ChangesBrowserBase getChangesBrowser() {
        ChangesBrowserBase changesBrowserBase = this.myMainFrame.getChangesBrowser();
        if (changesBrowserBase == null) {
            VcsLogUiImpl.$$$reportNull$$$0(21);
        }
        return changesBrowserBase;
    }

    @Override
    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myMainFrame.getToolbar();
        if (jComponent == null) {
            VcsLogUiImpl.$$$reportNull$$$0(22);
        }
        return jComponent;
    }

    @Override
    public void selectFilePath(@NotNull FilePath filePath, boolean requestFocus) {
        if (filePath == null) {
            VcsLogUiImpl.$$$reportNull$$$0(23);
        }
        this.getMainFrame().selectFilePath(filePath, requestFocus);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 18, 19, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterUi";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterConsumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/VcsLogUiImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/VcsLogUiImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainFrame";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainComponent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBrowser";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createMainFrame";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFilterUi";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 18, 19, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

