/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.impl;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriteriaRegistry;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.credential.impl.AbstractCredentialResolver;

public abstract class AbstractCriteriaFilteringCredentialResolver
extends AbstractCredentialResolver {
    private boolean satisfyAllPredicates = true;

    @Override
    @Nonnull
    public Iterable<Credential> resolve(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        Iterable<Credential> storeCandidates = this.resolveFromSource(criteriaSet);
        Set<Predicate<Credential>> predicates = this.getPredicates(criteriaSet);
        if (predicates.isEmpty()) {
            return storeCandidates;
        }
        Predicate<Credential> aggregatePredicate = null;
        aggregatePredicate = this.isSatisfyAllPredicates() ? PredicateSupport.and(predicates) : PredicateSupport.or(predicates);
        return Iterables.filter(storeCandidates, aggregatePredicate::test);
    }

    public boolean isSatisfyAllPredicates() {
        return this.satisfyAllPredicates;
    }

    public void setSatisfyAllPredicates(boolean flag) {
        this.satisfyAllPredicates = flag;
    }

    @Nonnull
    protected abstract Iterable<Credential> resolveFromSource(@Nullable CriteriaSet var1) throws ResolverException;

    @Nonnull
    private Set<Predicate<Credential>> getPredicates(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        if (criteriaSet == null) {
            return CollectionSupport.emptySet();
        }
        HashSet<Predicate<Credential>> predicates = new HashSet<Predicate<Credential>>(criteriaSet.size());
        for (Criterion criteria : criteriaSet) {
            EvaluableCredentialCriterion evaluableCriteria;
            assert (criteria != null);
            if (criteria instanceof EvaluableCredentialCriterion) {
                predicates.add((EvaluableCredentialCriterion)criteria);
                continue;
            }
            try {
                evaluableCriteria = EvaluableCredentialCriteriaRegistry.getEvaluator(criteria);
            }
            catch (SecurityException e) {
                throw new ResolverException("Exception obtaining EvaluableCredentialCriterion", e);
            }
            if (evaluableCriteria == null) continue;
            predicates.add(evaluableCriteria);
        }
        return predicates;
    }
}

