/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.AsyncCallback;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.Http2ConnectionSetting;
import software.amazon.awssdk.crt.http.Http2Stream;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpRequestBase;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.http.HttpStreamBaseResponseHandler;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandlerNativeAdapter;

public class Http2ClientConnection
extends HttpClientConnection {
    public Http2ClientConnection(long connectionBinding) {
        super(connectionBinding);
    }

    public CompletableFuture<Void> updateSettings(List<Http2ConnectionSetting> settings) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.isNull()) {
            future.completeExceptionally(new IllegalStateException("Http2ClientConnection has been closed, can't change settings on it."));
            return future;
        }
        AsyncCallback updateSettingsCompleted = AsyncCallback.wrapFuture(future, null);
        try {
            Http2ClientConnection.http2ClientConnectionUpdateSettings(this.getNativeHandle(), updateSettingsCompleted, Http2ConnectionSetting.marshallSettingsForJNI(settings));
        }
        catch (CrtRuntimeException ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    public CompletableFuture<Long> sendPing(byte[] pingData) {
        CompletableFuture<Long> completionFuture = new CompletableFuture<Long>();
        if (this.isNull()) {
            completionFuture.completeExceptionally(new IllegalStateException("Http2ClientConnection has been closed, can't send ping on it."));
            return completionFuture;
        }
        AsyncCallback pingCompleted = AsyncCallback.wrapFuture(completionFuture, 0L);
        try {
            Http2ClientConnection.http2ClientConnectionSendPing(this.getNativeHandle(), pingCompleted, pingData);
        }
        catch (CrtRuntimeException ex) {
            completionFuture.completeExceptionally(ex);
        }
        return completionFuture;
    }

    public CompletableFuture<Long> sendPing() {
        return this.sendPing(null);
    }

    public void sendGoAway(Http2ErrorCode Http2ErrorCode2, boolean allowMoreStreams, byte[] debugData) {
        if (this.isNull()) {
            throw new IllegalStateException("Http2ClientConnection has been closed.");
        }
        Http2ClientConnection.http2ClientConnectionSendGoAway(this.getNativeHandle(), Http2ErrorCode2.getValue(), allowMoreStreams, debugData);
    }

    public void sendGoAway(Http2ErrorCode Http2ErrorCode2, boolean allowMoreStreams) {
        this.sendGoAway(Http2ErrorCode2, allowMoreStreams, null);
    }

    public void updateConnectionWindow(long incrementSize) {
        if (incrementSize > 0x100000000L || incrementSize < 0L) {
            throw new IllegalArgumentException("increment size cannot exceed 4294967296");
        }
        Http2ClientConnection.http2ClientConnectionUpdateConnectionWindow(this.getNativeHandle(), incrementSize);
    }

    @Override
    public Http2Stream makeRequest(HttpRequestBase request, HttpStreamBaseResponseHandler streamHandler) throws CrtRuntimeException {
        if (this.isNull()) {
            throw new IllegalStateException("Http2ClientConnection has been closed, can't make requests on it.");
        }
        Http2Stream stream = Http2ClientConnection.http2ClientConnectionMakeRequest(this.getNativeHandle(), request.marshalForJni(), request.getBodyStream(), new HttpStreamResponseHandlerNativeAdapter(streamHandler));
        return stream;
    }

    private static native Http2Stream http2ClientConnectionMakeRequest(long var0, byte[] var2, HttpRequestBodyStream var3, HttpStreamResponseHandlerNativeAdapter var4) throws CrtRuntimeException;

    private static native void http2ClientConnectionUpdateSettings(long var0, AsyncCallback var2, long[] var3) throws CrtRuntimeException;

    private static native void http2ClientConnectionSendPing(long var0, AsyncCallback var2, byte[] var3) throws CrtRuntimeException;

    private static native void http2ClientConnectionSendGoAway(long var0, long var2, boolean var4, byte[] var5) throws CrtRuntimeException;

    private static native void http2ClientConnectionUpdateConnectionWindow(long var0, long var2) throws CrtRuntimeException;

    public static enum Http2ErrorCode {
        PROTOCOL_ERROR(1),
        INTERNAL_ERROR(2),
        FLOW_CONTROL_ERROR(3),
        SETTINGS_TIMEOUT(4),
        STREAM_CLOSED(5),
        FRAME_SIZE_ERROR(6),
        REFUSED_STREAM(7),
        CANCEL(8),
        COMPRESSION_ERROR(9),
        CONNECT_ERROR(10),
        ENHANCE_YOUR_CALM(11),
        INADEQUATE_SECURITY(12),
        HTTP_1_1_REQUIRED(13);

        private int errorCode;

        private Http2ErrorCode(int value) {
            this.errorCode = value;
        }

        public int getValue() {
            return this.errorCode;
        }
    }
}

