/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.tika.detect.zip.StreamingDetectContext;
import org.apache.tika.detect.zip.ZipContainerDetector;
import org.apache.tika.io.BoundedInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.StoppingEarlyException;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StarOfficeDetector
implements ZipContainerDetector {
    static final Map<String, MediaType> STAR_OFFICE_X = new HashMap<String, MediaType>();
    static final MediaType BAU = MediaType.application((String)"vnd.openofficeorg.autotext");
    private static final int MAX_MANIFEST = 0x1400000;

    static MediaType detectStarOfficeX(InputStream is) {
        StarOfficeXHandler handler = new StarOfficeXHandler();
        try {
            XMLReaderUtils.parseSAX((InputStream)is, (ContentHandler)handler, (ParseContext)new ParseContext());
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler.mediaType;
    }

    @Override
    public MediaType detect(ZipFile zip, TikaInputStream tis) throws IOException {
        ZipArchiveEntry zae = zip.getEntry("META-INF/manifest.xml");
        if (zae == null) {
            return null;
        }
        return StarOfficeDetector.detectStarOfficeX(zip.getInputStream(zae));
    }

    @Override
    public MediaType streamingDetectUpdate(ZipArchiveEntry zae, InputStream zis, StreamingDetectContext detectContext) throws IOException {
        String name = zae.getName();
        if (!"META-INF/manifest.xml".equals(name)) {
            return null;
        }
        UnsynchronizedByteArrayOutputStream bos = UnsynchronizedByteArrayOutputStream.builder().get();
        BoundedInputStream bis = new BoundedInputStream(0x1400000L, zis);
        IOUtils.copy((InputStream)bis, (OutputStream)bos);
        return StarOfficeDetector.detectStarOfficeX(bos.toInputStream());
    }

    @Override
    public MediaType streamingDetectFinal(StreamingDetectContext detectContext) {
        return null;
    }

    static {
        STAR_OFFICE_X.put("application/vnd.sun.xml.writer", MediaType.application((String)"vnd.sun.xml.writer"));
        STAR_OFFICE_X.put("application/vnd.sun.xml.calc", MediaType.application((String)"vnd.sun.xml.calc"));
        STAR_OFFICE_X.put("application/vnd.sun.xml.draw", MediaType.application((String)"vnd.sun.xml.draw"));
        STAR_OFFICE_X.put("application/vnd.sun.xml.impress", MediaType.application((String)"vnd.sun.xml.impress"));
        STAR_OFFICE_X.put("application/vnd.sun.star.configuration-data", MediaType.application((String)"vnd.openofficeorg.extension"));
    }

    private static class StarOfficeXHandler
    extends DefaultHandler {
        private MediaType mediaType = null;

        private StarOfficeXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
            if (!"file-entry".equals(localName)) {
                return;
            }
            String mediaTypeString = null;
            String fullPath = null;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getLocalName(i);
                if (attrName.equals("media-type")) {
                    mediaTypeString = attrs.getValue(i);
                    if (!STAR_OFFICE_X.containsKey(mediaTypeString)) continue;
                    this.mediaType = STAR_OFFICE_X.get(mediaTypeString);
                    throw StoppingEarlyException.INSTANCE;
                }
                if (!attrName.equals("full-path")) continue;
                fullPath = attrs.getValue(i);
            }
            if ("".equals(mediaTypeString) && "/".equals(fullPath)) {
                this.mediaType = BAU;
                throw StoppingEarlyException.INSTANCE;
            }
        }
    }
}

