/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import moment from 'moment';
export var always = function always(_value) {
  return true;
};
export var never = function never(_value) {
  return false;
};
export var isUndefined = function isUndefined(value) {
  return value === undefined;
};
export var isNull = function isNull(value) {
  return value === null;
};
export var isNil = function isNil(value) {
  return isUndefined(value) || isNull(value);
};
export var isMoment = function isMoment(value) {
  return moment.isMoment(value);
};
export var isDate = function isDate(value) {
  return moment.isDate(value);
};
export var isDateLike = function isDateLike(value) {
  return isMoment(value) || isDate(value);
};