/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.MonetaryAmount;
import javax.money.MonetaryQuery;

final class ExtractorMinorPartQuery
implements MonetaryQuery<Long> {
    ExtractorMinorPartQuery() {
    }

    public Long queryFrom(MonetaryAmount amount) {
        Objects.requireNonNull(amount, "Amount required.");
        int fractionDigits = amount.getCurrency().getDefaultFractionDigits();
        BigDecimal number = (BigDecimal)amount.getNumber().numberValue(BigDecimal.class);
        return number.setScale(fractionDigits, RoundingMode.DOWN).remainder(BigDecimal.ONE).movePointRight(fractionDigits).longValue();
    }
}

