/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtendedHttpServiceRuntime;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.WebApplication;
import org.ops4j.pax.web.extender.whiteboard.internal.element.HttpContextElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.util.ServicePropertiesUtils;
import org.ops4j.pax.web.service.whiteboard.HttpContextMapping;
import org.ops4j.pax.web.service.whiteboard.WhiteboardElement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpContextTracker<T>
implements ServiceTrackerCustomizer<T, HttpContextElement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTracker.class);
    private final ExtenderContext extenderContext;
    private final BundleContext bundleContext;
    private final ExtendedHttpServiceRuntime httpServiceRuntime;

    AbstractHttpContextTracker(ExtenderContext extenderContext, BundleContext bundleContext, ExtendedHttpServiceRuntime httpServiceRuntime) {
        NullArgumentException.validateNotNull(extenderContext, "Extender context");
        this.extenderContext = extenderContext;
        this.bundleContext = AbstractHttpContextTracker.validateBundleContext(bundleContext);
        this.httpServiceRuntime = httpServiceRuntime;
    }

    protected final ServiceTracker<T, HttpContextElement> create(Class<? extends T> trackedClass) {
        return new ServiceTracker(this.bundleContext, AbstractHttpContextTracker.createFilter(this.bundleContext, trackedClass), (ServiceTrackerCustomizer)this);
    }

    private static Filter createFilter(BundleContext bundleContext, Class<?> ... classes) {
        StringBuilder filter = new StringBuilder();
        if (classes != null) {
            if (classes.length > 1) {
                filter.append("(|");
            }
            for (Class<?> clazz : classes) {
                filter.append("(").append("objectClass").append("=").append(clazz.getName()).append(")");
            }
            if (classes.length > 1) {
                filter.append(")");
            }
        }
        try {
            return bundleContext.createFilter(filter.toString());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    private static BundleContext validateBundleContext(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        return bundleContext;
    }

    public HttpContextElement addingService(ServiceReference<T> serviceReference) {
        LOGGER.debug("Service available " + serviceReference);
        Object registered = this.bundleContext.getService(serviceReference);
        Boolean sharedHttpContext = ServicePropertiesUtils.extractSharedHttpContext(serviceReference);
        HttpContextElement contextElement = this.createHttpContextElement(serviceReference, registered);
        HttpContextMapping mapping = contextElement.getHttpContextMapping();
        if (mapping != null && contextElement.isValid()) {
            WebApplication webApplication = this.extenderContext.getWebApplication(serviceReference.getBundle(), mapping.getHttpContextId(), sharedHttpContext);
            webApplication.setHttpContextMapping(mapping);
        }
        this.httpServiceRuntime.addWhiteboardElement((WhiteboardElement)contextElement);
        return contextElement;
    }

    public void modifiedService(ServiceReference<T> reference, HttpContextElement service) {
    }

    public void removedService(ServiceReference<T> serviceReference, HttpContextElement unpublished) {
        LOGGER.debug("Service removed " + serviceReference);
        if (unpublished.isValid()) {
            Boolean sharedHttpContext = ServicePropertiesUtils.extractSharedHttpContext(serviceReference);
            WebApplication webApplication = this.extenderContext.getExistingWebApplication(serviceReference.getBundle(), unpublished.getHttpContextMapping().getHttpContextId(), sharedHttpContext);
            boolean remove = true;
            if (sharedHttpContext.booleanValue()) {
                LOGGER.debug("Shared Context ... ");
                Integer sharedWebApplicationCounter = this.extenderContext.getSharedWebApplicationCounter(webApplication);
                LOGGER.debug("... counter:" + sharedWebApplicationCounter);
                if (sharedWebApplicationCounter != null && sharedWebApplicationCounter > 0) {
                    remove = false;
                    Integer reduceSharedWebApplicationCount = this.extenderContext.reduceSharedWebApplicationCount(webApplication);
                    LOGGER.debug("reduced counter:" + reduceSharedWebApplicationCount);
                    if (reduceSharedWebApplicationCount == 0) {
                        remove = true;
                    }
                }
            }
            LOGGER.debug("Shared Context can be removed: " + remove);
            if (webApplication != null && remove) {
                webApplication.setHttpContextMapping(null);
            }
            this.httpServiceRuntime.removeWhiteboardElement((WhiteboardElement)unpublished);
        }
    }

    abstract HttpContextElement createHttpContextElement(ServiceReference<T> var1, T var2);
}

