/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.LRUSoftCache;
import org.apache.camel.util.LRUWeakCache;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LRUCacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LRUCacheFactory.class);
    private static final AtomicBoolean INIT = new AtomicBoolean();

    private LRUCacheFactory() {
    }

    public static void warmUp() {
        if (INIT.compareAndSet(false, true)) {
            Runnable task = () -> {
                StopWatch watch = new StopWatch();
                LOG.debug("Warming up LRUCache ...");
                LRUCacheFactory.newLRUCache(16);
                LOG.debug("Warming up LRUCache complete in {} millis", (Object)watch.taken());
            };
            String threadName = ThreadHelper.resolveThreadName(null, "LRUCacheFactory");
            Thread thread = new Thread(task, threadName);
            thread.start();
        }
    }

    public static LRUCache newLRUCache(int maximumCacheSize) {
        LOG.trace("Creating LRUCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new LRUCache(maximumCacheSize);
    }

    public static LRUCache newLRUCache(int initialCapacity, int maximumCacheSize) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}", (Object)initialCapacity, (Object)maximumCacheSize);
        return new LRUCache(initialCapacity, maximumCacheSize);
    }

    public static LRUCache newLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", new Object[]{initialCapacity, maximumCacheSize, stopOnEviction});
        return new LRUCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    public static LRUSoftCache newLRUSoftCache(int maximumCacheSize) {
        LOG.trace("Creating LRUSoftCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new LRUSoftCache(maximumCacheSize);
    }

    public static LRUWeakCache newLRUWeakCache(int maximumCacheSize) {
        LOG.trace("Creating LRUWeakCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new LRUWeakCache(maximumCacheSize);
    }
}

