/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;

public class RootObjectMapper
extends ObjectMapper {
    private Explicit<DateFormatter[]> dynamicDateTimeFormatters;
    private Explicit<Boolean> dateDetection;
    private Explicit<Boolean> numericDetection;
    private Explicit<DynamicTemplate[]> dynamicTemplates;

    RootObjectMapper(String name, boolean enabled, ObjectMapper.Dynamic dynamic, Map<String, Mapper> mappers, Explicit<DateFormatter[]> dynamicDateTimeFormatters, Explicit<DynamicTemplate[]> dynamicTemplates, Explicit<Boolean> dateDetection, Explicit<Boolean> numericDetection, Settings settings) {
        super(name, name, enabled, ObjectMapper.Nested.NO, dynamic, mappers, settings);
        this.dynamicTemplates = dynamicTemplates;
        this.dynamicDateTimeFormatters = dynamicDateTimeFormatters;
        this.dateDetection = dateDetection;
        this.numericDetection = numericDetection;
    }

    @Override
    public ObjectMapper mappingUpdate(Mapper mapper) {
        RootObjectMapper update = (RootObjectMapper)super.mappingUpdate(mapper);
        update.dynamicTemplates = new Explicit<DynamicTemplate[]>(new DynamicTemplate[0], false);
        update.dynamicDateTimeFormatters = new Explicit<DateFormatter[]>(Defaults.DYNAMIC_DATE_TIME_FORMATTERS, false);
        update.dateDetection = new Explicit<Boolean>(true, false);
        update.numericDetection = new Explicit<Boolean>(false, false);
        return update;
    }

    public boolean dateDetection() {
        return this.dateDetection.value();
    }

    public boolean numericDetection() {
        return this.numericDetection.value();
    }

    public DateFormatter[] dynamicDateTimeFormatters() {
        return this.dynamicDateTimeFormatters.value();
    }

    public Mapper.Builder findTemplateBuilder(ParseContext context, String name, DynamicTemplate.XContentFieldType matchType) {
        return this.findTemplateBuilder(context, name, matchType.defaultMappingType(), matchType);
    }

    public Mapper.Builder findTemplateBuilder(ParseContext context, String name, String dynamicType, DynamicTemplate.XContentFieldType matchType) {
        String mappingType;
        DynamicTemplate dynamicTemplate = this.findTemplate(context.path(), name, matchType);
        if (dynamicTemplate == null) {
            return null;
        }
        Mapper.TypeParser.ParserContext parserContext = context.docMapperParser().parserContext();
        Mapper.TypeParser typeParser = parserContext.typeParser(mappingType = dynamicTemplate.mappingType(dynamicType));
        if (typeParser == null) {
            throw new MapperParsingException("failed to find type parsed [" + mappingType + "] for [" + name + "]");
        }
        return typeParser.parse(name, dynamicTemplate.mappingForName(name, dynamicType), parserContext);
    }

    public DynamicTemplate findTemplate(ContentPath path, String name, DynamicTemplate.XContentFieldType matchType) {
        String pathAsString = path.pathAsText(name);
        for (DynamicTemplate dynamicTemplate : this.dynamicTemplates.value()) {
            if (!dynamicTemplate.match(pathAsString, name, matchType)) continue;
            return dynamicTemplate;
        }
        return null;
    }

    @Override
    public RootObjectMapper merge(Mapper mergeWith) {
        return (RootObjectMapper)super.merge(mergeWith);
    }

    @Override
    protected void doMerge(ObjectMapper mergeWith) {
        super.doMerge(mergeWith);
        RootObjectMapper mergeWithObject = (RootObjectMapper)mergeWith;
        if (mergeWithObject.numericDetection.explicit()) {
            this.numericDetection = mergeWithObject.numericDetection;
        }
        if (mergeWithObject.dateDetection.explicit()) {
            this.dateDetection = mergeWithObject.dateDetection;
        }
        if (mergeWithObject.dynamicDateTimeFormatters.explicit()) {
            this.dynamicDateTimeFormatters = mergeWithObject.dynamicDateTimeFormatters;
        }
        if (mergeWithObject.dynamicTemplates.explicit()) {
            this.dynamicTemplates = mergeWithObject.dynamicTemplates;
        }
    }

    @Override
    public RootObjectMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        return (RootObjectMapper)super.updateFieldType((Map)fullNameToFieldType);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (this.dynamicDateTimeFormatters.explicit() || includeDefaults) {
            builder.startArray("dynamic_date_formats");
            for (DateFormatter dateTimeFormatter : this.dynamicDateTimeFormatters.value()) {
                builder.value(dateTimeFormatter.pattern());
            }
            builder.endArray();
        }
        if (this.dynamicTemplates.explicit() || includeDefaults) {
            builder.startArray("dynamic_templates");
            for (DynamicTemplate dynamicTemplate : this.dynamicTemplates.value()) {
                builder.startObject();
                builder.field(dynamicTemplate.name(), dynamicTemplate);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.dateDetection.explicit() || includeDefaults) {
            builder.field("date_detection", this.dateDetection.value());
        }
        if (this.numericDetection.explicit() || includeDefaults) {
            builder.field("numeric_detection", this.numericDetection.value());
        }
    }

    public static class TypeParser
    extends ObjectMapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Object fieldNode;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (!TypeParser.parseObjectOrDocumentTypeProperties(fieldName, fieldNode = entry.getValue(), parserContext, builder) && !this.processField(builder, fieldName, fieldNode, parserContext.indexVersionCreated())) continue;
                iterator.remove();
            }
            return builder;
        }

        protected boolean processField(Builder builder, String fieldName, Object fieldNode, Version indexVersionCreated) {
            if (fieldName.equals("date_formats") || fieldName.equals("dynamic_date_formats")) {
                if (fieldNode instanceof List) {
                    ArrayList<DateFormatter> formatters = new ArrayList<DateFormatter>();
                    for (Object formatter : (List)fieldNode) {
                        if (formatter.toString().startsWith("epoch_")) {
                            throw new MapperParsingException("Epoch [" + formatter + "] is not supported as dynamic date format");
                        }
                        formatters.add(TypeParsers.parseDateTimeFormatter(formatter));
                    }
                    builder.dynamicDateTimeFormatter(formatters);
                } else if ("none".equals(fieldNode.toString())) {
                    builder.dynamicDateTimeFormatter(Collections.emptyList());
                } else {
                    builder.dynamicDateTimeFormatter(Collections.singleton(TypeParsers.parseDateTimeFormatter(fieldNode)));
                }
                return true;
            }
            if (fieldName.equals("dynamic_templates")) {
                List tmplNodes = (List)fieldNode;
                ArrayList<DynamicTemplate> templates = new ArrayList<DynamicTemplate>();
                for (Object tmplNode : tmplNodes) {
                    Map templateParams;
                    Map tmpl = (Map)tmplNode;
                    if (tmpl.size() != 1) {
                        throw new MapperParsingException("A dynamic template must be defined with a name");
                    }
                    Map.Entry entry = tmpl.entrySet().iterator().next();
                    String templateName = (String)entry.getKey();
                    DynamicTemplate template = DynamicTemplate.parse(templateName, templateParams = (Map)entry.getValue(), indexVersionCreated);
                    if (template == null) continue;
                    templates.add(template);
                }
                builder.dynamicTemplates(templates);
                return true;
            }
            if (fieldName.equals("date_detection")) {
                builder.dateDetection = new Explicit<Boolean>(XContentMapValues.nodeBooleanValue(fieldNode, "date_detection"), true);
                return true;
            }
            if (fieldName.equals("numeric_detection")) {
                builder.numericDetection = new Explicit<Boolean>(XContentMapValues.nodeBooleanValue(fieldNode, "numeric_detection"), true);
                return true;
            }
            return false;
        }
    }

    public static class Builder
    extends ObjectMapper.Builder<Builder, RootObjectMapper> {
        protected Explicit<DynamicTemplate[]> dynamicTemplates = new Explicit<DynamicTemplate[]>(new DynamicTemplate[0], false);
        protected Explicit<DateFormatter[]> dynamicDateTimeFormatters = new Explicit<DateFormatter[]>(Defaults.DYNAMIC_DATE_TIME_FORMATTERS, false);
        protected Explicit<Boolean> dateDetection = new Explicit<Boolean>(true, false);
        protected Explicit<Boolean> numericDetection = new Explicit<Boolean>(false, false);

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder dynamicDateTimeFormatter(Collection<DateFormatter> dateTimeFormatters) {
            this.dynamicDateTimeFormatters = new Explicit<DateFormatter[]>(dateTimeFormatters.toArray(new DateFormatter[0]), true);
            return this;
        }

        public Builder dynamicTemplates(Collection<DynamicTemplate> templates) {
            this.dynamicTemplates = new Explicit<DynamicTemplate[]>(templates.toArray(new DynamicTemplate[0]), true);
            return this;
        }

        @Override
        public RootObjectMapper build(Mapper.BuilderContext context) {
            Builder.fixRedundantIncludes(this, true);
            return (RootObjectMapper)super.build(context);
        }

        private static void fixRedundantIncludes(ObjectMapper.Builder omb, boolean parentIncluded) {
            for (Mapper.Builder mapper : omb.mappersBuilders) {
                boolean includedInRoot;
                if (!(mapper instanceof ObjectMapper.Builder)) continue;
                ObjectMapper.Builder child = (ObjectMapper.Builder)mapper;
                ObjectMapper.Nested nested = child.nested;
                boolean isNested = nested.isNested();
                boolean includeInRootViaParent = parentIncluded && isNested && nested.isIncludeInParent();
                boolean bl = includedInRoot = isNested && nested.isIncludeInRoot();
                if (includeInRootViaParent && includedInRoot) {
                    child.nested = ObjectMapper.Nested.newNested(true, false);
                }
                Builder.fixRedundantIncludes(child, includeInRootViaParent || includedInRoot);
            }
        }

        @Override
        protected ObjectMapper createMapper(String name, String fullPath, boolean enabled, ObjectMapper.Nested nested, ObjectMapper.Dynamic dynamic, Map<String, Mapper> mappers, @Nullable Settings settings) {
            assert (!nested.isNested());
            return new RootObjectMapper(name, enabled, dynamic, mappers, this.dynamicDateTimeFormatters, this.dynamicTemplates, this.dateDetection, this.numericDetection, settings);
        }
    }

    public static class Defaults {
        public static final DateFormatter[] DYNAMIC_DATE_TIME_FORMATTERS = new DateFormatter[]{DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER, DateFormatter.forPattern("yyyy/MM/dd HH:mm:ss||yyyy/MM/dd||epoch_millis")};
        public static final boolean DATE_DETECTION = true;
        public static final boolean NUMERIC_DETECTION = false;
    }
}

