/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;

public class MBeanInvocationHandler
implements InvocationHandler {
    private final MBeanServer wrapped;
    private final InvocationHandler guard;
    private final List<String> guarded = Collections.unmodifiableList(Arrays.asList("invoke", "getAttribute", "getAttributes", "setAttribute", "setAttributes"));

    public MBeanInvocationHandler(MBeanServer mBeanServer, InvocationHandler guard) {
        this.wrapped = mBeanServer;
        this.guard = guard;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        if (this.guarded.contains(method.getName())) {
            this.guard.invoke(proxy, method, args);
        }
        if (method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class) {
            InvocationHandler handler;
            Object target = args[0];
            if (target != null && Proxy.isProxyClass(target.getClass()) && (handler = Proxy.getInvocationHandler(target)) instanceof MBeanInvocationHandler) {
                args[0] = ((MBeanInvocationHandler)handler).wrapped;
            }
        } else if (method.getName().equals("finalize") && method.getParameterTypes().length == 0) {
            return null;
        }
        try {
            return AccessController.doPrivilegedWithCombiner(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    try {
                        return method.invoke((Object)MBeanInvocationHandler.this.wrapped, args);
                    }
                    catch (InvocationTargetException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception pae) {
            Throwable cause = pae.getCause();
            throw cause == null ? pae : cause;
        }
    }

    public MBeanServer getDelegate() {
        return this.wrapped;
    }
}

