/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ClassTypeSignature;
import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ClasspathElementDir;
import io.github.classgraph.ClasspathElementModule;
import io.github.classgraph.ClasspathElementZip;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.FieldInfoList;
import io.github.classgraph.HasName;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.Resource;
import io.github.classgraph.ScanResult;
import io.github.classgraph.ScanResultObject;
import java.io.File;
import java.lang.annotation.Inherited;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.json.Id;
import nonapi.io.github.classgraph.types.Parser;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.URLPathEncoder;

public class ClassInfo
extends ScanResultObject
implements Comparable<ClassInfo>,
HasName {
    @Id
    private String name;
    private int modifiers;
    private boolean isInterface;
    private boolean isAnnotation;
    boolean isInherited;
    private String typeSignatureStr;
    private transient ClassTypeSignature typeSignature;
    private String fullyQualifiedDefiningMethodName;
    private boolean isExternalClass = true;
    private boolean isScannedClass;
    transient File classpathElementFile;
    private transient String jarfilePackageRoot = "";
    private transient ModuleRef moduleRef;
    private transient URL classpathElementURL;
    private transient Resource resource;
    transient ClassLoader[] classLoaders;
    AnnotationInfoList annotationInfo;
    FieldInfoList fieldInfo;
    MethodInfoList methodInfo;
    AnnotationParameterValueList annotationDefaultParamValues;
    private Set<String> referencedClassNames;
    private ClassInfoList referencedClasses;
    transient boolean annotationDefaultParamValuesHasBeenConvertedToPrimitive;
    private final Map<RelType, Set<ClassInfo>> relatedClasses = new HashMap<RelType, Set<ClassInfo>>();
    private transient List<ClassInfo> overrideOrder;
    private static final int ANNOTATION_CLASS_MODIFIER = 8192;
    private static final ReachableAndDirectlyRelatedClasses NO_REACHABLE_CLASSES = new ReachableAndDirectlyRelatedClasses(Collections.emptySet(), Collections.emptySet());

    ClassInfo() {
    }

    private ClassInfo(String name, int classModifiers) {
        this();
        this.name = name;
        if (name.endsWith(";")) {
            throw new RuntimeException("Bad class name");
        }
        this.modifiers = classModifiers;
    }

    private boolean addRelatedClass(RelType relType, ClassInfo classInfo) {
        Set<ClassInfo> classInfoSet = this.relatedClasses.get((Object)relType);
        if (classInfoSet == null) {
            classInfoSet = new LinkedHashSet<ClassInfo>(4);
            this.relatedClasses.put(relType, classInfoSet);
        }
        return classInfoSet.add(classInfo);
    }

    static ClassInfo getOrCreateClassInfo(String className, int classModifiers, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo classInfo = classNameToClassInfo.get(className);
        if (classInfo == null) {
            classInfo = new ClassInfo(className, classModifiers);
            classNameToClassInfo.put(className, classInfo);
        }
        classInfo.modifiers |= classModifiers;
        if ((classModifiers & 0x2000) != 0) {
            classInfo.isAnnotation = true;
        }
        if ((classModifiers & 0x200) != 0) {
            classInfo.isInterface = true;
        }
        return classInfo;
    }

    void addSuperclass(String superclassName, Map<String, ClassInfo> classNameToClassInfo) {
        if (superclassName != null && !superclassName.equals("java.lang.Object")) {
            ClassInfo superclassClassInfo = ClassInfo.getOrCreateClassInfo(superclassName, 0, classNameToClassInfo);
            this.addRelatedClass(RelType.SUPERCLASSES, superclassClassInfo);
            superclassClassInfo.addRelatedClass(RelType.SUBCLASSES, this);
        }
    }

    void addImplementedInterface(String interfaceName, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo interfaceClassInfo = ClassInfo.getOrCreateClassInfo(interfaceName, 512, classNameToClassInfo);
        interfaceClassInfo.isInterface = true;
        interfaceClassInfo.modifiers |= 0x200;
        this.addRelatedClass(RelType.IMPLEMENTED_INTERFACES, interfaceClassInfo);
        interfaceClassInfo.addRelatedClass(RelType.CLASSES_IMPLEMENTING, this);
    }

    static void addClassContainment(List<AbstractMap.SimpleEntry<String, String>> classContainmentEntries, Map<String, ClassInfo> classNameToClassInfo) {
        for (AbstractMap.SimpleEntry<String, String> ent : classContainmentEntries) {
            String innerClassName = ent.getKey();
            ClassInfo innerClassInfo = ClassInfo.getOrCreateClassInfo(innerClassName, 0, classNameToClassInfo);
            String outerClassName = ent.getValue();
            ClassInfo outerClassInfo = ClassInfo.getOrCreateClassInfo(outerClassName, 0, classNameToClassInfo);
            innerClassInfo.addRelatedClass(RelType.CONTAINED_WITHIN_OUTER_CLASS, outerClassInfo);
            outerClassInfo.addRelatedClass(RelType.CONTAINS_INNER_CLASS, innerClassInfo);
        }
    }

    void addFullyQualifiedDefiningMethodName(String fullyQualifiedDefiningMethodName) {
        this.fullyQualifiedDefiningMethodName = fullyQualifiedDefiningMethodName;
    }

    void addClassAnnotation(AnnotationInfo classAnnotationInfo, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(classAnnotationInfo.getName(), 8192, classNameToClassInfo);
        if (this.annotationInfo == null) {
            this.annotationInfo = new AnnotationInfoList(2);
        }
        this.annotationInfo.add(classAnnotationInfo);
        this.addRelatedClass(RelType.CLASS_ANNOTATIONS, annotationClassInfo);
        annotationClassInfo.addRelatedClass(RelType.CLASSES_WITH_ANNOTATION, this);
        if (classAnnotationInfo.getName().equals(Inherited.class.getName())) {
            this.isInherited = true;
        }
    }

    void addFieldInfo(FieldInfoList fieldInfoList, Map<String, ClassInfo> classNameToClassInfo) {
        for (FieldInfo fieldInfo : fieldInfoList) {
            AnnotationInfoList fieldAnnotationInfoList = fieldInfo.annotationInfo;
            if (fieldAnnotationInfoList == null) continue;
            for (AnnotationInfo fieldAnnotationInfo : fieldAnnotationInfoList) {
                ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(fieldAnnotationInfo.getName(), 8192, classNameToClassInfo);
                this.addRelatedClass(RelType.FIELD_ANNOTATIONS, annotationClassInfo);
                annotationClassInfo.addRelatedClass(RelType.CLASSES_WITH_FIELD_ANNOTATION, this);
            }
        }
        if (this.fieldInfo == null) {
            this.fieldInfo = fieldInfoList;
        } else {
            this.fieldInfo.addAll(fieldInfoList);
        }
    }

    void addMethodInfo(MethodInfoList methodInfoList, Map<String, ClassInfo> classNameToClassInfo) {
        for (MethodInfo methodInfo : methodInfoList) {
            AnnotationInfoList methodAnnotationInfoList = methodInfo.annotationInfo;
            if (methodAnnotationInfoList == null) continue;
            for (AnnotationInfo methodAnnotationInfo : methodAnnotationInfoList) {
                ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(methodAnnotationInfo.getName(), 8192, classNameToClassInfo);
                this.addRelatedClass(RelType.METHOD_ANNOTATIONS, annotationClassInfo);
                annotationClassInfo.addRelatedClass(RelType.CLASSES_WITH_METHOD_ANNOTATION, this);
            }
        }
        if (this.methodInfo == null) {
            this.methodInfo = methodInfoList;
        } else {
            this.methodInfo.addAll(methodInfoList);
        }
    }

    void addTypeSignature(String typeSignatureStr) {
        if (this.typeSignatureStr == null) {
            this.typeSignatureStr = typeSignatureStr;
        } else if (typeSignatureStr != null && !this.typeSignatureStr.equals(typeSignatureStr)) {
            throw new RuntimeException("Trying to merge two classes with different type signatures for class " + this.name + ": " + this.typeSignatureStr + " ; " + typeSignatureStr);
        }
    }

    void addAnnotationParamDefaultValues(AnnotationParameterValueList paramNamesAndValues) {
        if (this.annotationDefaultParamValues == null) {
            this.annotationDefaultParamValues = paramNamesAndValues;
        } else {
            this.annotationDefaultParamValues.addAll(paramNamesAndValues);
        }
    }

    Set<String> getReferencedClassNames() {
        if (this.referencedClassNames == null) {
            this.referencedClassNames = new HashSet<String>();
        }
        this.getAnnotationInfo().getReferencedClassNames(this.referencedClassNames);
        this.getMethodInfo().getReferencedClassNames(this.referencedClassNames);
        this.getFieldInfo().getReferencedClassNames(this.referencedClassNames);
        this.referencedClassNames.remove(this.name);
        this.referencedClassNames.remove("java.lang.Object");
        return this.referencedClassNames;
    }

    void addReferencedClassNames(Set<String> refdClassNames) {
        if (this.referencedClassNames == null) {
            this.referencedClassNames = refdClassNames;
        } else {
            this.referencedClassNames.addAll(refdClassNames);
        }
    }

    void setReferencedClasses(ClassInfoList refdClasses) {
        this.referencedClasses = refdClasses;
    }

    public ClassInfoList getClassDependencies() {
        if (!this.scanResult.scanSpec.enableInterClassDependencies) {
            throw new IllegalArgumentException("Please call ClassGraph#enableInterClassDependencies() before #scan()");
        }
        return this.referencedClasses == null ? ClassInfoList.EMPTY_LIST : this.referencedClasses;
    }

    static ClassInfo addScannedClass(String className, int classModifiers, boolean isInterface, boolean isAnnotation, boolean isExternalClass, Map<String, ClassInfo> classNameToClassInfo, ClasspathElement classpathElement, Resource classfileResource, ScanSpec scanSpec, LogNode log) {
        File file;
        ModuleRef modRef;
        boolean classEncounteredMultipleTimes = false;
        ClassInfo classInfo = classNameToClassInfo.get(className);
        if (classInfo == null) {
            classInfo = new ClassInfo(className, classModifiers);
            classNameToClassInfo.put(className, classInfo);
        } else if (classInfo.isScannedClass) {
            classEncounteredMultipleTimes = true;
        }
        classInfo.isScannedClass = true;
        if (!isExternalClass) {
            classInfo.isExternalClass = isExternalClass;
        }
        ModuleRef moduleRef = modRef = classpathElement instanceof ClasspathElementModule ? ((ClasspathElementModule)classpathElement).getModuleRef() : null;
        File file2 = modRef != null ? null : (classpathElement instanceof ClasspathElementDir ? ((ClasspathElementDir)classpathElement).getDirFile() : (file = classpathElement instanceof ClasspathElementZip ? ((ClasspathElementZip)classpathElement).getZipFile() : null));
        if (classInfo.moduleRef != null && modRef != null && !classInfo.moduleRef.equals(modRef) || classInfo.classpathElementFile != null && file != null && !classInfo.classpathElementFile.equals(file)) {
            classEncounteredMultipleTimes = true;
        }
        if (classEncounteredMultipleTimes && log != null) {
            log.log("Class " + className + " is defined in multiple different classpath elements or modules. Attempting to merge info from all copies of the classfile.");
        }
        if (classInfo.classpathElementFile == null) {
            classInfo.classpathElementFile = file;
            classInfo.jarfilePackageRoot = classpathElement.getPackageRoot();
        }
        if (classInfo.moduleRef == null) {
            classInfo.moduleRef = modRef;
        }
        if (classInfo.resource == null) {
            classInfo.resource = classfileResource;
        }
        Object[] classLoaders = classpathElement.getClassLoaders();
        if (classInfo.classLoaders == null) {
            classInfo.classLoaders = classLoaders;
        } else if (classLoaders != null && !Arrays.equals(classInfo.classLoaders, classLoaders)) {
            LinkedHashSet<ClassLoader> allClassLoaders = new LinkedHashSet<ClassLoader>(Arrays.asList(classInfo.classLoaders));
            Collections.addAll(allClassLoaders, classLoaders);
            ArrayList<ClassLoader> classLoaderOrder = new ArrayList<ClassLoader>(allClassLoaders);
            classInfo.classLoaders = classLoaderOrder.toArray(new ClassLoader[0]);
        }
        classInfo.modifiers |= classModifiers;
        classInfo.isInterface |= isInterface;
        classInfo.isAnnotation |= isAnnotation;
        return classInfo;
    }

    private static Set<ClassInfo> filterClassInfo(Collection<ClassInfo> classes, ScanSpec scanSpec, boolean strictWhitelist, ClassType ... classTypes) {
        if (classes == null) {
            return null;
        }
        boolean includeAllTypes = classTypes.length == 0;
        boolean includeStandardClasses = false;
        boolean includeImplementedInterfaces = false;
        boolean includeAnnotations = false;
        block7: for (ClassType classType : classTypes) {
            switch (classType) {
                case ALL: {
                    includeAllTypes = true;
                    continue block7;
                }
                case STANDARD_CLASS: {
                    includeStandardClasses = true;
                    continue block7;
                }
                case IMPLEMENTED_INTERFACE: {
                    includeImplementedInterfaces = true;
                    continue block7;
                }
                case ANNOTATION: {
                    includeAnnotations = true;
                    continue block7;
                }
                case INTERFACE_OR_ANNOTATION: {
                    includeAnnotations = true;
                    includeImplementedInterfaces = true;
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Unknown ClassType: " + (Object)((Object)classType));
                }
            }
        }
        if (includeStandardClasses && includeImplementedInterfaces && includeAnnotations) {
            includeAllTypes = true;
        }
        LinkedHashSet<ClassInfo> classInfoSetFiltered = new LinkedHashSet<ClassInfo>(classes.size());
        for (ClassInfo classInfo : classes) {
            if (!(includeAllTypes || includeStandardClasses && classInfo.isStandardClass() || includeImplementedInterfaces && classInfo.isImplementedInterface()) && (!includeAnnotations || !classInfo.isAnnotation()) || scanSpec.classOrPackageIsBlacklisted(classInfo.name) || classInfo.isExternalClass && !scanSpec.enableExternalClasses && strictWhitelist) continue;
            classInfoSetFiltered.add(classInfo);
        }
        return classInfoSetFiltered;
    }

    private ReachableAndDirectlyRelatedClasses filterClassInfo(RelType relType, boolean strictWhitelist, ClassType ... classTypes) {
        Set<ClassInfo> directlyRelatedClasses = this.relatedClasses.get((Object)relType);
        if (directlyRelatedClasses == null) {
            return NO_REACHABLE_CLASSES;
        }
        LinkedHashSet<ClassInfo> reachableClasses = new LinkedHashSet<ClassInfo>(directlyRelatedClasses);
        if (relType == RelType.METHOD_ANNOTATIONS || relType == RelType.FIELD_ANNOTATIONS) {
            for (ClassInfo annotation : directlyRelatedClasses) {
                reachableClasses.addAll(annotation.filterClassInfo((RelType)RelType.CLASS_ANNOTATIONS, (boolean)strictWhitelist, (ClassType[])new ClassType[0]).reachableClasses);
            }
        } else if (relType == RelType.CLASSES_WITH_METHOD_ANNOTATION || relType == RelType.CLASSES_WITH_FIELD_ANNOTATION) {
            for (ClassInfo subAnnotation : this.filterClassInfo((RelType)RelType.CLASSES_WITH_ANNOTATION, (boolean)strictWhitelist, (ClassType[])new ClassType[]{ClassType.ANNOTATION}).reachableClasses) {
                Set<ClassInfo> annotatedClasses = subAnnotation.relatedClasses.get((Object)relType);
                if (annotatedClasses == null) continue;
                reachableClasses.addAll(annotatedClasses);
            }
        } else {
            LinkedList<ClassInfo> queue = new LinkedList<ClassInfo>(directlyRelatedClasses);
            while (!queue.isEmpty()) {
                ClassInfo head = queue.removeFirst();
                Set<ClassInfo> headRelatedClasses = head.relatedClasses.get((Object)relType);
                if (headRelatedClasses == null) continue;
                for (ClassInfo directlyReachableFromHead : headRelatedClasses) {
                    if (!reachableClasses.add(directlyReachableFromHead)) continue;
                    queue.add(directlyReachableFromHead);
                }
            }
        }
        if (reachableClasses.isEmpty()) {
            return NO_REACHABLE_CLASSES;
        }
        LinkedHashSet<ClassInfo> javaLangAnnotationRelatedClasses = null;
        for (ClassInfo classInfo : reachableClasses) {
            if (!classInfo.getName().startsWith("java.lang.annotation.")) continue;
            if (javaLangAnnotationRelatedClasses == null) {
                javaLangAnnotationRelatedClasses = new LinkedHashSet<ClassInfo>();
            }
            javaLangAnnotationRelatedClasses.add(classInfo);
        }
        if (javaLangAnnotationRelatedClasses != null) {
            LinkedHashSet<ClassInfo> javaLangAnnotationDirectlyRelatedClasses = null;
            for (ClassInfo classInfo : directlyRelatedClasses) {
                if (!classInfo.getName().startsWith("java.lang.annotation.")) continue;
                if (javaLangAnnotationDirectlyRelatedClasses == null) {
                    javaLangAnnotationDirectlyRelatedClasses = new LinkedHashSet<ClassInfo>();
                }
                javaLangAnnotationDirectlyRelatedClasses.add(classInfo);
            }
            if (javaLangAnnotationDirectlyRelatedClasses != null) {
                javaLangAnnotationRelatedClasses.removeAll(javaLangAnnotationDirectlyRelatedClasses);
            }
            reachableClasses.removeAll(javaLangAnnotationRelatedClasses);
        }
        return new ReachableAndDirectlyRelatedClasses(ClassInfo.filterClassInfo(reachableClasses, this.scanResult.scanSpec, strictWhitelist, new ClassType[0]), ClassInfo.filterClassInfo(directlyRelatedClasses, this.scanResult.scanSpec, strictWhitelist, new ClassType[0]));
    }

    static ClassInfoList getAllClasses(Collection<ClassInfo> classes, ScanSpec scanSpec, ScanResult scanResult) {
        return new ClassInfoList(ClassInfo.filterClassInfo(classes, scanSpec, true, ClassType.ALL), true);
    }

    static ClassInfoList getAllStandardClasses(Collection<ClassInfo> classes, ScanSpec scanSpec, ScanResult scanResult) {
        return new ClassInfoList(ClassInfo.filterClassInfo(classes, scanSpec, true, ClassType.STANDARD_CLASS), true);
    }

    static ClassInfoList getAllImplementedInterfaceClasses(Collection<ClassInfo> classes, ScanSpec scanSpec, ScanResult scanResult) {
        return new ClassInfoList(ClassInfo.filterClassInfo(classes, scanSpec, true, ClassType.IMPLEMENTED_INTERFACE), true);
    }

    static ClassInfoList getAllAnnotationClasses(Collection<ClassInfo> classes, ScanSpec scanSpec, ScanResult scanResult) {
        return new ClassInfoList(ClassInfo.filterClassInfo(classes, scanSpec, true, ClassType.ANNOTATION), true);
    }

    static ClassInfoList getAllInterfacesOrAnnotationClasses(Collection<ClassInfo> classes, ScanSpec scanSpec, ScanResult scanResult) {
        return new ClassInfoList(ClassInfo.filterClassInfo(classes, scanSpec, true, ClassType.INTERFACE_OR_ANNOTATION), true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.name.substring(this.name.lastIndexOf(46) + 1);
    }

    public String getPackageName() {
        int dotIdx = this.name.lastIndexOf(46);
        return dotIdx < 0 ? "" : this.name.substring(0, dotIdx);
    }

    public boolean isExternalClass() {
        return this.isExternalClass;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getModifiersStr() {
        StringBuilder buf = new StringBuilder();
        ClassTypeSignature.modifiersToString(this.modifiers, buf);
        return buf.toString();
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean isInterface() {
        return this.isInterface && !this.isAnnotation;
    }

    public boolean isInterfaceOrAnnotation() {
        return this.isInterface;
    }

    public boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public boolean isStandardClass() {
        return !this.isAnnotation && !this.isInterface;
    }

    public boolean extendsSuperclass(String superclassName) {
        return this.getSuperclasses().containsName(superclassName);
    }

    public boolean isInnerClass() {
        return !this.getOuterClasses().isEmpty();
    }

    public boolean isOuterClass() {
        return !this.getInnerClasses().isEmpty();
    }

    public boolean isAnonymousInnerClass() {
        return this.fullyQualifiedDefiningMethodName != null;
    }

    public boolean isImplementedInterface() {
        return this.relatedClasses.get((Object)RelType.CLASSES_IMPLEMENTING) != null || this.isInterface && !this.isAnnotation;
    }

    public boolean implementsInterface(String interfaceName) {
        return this.getInterfaces().containsName(interfaceName);
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotations().containsName(annotationName);
    }

    public boolean hasDeclaredField(String fieldName) {
        return this.getDeclaredFieldInfo().containsName(fieldName);
    }

    public boolean hasField(String fieldName) {
        for (ClassInfo ci : this.getOverrideOrder()) {
            if (!ci.hasDeclaredField(fieldName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeclaredFieldAnnotation(String fieldAnnotationName) {
        for (FieldInfo fieldInfo : this.getDeclaredFieldInfo()) {
            if (!fieldInfo.hasAnnotation(fieldAnnotationName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFieldAnnotation(String fieldAnnotationName) {
        for (ClassInfo ci : this.getOverrideOrder()) {
            if (!ci.hasDeclaredFieldAnnotation(fieldAnnotationName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeclaredMethod(String methodName) {
        return this.getDeclaredMethodInfo().containsName(methodName);
    }

    public boolean hasMethod(String methodName) {
        for (ClassInfo ci : this.getOverrideOrder()) {
            if (!ci.hasDeclaredMethod(methodName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeclaredMethodAnnotation(String methodAnnotationName) {
        for (MethodInfo methodInfo : this.getDeclaredMethodInfo()) {
            if (!methodInfo.hasAnnotation(methodAnnotationName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMethodAnnotation(String methodAnnotationName) {
        for (ClassInfo ci : this.getOverrideOrder()) {
            if (!ci.hasDeclaredMethodAnnotation(methodAnnotationName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeclaredMethodParameterAnnotation(String methodParameterAnnotationName) {
        for (MethodInfo methodInfo : this.getDeclaredMethodInfo()) {
            if (!methodInfo.hasParameterAnnotation(methodParameterAnnotationName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMethodParameterAnnotation(String methodParameterAnnotationName) {
        for (ClassInfo ci : this.getOverrideOrder()) {
            if (!ci.hasDeclaredMethodParameterAnnotation(methodParameterAnnotationName)) continue;
            return true;
        }
        return false;
    }

    private List<ClassInfo> getOverrideOrder(Set<ClassInfo> visited, List<ClassInfo> overrideOrderOut) {
        if (visited.add(this)) {
            overrideOrderOut.add(this);
            for (ClassInfo iface : this.getInterfaces()) {
                iface.getOverrideOrder(visited, overrideOrderOut);
            }
            ClassInfo superclass = this.getSuperclass();
            if (superclass != null) {
                superclass.getOverrideOrder(visited, overrideOrderOut);
            }
        }
        return overrideOrderOut;
    }

    private List<ClassInfo> getOverrideOrder() {
        if (this.overrideOrder == null) {
            this.overrideOrder = this.getOverrideOrder(new HashSet<ClassInfo>(), new ArrayList<ClassInfo>());
        }
        return this.overrideOrder;
    }

    public ClassInfoList getSubclasses() {
        if (this.getName().equals("java.lang.Object")) {
            return this.scanResult.getAllClasses();
        }
        return new ClassInfoList(this.filterClassInfo(RelType.SUBCLASSES, !this.isExternalClass, new ClassType[0]), true);
    }

    public ClassInfoList getSuperclasses() {
        return new ClassInfoList(this.filterClassInfo(RelType.SUPERCLASSES, false, new ClassType[0]), false);
    }

    public ClassInfo getSuperclass() {
        Set<ClassInfo> superClasses = this.relatedClasses.get((Object)RelType.SUPERCLASSES);
        if (superClasses == null || superClasses.isEmpty()) {
            return null;
        }
        if (superClasses.size() > 2) {
            throw new IllegalArgumentException("More than one superclass: " + superClasses);
        }
        ClassInfo superclass = superClasses.iterator().next();
        if (superclass.getName().equals("java.lang.Object")) {
            return null;
        }
        return superclass;
    }

    public ClassInfoList getOuterClasses() {
        return new ClassInfoList(this.filterClassInfo(RelType.CONTAINED_WITHIN_OUTER_CLASS, false, new ClassType[0]), false);
    }

    public ClassInfoList getInnerClasses() {
        return new ClassInfoList(this.filterClassInfo(RelType.CONTAINS_INNER_CLASS, false, new ClassType[0]), true);
    }

    public String getFullyQualifiedDefiningMethodName() {
        return this.fullyQualifiedDefiningMethodName;
    }

    public ClassInfoList getInterfaces() {
        ReachableAndDirectlyRelatedClasses implementedInterfaces = this.filterClassInfo(RelType.IMPLEMENTED_INTERFACES, false, new ClassType[0]);
        LinkedHashSet<ClassInfo> allInterfaces = new LinkedHashSet<ClassInfo>(implementedInterfaces.reachableClasses);
        for (ClassInfo superclass : this.filterClassInfo((RelType)RelType.SUPERCLASSES, (boolean)false, (ClassType[])new ClassType[0]).reachableClasses) {
            Set<ClassInfo> superclassImplementedInterfaces = superclass.filterClassInfo((RelType)RelType.IMPLEMENTED_INTERFACES, (boolean)false, (ClassType[])new ClassType[0]).reachableClasses;
            allInterfaces.addAll(superclassImplementedInterfaces);
        }
        return new ClassInfoList(allInterfaces, implementedInterfaces.directlyRelatedClasses, true);
    }

    public ClassInfoList getClassesImplementing() {
        if (!this.isInterface) {
            throw new IllegalArgumentException("Class is not an interface: " + this.getName());
        }
        ReachableAndDirectlyRelatedClasses implementingClasses = this.filterClassInfo(RelType.CLASSES_IMPLEMENTING, !this.isExternalClass, new ClassType[0]);
        LinkedHashSet<ClassInfo> allImplementingClasses = new LinkedHashSet<ClassInfo>(implementingClasses.reachableClasses);
        for (ClassInfo implementingClass : implementingClasses.reachableClasses) {
            Set<ClassInfo> implementingSubclasses = implementingClass.filterClassInfo((RelType)RelType.SUBCLASSES, (boolean)(!implementingClass.isExternalClass ? true : false), (ClassType[])new ClassType[0]).reachableClasses;
            allImplementingClasses.addAll(implementingSubclasses);
        }
        return new ClassInfoList(allImplementingClasses, implementingClasses.directlyRelatedClasses, true);
    }

    public ClassInfoList getAnnotations() {
        if (!this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableAnnotationInfo() before #scan()");
        }
        ReachableAndDirectlyRelatedClasses annotationClasses = this.filterClassInfo(RelType.CLASS_ANNOTATIONS, false, new ClassType[0]);
        LinkedHashSet<ClassInfo> inheritedSuperclassAnnotations = null;
        for (ClassInfo superclass : this.getSuperclasses()) {
            for (ClassInfo superclassAnnotationClass : superclass.filterClassInfo((RelType)RelType.CLASS_ANNOTATIONS, (boolean)false, (ClassType[])new ClassType[0]).reachableClasses) {
                if (superclassAnnotationClass == null || !superclassAnnotationClass.isInherited) continue;
                if (inheritedSuperclassAnnotations == null) {
                    inheritedSuperclassAnnotations = new LinkedHashSet<ClassInfo>();
                }
                inheritedSuperclassAnnotations.add(superclassAnnotationClass);
            }
        }
        if (inheritedSuperclassAnnotations == null) {
            return new ClassInfoList(annotationClasses, true);
        }
        inheritedSuperclassAnnotations.addAll(annotationClasses.reachableClasses);
        return new ClassInfoList((Set<ClassInfo>)inheritedSuperclassAnnotations, annotationClasses.directlyRelatedClasses, true);
    }

    public AnnotationInfoList getAnnotationInfo() {
        if (!this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableAnnotationInfo() before #scan()");
        }
        return AnnotationInfoList.getIndirectAnnotations(this.annotationInfo, this);
    }

    public AnnotationInfo getAnnotationInfo(String annotationName) {
        return (AnnotationInfo)this.getAnnotationInfo().get(annotationName);
    }

    public AnnotationParameterValueList getAnnotationDefaultParameterValues() {
        if (!this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableAnnotationInfo() before #scan()");
        }
        if (!this.isAnnotation) {
            throw new IllegalArgumentException("Class is not an annotation: " + this.getName());
        }
        if (this.annotationDefaultParamValues == null) {
            return AnnotationParameterValueList.EMPTY_LIST;
        }
        if (!this.annotationDefaultParamValuesHasBeenConvertedToPrimitive) {
            this.annotationDefaultParamValues.convertWrapperArraysToPrimitiveArrays(this);
            this.annotationDefaultParamValuesHasBeenConvertedToPrimitive = true;
        }
        return this.annotationDefaultParamValues;
    }

    public ClassInfoList getClassesWithAnnotation() {
        if (!this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableAnnotationInfo() before #scan()");
        }
        if (!this.isAnnotation) {
            throw new IllegalArgumentException("Class is not an annotation: " + this.getName());
        }
        ReachableAndDirectlyRelatedClasses classesWithAnnotation = this.filterClassInfo(RelType.CLASSES_WITH_ANNOTATION, !this.isExternalClass, new ClassType[0]);
        if (this.isInherited) {
            LinkedHashSet<ClassInfo> classesWithAnnotationAndTheirSubclasses = new LinkedHashSet<ClassInfo>(classesWithAnnotation.reachableClasses);
            for (ClassInfo classWithAnnotation : classesWithAnnotation.reachableClasses) {
                classesWithAnnotationAndTheirSubclasses.addAll(classWithAnnotation.getSubclasses());
            }
            return new ClassInfoList(classesWithAnnotationAndTheirSubclasses, classesWithAnnotation.directlyRelatedClasses, true);
        }
        return new ClassInfoList(classesWithAnnotation, true);
    }

    ClassInfoList getClassesWithAnnotationDirectOnly() {
        return new ClassInfoList(this.filterClassInfo(RelType.CLASSES_WITH_ANNOTATION, !this.isExternalClass, new ClassType[0]), true);
    }

    public MethodInfoList getDeclaredMethodInfo() {
        if (!this.scanResult.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() before #scan()");
        }
        if (this.methodInfo == null) {
            return MethodInfoList.EMPTY_LIST;
        }
        MethodInfoList nonConstructorMethods = new MethodInfoList();
        for (MethodInfo mi : this.methodInfo) {
            String methodName = mi.getName();
            if (methodName.equals("<init>") || methodName.equals("<clinit>")) continue;
            nonConstructorMethods.add(mi);
        }
        return nonConstructorMethods;
    }

    public MethodInfoList getMethodInfo() {
        if (!this.scanResult.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() before #scan()");
        }
        MethodInfoList methodInfoList = new MethodInfoList();
        HashSet<AbstractMap.SimpleEntry<String, String>> nameAndTypeDescriptorSet = new HashSet<AbstractMap.SimpleEntry<String, String>>();
        for (ClassInfo ci : this.getOverrideOrder()) {
            for (MethodInfo mi : ci.getDeclaredMethodInfo()) {
                if (!nameAndTypeDescriptorSet.add(new AbstractMap.SimpleEntry<String, String>(mi.getName(), mi.getTypeDescriptor().toString()))) continue;
                methodInfoList.add(mi);
            }
        }
        return methodInfoList;
    }

    public MethodInfoList getDeclaredConstructorInfo() {
        if (!this.scanResult.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() before #scan()");
        }
        if (this.methodInfo == null) {
            return MethodInfoList.EMPTY_LIST;
        }
        MethodInfoList nonConstructorMethods = new MethodInfoList();
        for (MethodInfo mi : this.methodInfo) {
            String methodName = mi.getName();
            if (!methodName.equals("<init>")) continue;
            nonConstructorMethods.add(mi);
        }
        return nonConstructorMethods;
    }

    public MethodInfoList getConstructorInfo() {
        if (!this.scanResult.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() before #scan()");
        }
        MethodInfoList methodInfoList = new MethodInfoList();
        HashSet<AbstractMap.SimpleEntry<String, String>> nameAndTypeDescriptorSet = new HashSet<AbstractMap.SimpleEntry<String, String>>();
        for (ClassInfo ci : this.getOverrideOrder()) {
            for (MethodInfo mi : ci.getDeclaredConstructorInfo()) {
                if (!nameAndTypeDescriptorSet.add(new AbstractMap.SimpleEntry<String, String>(mi.getName(), mi.getTypeDescriptor().toString()))) continue;
                methodInfoList.add(mi);
            }
        }
        return methodInfoList;
    }

    public MethodInfoList getDeclaredMethodAndConstructorInfo() {
        if (!this.scanResult.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() before #scan()");
        }
        return this.methodInfo == null ? MethodInfoList.EMPTY_LIST : this.methodInfo;
    }

    public MethodInfoList getMethodAndConstructorInfo() {
        if (!this.scanResult.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() before #scan()");
        }
        MethodInfoList methodInfoList = new MethodInfoList();
        HashSet<AbstractMap.SimpleEntry<String, String>> nameAndTypeDescriptorSet = new HashSet<AbstractMap.SimpleEntry<String, String>>();
        for (ClassInfo ci : this.getOverrideOrder()) {
            for (MethodInfo mi : ci.getDeclaredMethodAndConstructorInfo()) {
                if (!nameAndTypeDescriptorSet.add(new AbstractMap.SimpleEntry<String, String>(mi.getName(), mi.getTypeDescriptor().toString()))) continue;
                methodInfoList.add(mi);
            }
        }
        return methodInfoList;
    }

    public MethodInfoList getDeclaredMethodInfo(String methodName) {
        if (!this.scanResult.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() before #scan()");
        }
        if (this.methodInfo == null) {
            return MethodInfoList.EMPTY_LIST;
        }
        boolean hasMethodWithName = false;
        for (MethodInfo f : this.methodInfo) {
            if (!f.getName().equals(methodName)) continue;
            hasMethodWithName = true;
            break;
        }
        if (!hasMethodWithName) {
            return MethodInfoList.EMPTY_LIST;
        }
        MethodInfoList methodInfoList = new MethodInfoList();
        for (MethodInfo mi : this.methodInfo) {
            if (!mi.getName().equals(methodName)) continue;
            methodInfoList.add(mi);
        }
        return methodInfoList;
    }

    public MethodInfoList getMethodInfo(String methodName) {
        if (!this.scanResult.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() before #scan()");
        }
        MethodInfoList methodInfoList = new MethodInfoList();
        HashSet<String> typeDescriptorSet = new HashSet<String>();
        for (ClassInfo ci : this.getOverrideOrder()) {
            for (MethodInfo mi : ci.getDeclaredMethodInfo(methodName)) {
                if (!typeDescriptorSet.add(mi.getTypeDescriptor().toString())) continue;
                methodInfoList.add(mi);
            }
        }
        return methodInfoList;
    }

    public ClassInfoList getMethodAnnotations() {
        if (!this.scanResult.scanSpec.enableMethodInfo || !this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() and #enableAnnotationInfo() before #scan()");
        }
        ReachableAndDirectlyRelatedClasses methodAnnotations = this.filterClassInfo(RelType.METHOD_ANNOTATIONS, false, ClassType.ANNOTATION);
        LinkedHashSet<ClassInfo> methodAnnotationsAndMetaAnnotations = new LinkedHashSet<ClassInfo>(methodAnnotations.reachableClasses);
        for (ClassInfo methodAnnotation : methodAnnotations.reachableClasses) {
            methodAnnotationsAndMetaAnnotations.addAll(methodAnnotation.filterClassInfo((RelType)RelType.CLASS_ANNOTATIONS, (boolean)false, (ClassType[])new ClassType[0]).reachableClasses);
        }
        return new ClassInfoList(methodAnnotationsAndMetaAnnotations, methodAnnotations.directlyRelatedClasses, true);
    }

    public ClassInfoList getClassesWithMethodAnnotation() {
        if (!this.scanResult.scanSpec.enableMethodInfo || !this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() and #enableAnnotationInfo() before #scan()");
        }
        ReachableAndDirectlyRelatedClasses classesWithDirectlyAnnotatedMethods = this.filterClassInfo(RelType.CLASSES_WITH_METHOD_ANNOTATION, !this.isExternalClass, new ClassType[0]);
        ReachableAndDirectlyRelatedClasses annotationsWithThisMetaAnnotation = this.filterClassInfo(RelType.CLASSES_WITH_ANNOTATION, !this.isExternalClass, ClassType.ANNOTATION);
        if (annotationsWithThisMetaAnnotation.reachableClasses.isEmpty()) {
            return new ClassInfoList(classesWithDirectlyAnnotatedMethods, true);
        }
        LinkedHashSet<ClassInfo> allClassesWithAnnotatedOrMetaAnnotatedMethods = new LinkedHashSet<ClassInfo>(classesWithDirectlyAnnotatedMethods.reachableClasses);
        for (ClassInfo metaAnnotatedAnnotation : annotationsWithThisMetaAnnotation.reachableClasses) {
            allClassesWithAnnotatedOrMetaAnnotatedMethods.addAll(metaAnnotatedAnnotation.filterClassInfo((RelType)RelType.CLASSES_WITH_METHOD_ANNOTATION, (boolean)(!metaAnnotatedAnnotation.isExternalClass ? true : false), (ClassType[])new ClassType[0]).reachableClasses);
        }
        return new ClassInfoList(allClassesWithAnnotatedOrMetaAnnotatedMethods, classesWithDirectlyAnnotatedMethods.directlyRelatedClasses, true);
    }

    ClassInfoList getClassesWithMethodAnnotationDirectOnly() {
        return new ClassInfoList(this.filterClassInfo(RelType.CLASSES_WITH_METHOD_ANNOTATION, !this.isExternalClass, new ClassType[0]), true);
    }

    public FieldInfoList getDeclaredFieldInfo() {
        if (!this.scanResult.scanSpec.enableFieldInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableFieldInfo() before #scan()");
        }
        return this.fieldInfo == null ? FieldInfoList.EMPTY_LIST : this.fieldInfo;
    }

    public FieldInfoList getFieldInfo() {
        if (!this.scanResult.scanSpec.enableFieldInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableFieldInfo() before #scan()");
        }
        FieldInfoList fieldInfoList = new FieldInfoList();
        HashSet<String> fieldNameSet = new HashSet<String>();
        for (ClassInfo ci : this.getOverrideOrder()) {
            for (FieldInfo fi : ci.getDeclaredFieldInfo()) {
                if (!fieldNameSet.add(fi.getName())) continue;
                fieldInfoList.add(fi);
            }
        }
        return fieldInfoList;
    }

    public FieldInfo getDeclaredFieldInfo(String fieldName) {
        if (!this.scanResult.scanSpec.enableFieldInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableFieldInfo() before #scan()");
        }
        if (this.fieldInfo == null) {
            return null;
        }
        for (FieldInfo fi : this.fieldInfo) {
            if (!fi.getName().equals(fieldName)) continue;
            return fi;
        }
        return null;
    }

    public FieldInfo getFieldInfo(String fieldName) {
        if (!this.scanResult.scanSpec.enableFieldInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableFieldInfo() before #scan()");
        }
        for (ClassInfo ci : this.getOverrideOrder()) {
            FieldInfo fi = ci.getDeclaredFieldInfo(fieldName);
            if (fi == null) continue;
            return fi;
        }
        return null;
    }

    public ClassInfoList getFieldAnnotations() {
        if (!this.scanResult.scanSpec.enableFieldInfo || !this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableFieldInfo() and ClassGraph#enableAnnotationInfo() before #scan()");
        }
        ReachableAndDirectlyRelatedClasses fieldAnnotations = this.filterClassInfo(RelType.FIELD_ANNOTATIONS, false, ClassType.ANNOTATION);
        LinkedHashSet<ClassInfo> fieldAnnotationsAndMetaAnnotations = new LinkedHashSet<ClassInfo>(fieldAnnotations.reachableClasses);
        for (ClassInfo fieldAnnotation : fieldAnnotations.reachableClasses) {
            fieldAnnotationsAndMetaAnnotations.addAll(fieldAnnotation.filterClassInfo((RelType)RelType.CLASS_ANNOTATIONS, (boolean)false, (ClassType[])new ClassType[0]).reachableClasses);
        }
        return new ClassInfoList(fieldAnnotationsAndMetaAnnotations, fieldAnnotations.directlyRelatedClasses, true);
    }

    public ClassInfoList getClassesWithFieldAnnotation() {
        if (!this.scanResult.scanSpec.enableFieldInfo || !this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableFieldInfo() and ClassGraph#enableAnnotationInfo() before #scan()");
        }
        ReachableAndDirectlyRelatedClasses classesWithDirectlyAnnotatedFields = this.filterClassInfo(RelType.CLASSES_WITH_FIELD_ANNOTATION, !this.isExternalClass, new ClassType[0]);
        ReachableAndDirectlyRelatedClasses annotationsWithThisMetaAnnotation = this.filterClassInfo(RelType.CLASSES_WITH_ANNOTATION, false, ClassType.ANNOTATION);
        if (annotationsWithThisMetaAnnotation.reachableClasses.isEmpty()) {
            return new ClassInfoList(classesWithDirectlyAnnotatedFields, true);
        }
        LinkedHashSet<ClassInfo> allClassesWithAnnotatedOrMetaAnnotatedFields = new LinkedHashSet<ClassInfo>(classesWithDirectlyAnnotatedFields.reachableClasses);
        for (ClassInfo metaAnnotatedAnnotation : annotationsWithThisMetaAnnotation.reachableClasses) {
            allClassesWithAnnotatedOrMetaAnnotatedFields.addAll(metaAnnotatedAnnotation.filterClassInfo((RelType)RelType.CLASSES_WITH_FIELD_ANNOTATION, (boolean)(!metaAnnotatedAnnotation.isExternalClass ? true : false), (ClassType[])new ClassType[0]).reachableClasses);
        }
        return new ClassInfoList(allClassesWithAnnotatedOrMetaAnnotatedFields, classesWithDirectlyAnnotatedFields.directlyRelatedClasses, true);
    }

    ClassInfoList getClassesWithFieldAnnotationDirectOnly() {
        return new ClassInfoList(this.filterClassInfo(RelType.CLASSES_WITH_FIELD_ANNOTATION, !this.isExternalClass, new ClassType[0]), true);
    }

    public ClassTypeSignature getTypeSignature() {
        if (this.typeSignatureStr == null) {
            return null;
        }
        if (this.typeSignature == null) {
            try {
                this.typeSignature = ClassTypeSignature.parse(this.typeSignatureStr, this);
                this.typeSignature.setScanResult(this.scanResult);
            }
            catch (Parser.ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.typeSignature;
    }

    public URL getClasspathElementURL() {
        if (this.classpathElementURL == null) {
            try {
                this.classpathElementURL = this.moduleRef != null ? this.moduleRef.getLocation().toURL() : (this.classpathElementFile.isFile() && !this.jarfilePackageRoot.isEmpty() ? URLPathEncoder.urlPathToURL(this.classpathElementFile.toURI().toURL().toString() + "!/" + this.jarfilePackageRoot) : this.classpathElementFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.classpathElementURL;
    }

    public File getClasspathElementFile() {
        return this.classpathElementFile;
    }

    public ModuleRef getModuleRef() {
        return this.moduleRef;
    }

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public <T> Class<T> loadClass(Class<T> superclassOrInterfaceType, boolean ignoreExceptions) {
        return super.loadClass(superclassOrInterfaceType, ignoreExceptions);
    }

    @Override
    public <T> Class<T> loadClass(Class<T> superclassOrInterfaceType) {
        return super.loadClass(superclassOrInterfaceType, false);
    }

    @Override
    public Class<?> loadClass(boolean ignoreExceptions) {
        return super.loadClass(ignoreExceptions);
    }

    @Override
    public Class<?> loadClass() {
        return super.loadClass(false);
    }

    @Override
    protected String getClassName() {
        return this.name;
    }

    @Override
    protected ClassInfo getClassInfo() {
        return this;
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.typeSignature != null) {
            this.typeSignature.setScanResult(scanResult);
        }
        if (this.annotationInfo != null) {
            for (AnnotationInfo ai : this.annotationInfo) {
                ai.setScanResult(scanResult);
            }
        }
        if (this.fieldInfo != null) {
            for (FieldInfo fi : this.fieldInfo) {
                fi.setScanResult(scanResult);
            }
        }
        if (this.methodInfo != null) {
            for (MethodInfo mi : this.methodInfo) {
                mi.setScanResult(scanResult);
            }
        }
        if (this.annotationDefaultParamValues != null) {
            for (AnnotationParameterValue apv : this.annotationDefaultParamValues) {
                apv.setScanResult(scanResult);
            }
        }
    }

    @Override
    protected void getReferencedClassNames(Set<String> classNames) {
        ClassTypeSignature classSig;
        LinkedHashSet<String> referencedClassNames = new LinkedHashSet<String>();
        if (this.methodInfo != null) {
            for (MethodInfo mi : this.methodInfo) {
                mi.getReferencedClassNames(classNames);
            }
        }
        if (this.fieldInfo != null) {
            for (FieldInfo fi : this.fieldInfo) {
                fi.getReferencedClassNames(classNames);
            }
        }
        if (this.annotationInfo != null) {
            for (AnnotationInfo ai : this.annotationInfo) {
                ai.getReferencedClassNames(referencedClassNames);
            }
        }
        if (this.annotationDefaultParamValues != null) {
            for (AnnotationParameterValue paramValue : this.annotationDefaultParamValues) {
                paramValue.getReferencedClassNames(referencedClassNames);
            }
        }
        if ((classSig = this.getTypeSignature()) != null) {
            classSig.getReferencedClassNames(referencedClassNames);
        }
    }

    @Override
    public int compareTo(ClassInfo o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassInfo other = (ClassInfo)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 33;
    }

    private String toString(boolean typeNameOnly) {
        ClassTypeSignature typeSig = this.getTypeSignature();
        if (typeSig != null) {
            return typeSig.toString(this.name, typeNameOnly, this.modifiers, this.isAnnotation, this.isInterface);
        }
        StringBuilder buf = new StringBuilder();
        if (typeNameOnly) {
            buf.append(this.name);
        } else {
            Set<ClassInfo> interfaces;
            ClassTypeSignature.modifiersToString(this.modifiers, buf);
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(this.isAnnotation ? "@interface " : (this.isInterface ? "interface " : ((this.modifiers & 0x4000) != 0 ? "enum " : "class ")));
            buf.append(this.name);
            ClassInfo superclass = this.getSuperclass();
            if (superclass != null && !superclass.getName().equals("java.lang.Object")) {
                buf.append(" extends ").append(superclass.toString(true));
            }
            if (!(interfaces = this.filterClassInfo((RelType)RelType.IMPLEMENTED_INTERFACES, (boolean)false, (ClassType[])new ClassType[0]).directlyRelatedClasses).isEmpty()) {
                buf.append(this.isInterface ? " extends " : " implements ");
                boolean first = true;
                for (ClassInfo iface : interfaces) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(iface.toString(true));
                }
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    static class ReachableAndDirectlyRelatedClasses {
        final Set<ClassInfo> reachableClasses;
        final Set<ClassInfo> directlyRelatedClasses;

        private ReachableAndDirectlyRelatedClasses(Set<ClassInfo> reachableClasses, Set<ClassInfo> directlyRelatedClasses) {
            this.reachableClasses = reachableClasses;
            this.directlyRelatedClasses = directlyRelatedClasses;
        }
    }

    private static enum ClassType {
        ALL,
        STANDARD_CLASS,
        IMPLEMENTED_INTERFACE,
        ANNOTATION,
        INTERFACE_OR_ANNOTATION;

    }

    private static enum RelType {
        SUPERCLASSES,
        SUBCLASSES,
        CONTAINS_INNER_CLASS,
        CONTAINED_WITHIN_OUTER_CLASS,
        IMPLEMENTED_INTERFACES,
        CLASSES_IMPLEMENTING,
        CLASS_ANNOTATIONS,
        CLASSES_WITH_ANNOTATION,
        METHOD_ANNOTATIONS,
        CLASSES_WITH_METHOD_ANNOTATION,
        FIELD_ANNOTATIONS,
        CLASSES_WITH_FIELD_ANNOTATION;

    }
}

