/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public abstract class BaseRestHandler
implements RestHandler {
    public static final Setting<Boolean> MULTI_ALLOW_EXPLICIT_INDEX = Setting.boolSetting("rest.action.multi.allow_explicit_index", true, Setting.Property.NodeScope);
    private final LongAdder usageCount = new LongAdder();
    @Deprecated
    protected Logger logger = LogManager.getLogger(this.getClass());
    public static final String INCLUDE_TYPE_NAME_PARAMETER = "include_type_name";
    public static final boolean DEFAULT_INCLUDE_TYPE_NAME_POLICY = false;

    public final long getUsageCount() {
        return this.usageCount.sum();
    }

    public abstract String getName();

    @Override
    public final void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        RestChannelConsumer action = this.prepareRequest(request, client);
        SortedSet unconsumedParams = request.unconsumedParams().stream().filter(p -> !this.responseParams().contains(p)).collect(Collectors.toCollection(TreeSet::new));
        if (!unconsumedParams.isEmpty()) {
            HashSet<String> candidateParams = new HashSet<String>();
            candidateParams.addAll(request.consumedParams());
            candidateParams.addAll(this.responseParams());
            throw new IllegalArgumentException(this.unrecognized(request, unconsumedParams, candidateParams, "parameter"));
        }
        if (request.hasContent() && !request.isContentConsumed()) {
            throw new IllegalArgumentException("request [" + (Object)((Object)request.method()) + " " + request.path() + "] does not support having a body");
        }
        this.usageCount.increment();
        action.accept(channel);
    }

    protected final String unrecognized(RestRequest request, Set<String> invalids, Set<String> candidates, String detail) {
        StringBuilder message = new StringBuilder(String.format(Locale.ROOT, "request [%s] contains unrecognized %s%s: ", request.path(), detail, invalids.size() > 1 ? "s" : ""));
        boolean first = true;
        for (String invalid : invalids) {
            LevenshteinDistance ld = new LevenshteinDistance();
            ArrayList<Tuple<Float, String>> scoredParams = new ArrayList<Tuple<Float, String>>();
            for (String candidate : candidates) {
                float distance = ld.getDistance(invalid, candidate);
                if (!(distance > 0.5f)) continue;
                scoredParams.add(new Tuple<Float, String>(Float.valueOf(distance), candidate));
            }
            CollectionUtil.timSort(scoredParams, (a, b) -> {
                int compare = ((Float)a.v1()).compareTo((Float)b.v1());
                if (compare != 0) {
                    return -compare;
                }
                return ((String)a.v2()).compareTo((String)b.v2());
            });
            if (!first) {
                message.append(", ");
            }
            message.append("[").append(invalid).append("]");
            List keys = scoredParams.stream().map(Tuple::v2).collect(Collectors.toList());
            if (!keys.isEmpty()) {
                message.append(" -> did you mean ");
                if (keys.size() == 1) {
                    message.append("[").append((String)keys.get(0)).append("]");
                } else {
                    message.append("any of ").append(keys.toString());
                }
                message.append("?");
            }
            first = false;
        }
        return message.toString();
    }

    protected abstract RestChannelConsumer prepareRequest(RestRequest var1, NodeClient var2) throws IOException;

    protected Set<String> responseParams() {
        return Collections.emptySet();
    }

    @FunctionalInterface
    protected static interface RestChannelConsumer
    extends CheckedConsumer<RestChannel, Exception> {
    }
}

