/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger.tool;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerManager;

public class Producer {
    protected Messenger messenger;

    public static void main(String[] args) {
        block4: {
            try {
                Producer client = new Producer();
                client.run(args);
            }
            catch (JMSException e) {
                System.out.println("Caught: " + (Object)((Object)e));
                Exception linked = e.getLinkedException();
                if (linked != null) {
                    System.out.println("Underlying exception: " + linked);
                    linked.printStackTrace();
                    break block4;
                }
                e.printStackTrace();
            }
            catch (Exception e) {
                System.out.println("Caught: " + e);
                e.printStackTrace();
            }
        }
    }

    public void run(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: Producer messengerName destination [fileName]");
            System.out.println("If no fileName is provided then the current input stream is used");
            return;
        }
        String name = args[0];
        String subject = args[1];
        this.messenger = MessengerManager.get(name);
        if (this.messenger == null) {
            throw new JMSException("No such messenger called: " + name);
        }
        Destination destination = this.messenger.getDestination(subject);
        if (destination == null) {
            throw new JMSException("Could not find destination: " + subject);
        }
        InputStreamReader reader = args.length > 2 ? new FileReader(args[2]) : new InputStreamReader(System.in);
        Message message = this.createMessage(reader);
        this.messenger.send(destination, message);
        this.messenger.close();
    }

    protected Message createMessage(Reader in) throws Exception {
        String text = this.readText(in);
        TextMessage message = this.messenger.createTextMessage(text);
        return message;
    }

    /*
     * WARNING - void declaration
     */
    protected String readText(Reader in) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(in);
        while ((line = reader.readLine()) != null) {
            void var4_4;
            buffer.append((String)var4_4);
            buffer.append('\n');
        }
        reader.close();
        return buffer.toString();
    }
}

