/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messenger.Messenger;

public class ConsumerThread
extends Thread {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messagelet$ConsumerThread == null ? (class$org$apache$commons$messagelet$ConsumerThread = ConsumerThread.class$("org.apache.commons.messagelet.ConsumerThread")) : class$org$apache$commons$messagelet$ConsumerThread));
    private MessageConsumer consumer;
    private Messenger messenger;
    private Destination destination;
    private String selector;
    private MessageListener listener;
    private boolean shouldStop;
    static /* synthetic */ Class class$org$apache$commons$messagelet$ConsumerThread;

    public ConsumerThread() {
        this.setName("Consumer" + this.getName());
    }

    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting consumer thread: " + this.getName()));
        }
        try {
            this.startConsumer();
        }
        catch (JMSException e) {
            log.error((Object)("Failed to start consumer thread: " + (Object)((Object)e)), (Throwable)e);
            this.setShouldStop(true);
        }
        while (!this.isShouldStop()) {
            try {
                this.startTransaction();
            }
            catch (Exception e) {
                log.error((Object)("Caught exception trying to start transaction. This thread will terminate. Reason: " + e), (Throwable)e);
                break;
            }
            try {
                Message message = this.receive();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Found: " + message));
                }
                if (message != null) {
                    this.processMessage(message);
                    this.commitTransaction();
                    continue;
                }
                this.cancelTransaction();
            }
            catch (Exception e) {
                this.rollbackTransaction(e);
            }
        }
        try {
            this.stopConsumer();
        }
        catch (JMSException e) {
            log.error((Object)("Failed to stop consuming messages: " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public Destination getDestination() {
        return this.destination;
    }

    public MessageListener getListener() {
        return this.listener;
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public String getSelector() {
        return this.selector;
    }

    public boolean isShouldStop() {
        return this.shouldStop;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setListener(MessageListener listener) {
        this.listener = listener;
    }

    public void setMessenger(Messenger messenger) {
        this.messenger = messenger;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void setShouldStop(boolean shouldStop) {
        this.shouldStop = shouldStop;
    }

    protected void startConsumer() throws JMSException {
        this.consumer = this.createConsumer();
    }

    protected void stopConsumer() throws JMSException {
        this.consumer.close();
    }

    protected MessageConsumer createConsumer() throws JMSException {
        String selector = this.getSelector();
        if (selector != null) {
            return this.getMessenger().createConsumer(this.getDestination(), selector);
        }
        return this.getMessenger().createConsumer(this.getDestination());
    }

    private Message receive() throws JMSException {
        return this.getConsumer().receive();
    }

    protected void processMessage(Message message) throws JMSException {
        MessageListener listener = this.getListener();
        if (listener != null) {
            listener.onMessage(message);
        }
    }

    protected void startTransaction() throws Exception {
    }

    protected void commitTransaction() throws Exception {
    }

    protected void rollbackTransaction(Exception e) {
    }

    protected void cancelTransaction() throws Exception {
    }

    protected MessageConsumer getConsumer() {
        return this.consumer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

