/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.odmg;

import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.odmg.OJB;
import org.odmg.Database;
import org.odmg.ODMGException;
import org.odmg.ObjectNameNotFoundException;
import org.odmg.ObjectNameNotUniqueException;
import org.odmg.Transaction;
import test.ojb.odmg.Article;

public class NamedRoots
extends TestCase {
    private static Class CLASS = class$test$ojb$odmg$NamedRoots == null ? (class$test$ojb$odmg$NamedRoots = NamedRoots.class$("test.ojb.odmg.NamedRoots")) : class$test$ojb$odmg$NamedRoots;
    private String databaseName;
    static /* synthetic */ Class class$test$ojb$odmg$NamedRoots;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public NamedRoots(String name) {
        super(name);
    }

    private void clearNRM() {
    }

    public void setUp() {
        this.databaseName = "repository.xml";
    }

    public void tearDown() {
        try {
            OJB.getInstance().currentTransaction().abort();
            OJB.getInstance().getDatabase(null).close();
            this.databaseName = null;
            this.clearNRM();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testBind() {
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        try {
            db.open(this.databaseName, 2);
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        this.clearNRM();
        Transaction tx = odmg.newTransaction();
        tx.begin();
        Article example = new Article();
        example.setArticleId(7);
        example.setArticleName("named roots article");
        String name = "wild thing";
        try {
            db.bind(example, name);
            Article value = (Article)db.lookup(name);
            tx.commit();
        }
        catch (ObjectNameNotFoundException ex) {
            tx.abort();
            Assert.fail((String)("name " + name + " should not be unknown"));
        }
        catch (ObjectNameNotUniqueException e) {
            tx.abort();
            Assert.fail((String)("should not have happened: " + e.getMessage()));
        }
        try {
            tx.begin();
            db.bind(example, name);
            tx.commit();
        }
        catch (ObjectNameNotUniqueException ex) {
            tx.abort();
            try {
                db.close();
            }
            catch (ODMGException e) {
                Assert.fail((String)("ODMGException: " + e.getMessage()));
            }
            return;
        }
        try {
            db.close();
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        Assert.fail((String)"should throw an ObjectNameNotUniqueException");
    }

    public void testLookup() {
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        try {
            db.open(this.databaseName, 2);
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        this.clearNRM();
        Transaction tx = odmg.newTransaction();
        tx.begin();
        Article example = new Article();
        example.setArticleId(7);
        example.setArticleName("named roots article");
        Identity oid = new Identity(example);
        String name = "wild thing 12";
        try {
            db.bind(example, name);
            tx.commit();
        }
        catch (ObjectNameNotUniqueException ex) {
            tx.abort();
            Assert.fail((String)ex.getMessage());
        }
        Article lookedUp1 = null;
        Object lookedUp2 = null;
        tx = odmg.newTransaction();
        tx.begin();
        try {
            lookedUp1 = (Article)db.lookup(name);
        }
        catch (ObjectNameNotFoundException ex) {
            Assert.fail((String)("lookup by name: " + name + " should not be unknown"));
        }
        tx.commit();
        Assert.assertEquals((String)"lookups should return identical object", (Object)example, (Object)lookedUp1);
        try {
            db.close();
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
    }

    public void testUnBind() {
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        try {
            db.open(this.databaseName, 2);
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        this.clearNRM();
        Transaction tx = odmg.newTransaction();
        tx.begin();
        String name = "wild thing 777";
        Article example = new Article();
        example.setArticleId(7);
        example.setArticleName("named roots article");
        try {
            db.bind(example, name);
            tx.commit();
        }
        catch (ObjectNameNotUniqueException ex) {
            tx.abort();
            Assert.fail((String)ex.getMessage());
        }
        tx = odmg.newTransaction();
        tx.begin();
        try {
            db.unbind(name);
            tx.commit();
        }
        catch (ObjectNameNotFoundException ex) {
            tx.abort();
            Assert.fail((String)("name " + name + "should be known"));
        }
        tx = odmg.newTransaction();
        tx.begin();
        try {
            Article value = (Article)db.lookup(name);
        }
        catch (ObjectNameNotFoundException ex) {
            tx.commit();
            try {
                db.close();
            }
            catch (ODMGException e) {
                Assert.fail((String)("ODMGException: " + e.getMessage()));
            }
            return;
        }
        tx.abort();
        Assert.fail((String)("name " + name + " should not be known after unbind"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

