/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.query;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ojb.broker.query.DBException;

public abstract class SearchFilter {
    public static final int AND = 512;
    public static final int OR = 513;
    public static final int NOT = 2;
    public static final int IN = 3;
    public static final int NOT_IN = 4;
    public static final int LIKE = 265;
    public static final int EQUAL = 266;
    public static final int NOT_EQUAL = 267;
    public static final int LESS_THAN = 268;
    public static final int GREATER_THAN = 269;
    public static final int GREATER_EQUAL = 270;
    public static final int LESS_EQUAL = 271;
    protected static final int BINARY_OPER_MASK = 256;
    protected static final int LOGICAL_OPER_MASK = 512;
    protected SearchBase filter = null;

    public void matchList(String ElementName, Vector values, int oper) {
        this.filter = null;
        if (oper != 4) {
            oper = 3;
        }
        Object[] value_string_array = new String[values.size()];
        values.copyInto(value_string_array);
        this.filter = new SearchBaseLeaf(ElementName, oper, (String[])value_string_array);
    }

    public void matchList(String ElementName, String[] values, int oper) {
        this.filter = null;
        if (oper != 4) {
            oper = 3;
        }
        this.filter = new SearchBaseLeaf(ElementName, oper, values);
    }

    public void matchList(String ElementName, int[] values, int oper) {
        this.filter = null;
        if (oper != 4) {
            oper = 3;
        }
        this.filter = new SearchBaseLeafInt(ElementName, oper, values);
    }

    public void matchValue(String ElementName, String value, int oper) {
        this.filter = null;
        if (oper != 4) {
            oper = 3;
        }
        String[] ValueArray = new String[]{value};
        this.filter = new SearchBaseLeaf(ElementName, oper, ValueArray);
    }

    public void matchValue(String ElementName, int value, int oper) {
        this.filter = null;
        if (oper != 4) {
            oper = 3;
        }
        this.filter = new SearchBaseLeafInt(ElementName, oper, new int[]{value});
    }

    public void compareFilter(String ElementName, String value, int oper) throws DBException {
        this.filter = null;
        if ((oper & 0x100) == 0) {
            throw new DBException();
        }
        this.filter = new SearchBaseLeafComparison(ElementName, oper, value);
    }

    public void matchSet(Hashtable elements, int combine_op, int compare_op) throws DBException {
        this.filter = null;
        if ((combine_op & 0x200) == 0) {
            throw new DBException();
        }
        if ((compare_op & 0x100) == 0) {
            throw new DBException();
        }
        Vector<SearchBaseLeafComparison> compareVector = new Vector<SearchBaseLeafComparison>();
        Enumeration e = elements.keys();
        while (e.hasMoreElements()) {
            String elementName = (String)e.nextElement();
            String elementValue = (String)elements.get(elementName);
            SearchBaseLeafComparison comparenode = new SearchBaseLeafComparison(elementName, compare_op, elementValue);
            compareVector.addElement(comparenode);
        }
        this.filter = new SearchBaseNode(combine_op, compareVector);
    }

    public void matchSet(String[] ElementNames, String[] ElementValues, int op) throws DBException {
        this.filter = null;
        if ((op & 0x200) == 0) {
            throw new DBException();
        }
        Vector<SearchBaseLeaf> leafVector = new Vector<SearchBaseLeaf>();
        int numnames = ElementNames.length;
        int i = 0;
        while (i < numnames) {
            SearchBaseLeaf leafnode = new SearchBaseLeaf(ElementNames[i], 3, ElementValues[i]);
            leafVector.addElement(leafnode);
            ++i;
        }
        this.filter = new SearchBaseNode(op, leafVector);
    }

    public void combine(Vector new_filters, int op) throws DBException {
        if ((op & 0x200) == 0) {
            throw new DBException();
        }
        Vector<SearchBase> filters = new Vector<SearchBase>();
        Enumeration e = new_filters.elements();
        while (e.hasMoreElements()) {
            SearchFilter f = (SearchFilter)e.nextElement();
            filters.addElement(f.getFilter());
        }
        this.filter = new SearchBaseNode(op, this.filter, filters);
    }

    public void combine(SearchFilter new_filter, int op) throws DBException {
        if ((op & 0x200) == 0) {
            throw new DBException();
        }
        Vector<SearchBase> filters = new Vector<SearchBase>();
        filters.addElement(new_filter.getFilter());
        this.filter = new SearchBaseNode(op, this.filter, filters);
    }

    protected static String ConvertBinaryOperator(int oper) {
        String oper_string;
        switch (oper) {
            default: {
                oper_string = "=";
                break;
            }
            case 265: {
                oper_string = "LIKE";
                break;
            }
            case 267: {
                oper_string = "!=";
                break;
            }
            case 268: {
                oper_string = "<";
                break;
            }
            case 269: {
                oper_string = ">";
                break;
            }
            case 270: {
                oper_string = ">=";
                break;
            }
            case 271: {
                oper_string = "<=";
            }
        }
        return oper_string;
    }

    protected SearchBase getFilter() {
        return this.filter;
    }

    public abstract String toString();

    protected class SearchBaseNode
    extends SearchBase {
        public Vector nodes;

        SearchBaseNode(int oper, Vector new_filters) {
            this.oper = oper;
            this.nodes = new_filters;
        }

        SearchBaseNode(int oper, Object filter, Vector new_filters) {
            this.oper = oper;
            this.nodes = new Vector();
            if (filter != null) {
                this.nodes.addElement(filter);
            }
            Enumeration e = new_filters.elements();
            while (e.hasMoreElements()) {
                this.nodes.addElement(e.nextElement());
            }
        }
    }

    protected class SearchBaseLeafInt
    extends SearchBase {
        public String elementName;
        public int[] matches;

        SearchBaseLeafInt(String ElementName, int oper, int[] matches) {
            this.elementName = ElementName;
            this.oper = oper;
            this.matches = matches;
        }

        SearchBaseLeafInt(String ElementName, int oper, int match) {
            this.elementName = ElementName;
            this.oper = oper;
            this.matches = new int[1];
            this.matches[0] = match;
        }
    }

    protected class SearchBaseLeaf
    extends SearchBase {
        public String elementName;
        public String[] matches;

        SearchBaseLeaf(String ElementName, int oper, String[] matches) {
            this.elementName = ElementName;
            this.oper = oper;
            this.matches = matches;
        }

        SearchBaseLeaf(String ElementName, int oper, String match) {
            this.elementName = ElementName;
            this.oper = oper;
            this.matches = new String[1];
            this.matches[0] = match;
        }
    }

    protected class SearchBaseLeafComparison
    extends SearchBase {
        public String elementName;
        public String value;

        SearchBaseLeafComparison(String ElementName, int oper, String value) {
            this.elementName = ElementName;
            this.oper = oper;
            this.value = value;
        }
    }

    protected class SearchBase {
        public int oper;

        protected SearchBase() {
        }
    }
}

