/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ojb.broker.Identity;
import ojb.broker.accesslayer.SqlGenerator;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.query.Query;
import ojb.broker.singlevm.PersistenceBrokerImpl;

public class JdbcAccess {
    private static boolean _debug = false;
    private PersistenceBrokerImpl broker;

    public static void setDebug(boolean b) {
        _debug = b;
    }

    public JdbcAccess(PersistenceBrokerImpl broker) {
        this.broker = broker;
    }

    public boolean executeDelete(ClassDescriptor mif, Identity oid) {
        if (_debug) {
            System.out.println("executeDelete: " + oid);
        }
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.broker.getStatementManager().getDeleteStatement(mif);
            synchronized (preparedStatement) {
                this.broker.getStatementManager().bindDelete(stmt, oid);
                stmt.executeUpdate();
            }
            stmt = null;
            return true;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public boolean executeInsert(ClassDescriptor mif, Object obj) {
        if (_debug) {
            System.out.println("executeInsert: " + obj);
        }
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.broker.getStatementManager().getInsertStatement(mif);
            synchronized (preparedStatement) {
                this.broker.getStatementManager().bindInsert(stmt, mif, obj);
                stmt.executeUpdate();
            }
            stmt = null;
            return true;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    ResultSet executeQuery(Query query, ClassDescriptor mif) {
        if (_debug) {
            System.out.println("executeQuery: " + query);
        }
        try {
            if (query.getCriteria() != null && !query.getCriteria().isEmpty()) {
                String sql = SqlGenerator.getInstance().getPreparedSelectStatement(query, mif);
                PreparedStatement stmt = this.broker.getStatementManager().getPreparedStatement(mif, sql);
                this.broker.getStatementManager().bindStatement(stmt, query.getCriteria(), mif, 1);
                ResultSet rs = stmt.executeQuery();
                return rs;
            }
            Statement stmt = this.broker.getStatementManager().getGenericStatement(mif);
            String sql = SqlGenerator.getInstance().getSelectStatementDep(query, mif);
            ResultSet rs = stmt.executeQuery(sql);
            return rs;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    public boolean executeUpdate(ClassDescriptor mif, Object obj) {
        if (_debug) {
            System.out.println("executeUpdate: " + obj);
        }
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.broker.getStatementManager().getUpdateStatement(mif);
            synchronized (preparedStatement) {
                this.broker.getStatementManager().bindUpdate(stmt, mif, obj);
                stmt.executeUpdate();
            }
            stmt = null;
            return true;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public Object materializeObject(ClassDescriptor mif, Identity oid) {
        ResultSet rs;
        Object obj = null;
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.broker.getStatementManager().getSelectByPKStatement(mif);
            synchronized (preparedStatement) {
                this.broker.getStatementManager().bindSelect(stmt, oid);
                rs = stmt.executeQuery();
                obj = rs.next() ? this.readObjectFromResultSet(rs, mif) : null;
                rs.close();
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        rs = null;
        return obj;
    }

    /*
     * Unable to fully structure code
     */
    private Object readObjectFromResultSet(ResultSet rs, ClassDescriptor mif) {
        val = null;
        fmd = null;
        multiArgsConstructor = mif.getConstructor();
        conversion = mif.getConversionStrategy();
        args = null;
        try {
            if (multiArgsConstructor != null) {
                fields = mif.getFieldDescriptions();
                args = new Object[fields.length];
                i = 0;
                while (i < fields.length) {
                    fmd = fields[i];
                    val = JdbcAccess.getObjectFromColumn(rs, fmd);
                    args[i] = conversion.sqlToJava(val, fmd);
                    ++i;
                }
                return multiArgsConstructor.newInstance(args);
            }
            c = mif.getClassOfObject();
            obj = c.newInstance();
            fields = mif.getFieldDescriptions();
            i = 0;
            while (i < fields.length) {
                fmd = fields[i];
                val = JdbcAccess.getObjectFromColumn(rs, fmd);
                if (val != null || !fmd.getPersistentField().getDeclaringClass().isPrimitive()) {
                    fmd.getPersistentField().set(obj, conversion.sqlToJava(val, fmd));
                }
                ++i;
            }
            return obj;
        }
        catch (Exception ex) {
            System.out.println("class: " + mif.getClassOfObject().getName());
            System.out.println("args: ");
            x = 0;
            ** while (x < args.length)
        }
lbl-1000:
        // 1 sources

        {
            System.out.println(args[x] + ",");
            ++x;
            continue;
        }
lbl38:
        // 1 sources

        System.out.println(ex.getMessage());
        ex.printStackTrace();
        return null;
    }

    static Object getObjectFromColumn(ResultSet rs, FieldDescriptor fld) throws SQLException {
        Object result = null;
        switch (JdbcAccess.getJdbcType(fld)) {
            case -7: {
                result = new Boolean(rs.getBoolean(fld.getColumnName()));
                break;
            }
            case -6: {
                result = new Byte(rs.getByte(fld.getColumnName()));
                break;
            }
            case 5: {
                result = new Short(rs.getShort(fld.getColumnName()));
                break;
            }
            case 4: {
                result = new Integer(rs.getInt(fld.getColumnName()));
                break;
            }
            case -5: {
                result = new Long(rs.getLong(fld.getColumnName()));
                break;
            }
            case 6: {
                result = new Double(rs.getDouble(fld.getColumnName()));
                break;
            }
            case 7: {
                result = new Float(rs.getFloat(fld.getColumnName()));
                break;
            }
            case 8: {
                result = new Double(rs.getDouble(fld.getColumnName()));
                break;
            }
            case 2: {
                result = rs.getBigDecimal(fld.getColumnName());
                break;
            }
            case 3: {
                result = rs.getBigDecimal(fld.getColumnName());
                break;
            }
            case 1: {
                result = rs.getString(fld.getColumnName());
                break;
            }
            case 12: {
                result = rs.getString(fld.getColumnName());
                break;
            }
            case -1: {
                result = rs.getString(fld.getColumnName());
                break;
            }
            case 91: {
                result = rs.getDate(fld.getColumnName());
                break;
            }
            case 92: {
                result = rs.getTime(fld.getColumnName());
                break;
            }
            case 93: {
                result = rs.getTimestamp(fld.getColumnName());
                break;
            }
            case -2: {
                result = rs.getBytes(fld.getColumnName());
                break;
            }
            case -3: {
                result = rs.getBytes(fld.getColumnName());
                break;
            }
            case -4: {
                result = rs.getBytes(fld.getColumnName());
                break;
            }
            default: {
                throw new RuntimeException("The type " + fld.getColumnType() + " for attribute " + fld.getColumnName() + " can not be handled by OJB. Please specify only types as defined by java.sql.Types.");
            }
        }
        return result;
    }

    private static int getJdbcType(FieldDescriptor fld) {
        int result;
        String type = fld.getColumnType().toLowerCase();
        if (type.equals("bit")) {
            result = -7;
        } else if (type.equals("tinyint")) {
            result = -6;
        } else if (type.equals("smallint")) {
            result = 5;
        } else if (type.equals("integer")) {
            result = 4;
        } else if (type.equals("bigint")) {
            result = -5;
        } else if (type.equals("float")) {
            result = 6;
        } else if (type.equals("real")) {
            result = 7;
        } else if (type.equals("double")) {
            result = 8;
        } else if (type.equals("numeric")) {
            result = 2;
        } else if (type.equals("decimal")) {
            result = 3;
        } else if (type.equals("char")) {
            result = 1;
        } else if (type.equals("varchar")) {
            result = 12;
        } else if (type.equals("longvarchar")) {
            result = -1;
        } else if (type.equals("date")) {
            result = 91;
        } else if (type.equals("time")) {
            result = 92;
        } else if (type.equals("timestamp")) {
            result = 93;
        } else if (type.equals("binary")) {
            result = -2;
        } else if (type.equals("varbinary")) {
            result = -3;
        } else if (type.equals("longvarbinary")) {
            result = -4;
        } else {
            throw new RuntimeException("The type " + fld.getColumnType() + " for attribute " + fld.getColumnName() + " can not be handled by OJB. Please specify only types as defined by java.sql.Types.");
        }
        return result;
    }

    static int getSqlTypeAll(ClassDescriptor cld, int index) {
        FieldDescriptor fld = cld.getFieldDescriptions()[index];
        return JdbcAccess.getJdbcType(fld);
    }

    static int getSqlTypeNonPk(ClassDescriptor cld, int index) {
        FieldDescriptor fld = cld.getNonPkFields()[index];
        return JdbcAccess.getJdbcType(fld);
    }

    static int getSqlTypePk(ClassDescriptor cld, int index) {
        FieldDescriptor fld = cld.getPkFields()[index];
        return JdbcAccess.getJdbcType(fld);
    }
}

