/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.accesslayer.ConnectionFactoryFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.JdbcConnectionDescriptor;
import ojb.broker.singlevm.PersistenceBrokerImpl;

public class ConnectionManager {
    private PersistenceBrokerImpl broker = null;
    private Hashtable connectionTable;

    public ConnectionManager(PersistenceBrokerImpl broker) {
        this.broker = broker;
        this.connectionTable = new Hashtable();
    }

    public Enumeration enumeration() {
        return this.connectionTable.elements();
    }

    public Connection getConnectionForClassDescriptor(ClassDescriptor cld) throws PersistenceBrokerException {
        JdbcConnectionDescriptor jcd = cld.getConnectionDescriptor();
        Connection conn = (Connection)this.connectionTable.get(jcd);
        if (conn != null && !this.isAlive(conn)) {
            this.connectionTable.remove(jcd);
            conn = null;
        }
        if (conn == null) {
            conn = this.getNewConnection(jcd);
            this.connectionTable.put(jcd, conn);
        }
        return conn;
    }

    private Connection getNewConnection(JdbcConnectionDescriptor jcd) throws PersistenceBrokerException {
        return ConnectionFactoryFactory.getConnectionFactory().newConnection(jcd, this.broker);
    }

    private boolean isAlive(Connection conn) {
        boolean result = false;
        try {
            if (!conn.isClosed()) {
                result = true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return result;
    }
}

