/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.utils.ConnectionProvider;

public class JNDIConnectionProvider
implements ConnectionProvider {
    private String url;
    private Properties props;
    private Object datasource;
    private boolean alwaysLookup = false;

    public JNDIConnectionProvider(String jndiUrl, boolean alwaysLookup) {
        this.url = jndiUrl;
        this.alwaysLookup = alwaysLookup;
        this.init();
    }

    public JNDIConnectionProvider(String jndiUrl, Properties jndiProps, boolean alwaysLookup) {
        this.url = jndiUrl;
        this.props = jndiProps;
        this.alwaysLookup = alwaysLookup;
        this.init();
    }

    Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    private void init() {
        if (!this.isAlwaysLookup()) {
            try {
                InitialContext ctx = null;
                ctx = this.props != null ? new InitialContext(this.props) : new InitialContext();
                this.datasource = (DataSource)ctx.lookup(this.url);
            }
            catch (Exception e) {
                this.getLog().error((Object)("Error looking up datasource: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            Object ds = this.datasource;
            if (ds == null || this.isAlwaysLookup()) {
                InitialContext ctx = null;
                ctx = this.props != null ? new InitialContext(this.props) : new InitialContext();
                ds = ctx.lookup(this.url);
                if (!this.isAlwaysLookup()) {
                    this.datasource = ds;
                }
            }
            if (ds == null) {
                throw new SQLException("There is no object at the JNDI URL '" + this.url + "'");
            }
            if (ds instanceof XADataSource) {
                return ((XADataSource)ds).getXAConnection().getConnection();
            }
            if (ds instanceof DataSource) {
                return ((DataSource)ds).getConnection();
            }
            throw new SQLException("Object at JNDI URL '" + this.url + "' is not a DataSource.");
        }
        catch (Exception e) {
            this.datasource = null;
            throw new SQLException("Could not retrieve datasource via JNDI url '" + this.url + "' " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public boolean isAlwaysLookup() {
        return this.alwaysLookup;
    }

    public void setAlwaysLookup(boolean b) {
        this.alwaysLookup = b;
    }

    public void shutdown() throws SQLException {
    }
}

