/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore.oracle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.sql.BLOB;
import org.apache.commons.logging.Log;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;

public class OracleDelegate
extends StdJDBCDelegate {
    public static final String INSERT_ORACLE_JOB_DETAIL = "INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY)  VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String UPDATE_ORACLE_JOB_DETAIL = "UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String UPDATE_ORACLE_JOB_DETAIL_BLOB = "UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String UPDATE_ORACLE_JOB_DETAIL_EMPTY_BLOB = "UPDATE {0}JOB_DETAILS SET JOB_DATA = EMPTY_BLOB()  WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String SELECT_ORACLE_JOB_DETAIL_BLOB = "SELECT JOB_DATA FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ? FOR UPDATE";
    public static final String INSERT_ORACLE_CALENDAR = "INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, EMPTY_BLOB())";
    public static final String SELECT_ORACLE_CALENDAR_BLOB = "SELECT CALENDAR FROM {0}CALENDARS WHERE CALENDAR_NAME = ? FOR UPDATE";
    public static final String UPDATE_ORACLE_CALENDAR_BLOB = "UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?";

    public OracleDelegate(Log logger, String tablePrefix, String instanceId) {
        super(logger, tablePrefix, instanceId);
    }

    public OracleDelegate(Log logger, String tablePrefix, String instanceId, Boolean useProperties) {
        super(logger, tablePrefix, instanceId, useProperties);
    }

    protected Object getObjectFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        Object obj = null;
        InputStream binaryInput = rs.getBinaryStream(colName);
        if (binaryInput != null) {
            ObjectInputStream in = new ObjectInputStream(binaryInput);
            obj = in.readObject();
            in.close();
        }
        return obj;
    }

    /*
     * Unable to fully structure code
     */
    public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        block14: {
            baos = this.serializeJobData(job.getJobDataMap());
            data = baos.toByteArray();
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            ps.setString(3, job.getDescription());
            ps.setString(4, job.getJobClass().getName());
            ps.setBoolean(5, job.isDurable());
            ps.setBoolean(6, job.isVolatile());
            ps.setBoolean(7, job.isStateful());
            ps.setBoolean(8, job.requestsRecovery());
            ps.setBinaryStream(9, (InputStream)null, 0);
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = EMPTY_BLOB()  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement(this.rtp("SELECT JOB_DATA FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ? FOR UPDATE"));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            rs = ps.executeQuery();
            res = 0;
            dbBlob = null;
            if (rs.next()) break block16;
            var9_9 = res;
            var12_12 = null;
            if (null == rs) break block14;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl-1000
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block16: {
                return var9_9;
            }
            dbBlob = this.writeDataToBlob(rs, 1, data);
            rs.close();
            ps.close();
            ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setBlob(1, dbBlob);
            ps.setString(2, job.getName());
            ps.setString(3, job.getGroup());
            res = ps.executeUpdate();
            if (res > 0) {
                jobListeners = job.getJobListenerNames();
                i = 0;
                while (jobListeners != null && i < jobListeners.length) {
                    this.insertJobListener(conn, job, jobListeners[i]);
                    ++i;
                }
            }
            var9_11 = res;
        }
        var12_13 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl82
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl82:
        // 3 sources

        return var9_11;
        catch (Throwable var11_19) {
            block17: {
                var12_14 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps) break block17;
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
            throw var11_19;
        }
    }

    protected Object getJobDetailFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            InputStream binaryInput = rs.getBinaryStream(colName);
            return binaryInput;
        }
        return this.getObjectFromBlob(rs, colName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        SQLException ignore22;
        int n;
        Statement ps2;
        PreparedStatement ps;
        block17: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            byte[] data = baos.toByteArray();
            ps = null;
            ps2 = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp(UPDATE_ORACLE_JOB_DETAIL));
                ps.setString(1, job.getDescription());
                ps.setString(2, job.getJobClass().getName());
                ps.setBoolean(3, job.isDurable());
                ps.setBoolean(4, job.isVolatile());
                ps.setBoolean(5, job.isStateful());
                ps.setBoolean(6, job.requestsRecovery());
                ps.setString(7, job.getName());
                ps.setString(8, job.getGroup());
                ps.executeUpdate();
                ps.close();
                ps = conn.prepareStatement(this.rtp(UPDATE_ORACLE_JOB_DETAIL_EMPTY_BLOB));
                ps.setString(1, job.getName());
                ps.setString(2, job.getGroup());
                ps.executeUpdate();
                ps.close();
                ps = conn.prepareStatement(this.rtp(SELECT_ORACLE_JOB_DETAIL_BLOB));
                ps.setString(1, job.getName());
                ps.setString(2, job.getGroup());
                rs = ps.executeQuery();
                int res = 0;
                if (rs.next()) {
                    Blob dbBlob = this.writeDataToBlob(rs, 1, data);
                    ps2 = conn.prepareStatement(this.rtp(UPDATE_ORACLE_JOB_DETAIL_BLOB));
                    ps2.setBlob(1, dbBlob);
                    ps2.setString(2, job.getName());
                    ps2.setString(3, job.getGroup());
                    res = ps2.executeUpdate();
                }
                if (res > 0) {
                    this.deleteJobListeners(conn, job.getName(), job.getGroup());
                    String[] jobListeners = job.getJobListenerNames();
                    int i = 0;
                    while (jobListeners != null && i < jobListeners.length) {
                        this.insertJobListener(conn, job, jobListeners[i]);
                        ++i;
                    }
                }
                n = res;
                Object var12_12 = null;
                if (null == rs) break block17;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var12_13 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null != ps) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps2) throw throwable;
                try {
                    ps2.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps2) return n;
        try {
            ps2.close();
            return n;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        block19: {
            baos = this.serializeObject(calendar);
            ps = null;
            ps2 = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, EMPTY_BLOB())"));
            ps.setString(1, calendarName);
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement(this.rtp("SELECT CALENDAR FROM {0}CALENDARS WHERE CALENDAR_NAME = ? FOR UPDATE"));
            ps.setString(1, calendarName);
            rs = ps.executeQuery();
            if (!rs.next()) break block23;
            dbBlob = this.writeDataToBlob(rs, 1, baos.toByteArray());
            ps2 = conn.prepareStatement(this.rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?"));
            ps2.setBlob(1, dbBlob);
            ps2.setString(2, calendarName);
            var9_10 = ps2.executeUpdate();
            var11_11 = null;
            if (null == rs) break block19;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps2) ** GOTO lbl-1000
        try {
            ps2.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block23: {
                return var9_10;
            }
            var8_9 = 0;
        }
        var11_12 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps2) ** GOTO lbl67
        try {
            ps2.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl67:
        // 3 sources

        return var8_9;
        catch (Throwable var10_17) {
            block24: {
                var11_13 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null != ps) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps2) break block24;
                try {
                    ps2.close();
                }
                catch (SQLException ignore) {}
            }
            throw var10_17;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        block19: {
            baos = this.serializeObject(calendar);
            ps = null;
            ps2 = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("SELECT CALENDAR FROM {0}CALENDARS WHERE CALENDAR_NAME = ? FOR UPDATE"));
            ps.setString(1, calendarName);
            rs = ps.executeQuery();
            if (!rs.next()) break block23;
            dbBlob = this.writeDataToBlob(rs, 1, baos.toByteArray());
            ps2 = conn.prepareStatement(this.rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?"));
            ps2.setBlob(1, dbBlob);
            ps2.setString(2, calendarName);
            var9_10 = ps2.executeUpdate();
            var11_11 = null;
            if (null == rs) break block19;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps2) ** GOTO lbl-1000
        try {
            ps2.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block23: {
                return var9_10;
            }
            var8_9 = 0;
        }
        var11_12 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps2) ** GOTO lbl62
        try {
            ps2.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl62:
        // 3 sources

        return var8_9;
        catch (Throwable var10_17) {
            block24: {
                var11_13 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null != ps) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps2) break block24;
                try {
                    ps2.close();
                }
                catch (SQLException ignore) {}
            }
            throw var10_17;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
        SQLException ignore22;
        int n;
        Statement ps2;
        PreparedStatement ps;
        block15: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            byte[] data = baos.toByteArray();
            ps = null;
            ps2 = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp(SELECT_ORACLE_JOB_DETAIL_BLOB));
                ps.setString(1, job.getName());
                ps.setString(2, job.getGroup());
                rs = ps.executeQuery();
                int res = 0;
                if (rs.next()) {
                    Blob dbBlob = this.writeDataToBlob(rs, 1, data);
                    ps2 = conn.prepareStatement(this.rtp(UPDATE_ORACLE_JOB_DETAIL_BLOB));
                    ps2.setBlob(1, dbBlob);
                    ps2.setString(2, job.getName());
                    ps2.setString(3, job.getGroup());
                    res = ps2.executeUpdate();
                }
                n = res;
                Object var11_11 = null;
                if (null == rs) break block15;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var11_12 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null != ps) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps2) throw throwable;
                try {
                    ps2.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps2) return n;
        try {
            ps2.close();
            return n;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return n;
    }

    protected Blob writeDataToBlob(ResultSet rs, int column, byte[] data) throws SQLException {
        Blob blob = rs.getBlob(column);
        if (blob == null) {
            throw new SQLException("Driver's Blob representation is null!");
        }
        if (blob instanceof BLOB) {
            ((BLOB)blob).putBytes(1L, data);
            return blob;
        }
        throw new SQLException("Driver's Blob representation is of an unsupported type: " + blob.getClass().getName());
    }
}

