/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;

public class OutboundNamedXAResourceFactory
implements NamedXAResourceFactory {
    private final String name;
    private final ConnectionInterceptor recoveryStack;
    private final ManagedConnectionFactory managedConnectionFactory;

    public OutboundNamedXAResourceFactory(String name, ConnectionInterceptor recoveryStack, ManagedConnectionFactory managedConnectionFactory) {
        this.name = name;
        this.recoveryStack = recoveryStack;
        this.managedConnectionFactory = managedConnectionFactory;
    }

    public String getName() {
        return this.name;
    }

    public NamedXAResource getNamedXAResource() throws SystemException {
        try {
            ManagedConnectionInfo mci = new ManagedConnectionInfo(this.managedConnectionFactory, null);
            ConnectionInfo recoveryConnectionInfo = new ConnectionInfo(mci);
            this.recoveryStack.getConnection(recoveryConnectionInfo);
            return new NamedXAResourceWithConnectioninfo((NamedXAResource)recoveryConnectionInfo.getManagedConnectionInfo().getXAResource(), recoveryConnectionInfo);
        }
        catch (ResourceException e) {
            throw (SystemException)new SystemException("Could not get XAResource for recovery for mcf: " + this.name).initCause((Throwable)e);
        }
    }

    public void returnNamedXAResource(NamedXAResource namedXAResource) {
        NamedXAResourceWithConnectioninfo xares = (NamedXAResourceWithConnectioninfo)namedXAResource;
        this.recoveryStack.returnConnection(xares.getConnectionInfo(), ConnectionReturnAction.DESTROY);
    }

    private static class NamedXAResourceWithConnectioninfo
    implements NamedXAResource {
        private final NamedXAResource delegate;
        private final ConnectionInfo connectionInfo;

        private NamedXAResourceWithConnectioninfo(NamedXAResource delegate, ConnectionInfo connectionInfo) {
            this.delegate = delegate;
            this.connectionInfo = connectionInfo;
        }

        public ConnectionInfo getConnectionInfo() {
            return this.connectionInfo;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public void commit(Xid xid, boolean b) throws XAException {
            this.delegate.commit(xid, b);
        }

        public void end(Xid xid, int i) throws XAException {
            this.delegate.end(xid, i);
        }

        public void forget(Xid xid) throws XAException {
            this.delegate.forget(xid);
        }

        public int getTransactionTimeout() throws XAException {
            return this.delegate.getTransactionTimeout();
        }

        public boolean isSameRM(XAResource xaResource) throws XAException {
            return this.delegate.isSameRM(xaResource);
        }

        public int prepare(Xid xid) throws XAException {
            return this.delegate.prepare(xid);
        }

        public Xid[] recover(int i) throws XAException {
            return this.delegate.recover(i);
        }

        public void rollback(Xid xid) throws XAException {
            this.delegate.rollback(xid);
        }

        public boolean setTransactionTimeout(int i) throws XAException {
            return this.delegate.setTransactionTimeout(i);
        }

        public void start(Xid xid, int i) throws XAException {
            this.delegate.start(xid, i);
        }
    }
}

