/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.RIConstants;
import com.sun.faces.util.Util;
import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindow;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class UrlBuilder {
    public static final String QUERY_STRING_SEPARATOR = "?";
    public static final String PARAMETER_PAIR_SEPARATOR = "&";
    public static final String PARAMETER_NAME_VALUE_SEPARATOR = "=";
    public static final String FRAGMENT_SEPARATOR = "#";
    private static final List<String> NULL_LIST = Arrays.asList(new String[]{null});
    private StringBuilder url;
    private String path;
    private String queryString;
    private String fragment;
    private Map<String, List<String>> parameters;
    private String encoding;

    public UrlBuilder(String url, String encoding) {
        if (url == null || url.trim().length() == 0) {
            throw new IllegalArgumentException("Url cannot be empty");
        }
        this.url = new StringBuilder(url.length() * 2);
        this.extractSegments(url);
        this.encoding = encoding;
    }

    public UrlBuilder(String url) {
        this(url, RIConstants.CHAR_ENCODING);
    }

    public UrlBuilder addParameters(String name, List<String> values) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter name cannot be empty");
        }
        this.addValuesToParameter(name.trim(), values, true);
        return this;
    }

    public UrlBuilder addParameters(Map<String, List<String>> params) {
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                if (entry.getKey() == null || entry.getKey().trim().length() == 0) {
                    throw new IllegalArgumentException("Parameter name cannot be empty");
                }
                List<String> values = entry.getValue();
                List<String> retValues = values.stream().filter(Objects::nonNull).collect(Collectors.toList());
                this.addValuesToParameter(entry.getKey().trim(), retValues, true);
            }
        }
        return this;
    }

    public UrlBuilder setPath(String path) {
        if (path == null || path.trim().length() == 0) {
            throw new IllegalArgumentException("Path cannot be empty");
        }
        this.path = path;
        return this;
    }

    public UrlBuilder setQueryString(String queryString) {
        this.queryString = queryString;
        this.cleanQueryString();
        return this;
    }

    public UrlBuilder setFragment(String fragment) {
        this.fragment = fragment;
        this.cleanFragment();
        return this;
    }

    public String createUrl() {
        this.appendPath();
        this.appendQueryString();
        this.appendFragment();
        return this.url.toString();
    }

    protected String getPath() {
        return this.path;
    }

    protected Map<String, List<String>> getParameters() {
        this.parseQueryString();
        return this.parameters;
    }

    protected void parseQueryString() {
        String[] pairs;
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, List<String>>();
        }
        if (this.queryString == null) {
            return;
        }
        Map<String, Object> appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        for (String pair : pairs = Util.split(appMap, this.queryString, PARAMETER_PAIR_SEPARATOR)) {
            String[] nameAndValue = Util.split(appMap, pair, PARAMETER_NAME_VALUE_SEPARATOR);
            if (nameAndValue.length != 2 || nameAndValue[0].trim().length() == 0) continue;
            this.addValueToParameter(nameAndValue[0], nameAndValue[1], false);
        }
        this.queryString = null;
    }

    protected void appendPath() {
        this.url.append(this.path);
    }

    protected void appendQueryString() {
        boolean hasQueryString = false;
        if (this.parameters != null) {
            String nextSeparatorChar;
            if (this.queryString == null) {
                nextSeparatorChar = QUERY_STRING_SEPARATOR;
            } else {
                nextSeparatorChar = PARAMETER_PAIR_SEPARATOR;
                this.url.append(QUERY_STRING_SEPARATOR).append(this.queryString);
            }
            for (Map.Entry<String, List<String>> param : this.parameters.entrySet()) {
                for (String value : param.getValue()) {
                    this.url.append(nextSeparatorChar);
                    this.url.append(param.getKey());
                    this.url.append(PARAMETER_NAME_VALUE_SEPARATOR);
                    this.url.append(value);
                    nextSeparatorChar = PARAMETER_PAIR_SEPARATOR;
                }
            }
            hasQueryString = true;
        } else if (this.queryString != null) {
            this.url.append(QUERY_STRING_SEPARATOR).append(this.queryString);
            hasQueryString = true;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ClientWindow cw = context.getExternalContext().getClientWindow();
        boolean appendClientWindow = false;
        if (null != cw) {
            appendClientWindow = cw.isClientWindowRenderModeEnabled(context);
        }
        if (appendClientWindow && -1 == this.url.indexOf("jfwid") && null != cw) {
            String clientWindow = cw.getId();
            if (!hasQueryString) {
                this.url.append(QUERY_STRING_SEPARATOR);
            } else {
                this.url.append(PARAMETER_PAIR_SEPARATOR);
            }
            this.url.append("jfwid").append(PARAMETER_NAME_VALUE_SEPARATOR).append(clientWindow);
            Map<String, String> additionalParams = cw.getQueryURLParameters(context);
            if (null != additionalParams) {
                for (Map.Entry<String, String> cur : additionalParams.entrySet()) {
                    this.url.append(PARAMETER_PAIR_SEPARATOR);
                    this.url.append(cur.getKey()).append(PARAMETER_NAME_VALUE_SEPARATOR).append(cur.getValue());
                }
            }
        }
    }

    protected void appendFragment() {
        if (this.fragment != null) {
            this.url.append(FRAGMENT_SEPARATOR).append(this.fragment);
        }
    }

    protected void extractSegments(String url) {
        int queryStringIndex;
        int fragmentIndex = url.indexOf(FRAGMENT_SEPARATOR);
        if (fragmentIndex != -1) {
            this.fragment = url.substring(fragmentIndex + 1);
            this.cleanFragment();
            url = url.substring(0, fragmentIndex);
        }
        if ((queryStringIndex = url.indexOf(QUERY_STRING_SEPARATOR)) != -1) {
            this.queryString = url.substring(queryStringIndex + 1);
            this.cleanQueryString();
            this.path = url.substring(0, queryStringIndex);
        } else {
            this.path = url;
        }
    }

    protected void addValueToParameter(String name, String value, boolean replace) {
        ArrayList<String> values = new ArrayList<String>(value == null ? 0 : 1);
        if (value != null) {
            values.add(value);
        }
        this.addValuesToParameter(name, values, replace);
    }

    protected void addValuesToParameter(String name, List<String> valuesRef, boolean replace) {
        ArrayList<String> values = new ArrayList<String>();
        if (valuesRef != null) {
            for (String string : valuesRef) {
                if (this.encoding != null) {
                    try {
                        values.add(URLEncoder.encode(string, this.encoding));
                        continue;
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                values.add(string);
            }
            values.removeAll(NULL_LIST);
        }
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, List<String>>();
        }
        if (replace) {
            this.parameters.put(name, values);
        } else {
            List<String> currentValues = this.parameters.get(name);
            if (currentValues == null) {
                currentValues = new ArrayList<String>(1);
                this.parameters.put(name, currentValues);
            }
            currentValues.addAll(values);
        }
    }

    private void cleanFragment() {
        if (this.fragment != null) {
            String f = this.fragment;
            if ((f = f.trim()).startsWith(FRAGMENT_SEPARATOR)) {
                f = f.substring(1);
            }
            if (f.length() == 0) {
                f = null;
            }
            this.fragment = f;
        }
    }

    private void cleanQueryString() {
        if (this.queryString != null) {
            String q = this.queryString;
            if ((q = q.trim()).startsWith(QUERY_STRING_SEPARATOR)) {
                q = q.substring(1);
            }
            if (q.length() == 0) {
                q = null;
            }
            this.queryString = q;
        }
    }
}

