/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.api.util.UtilLogging;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;

public class UnusedSchemaFilter
implements OASFilter {
    Map<String, List<Schema>> references = new HashMap<String, List<Schema>>();

    public Schema filterSchema(Schema schema) {
        String name = this.referencedName(schema);
        if (name != null) {
            this.references.computeIfAbsent(name, k -> new ArrayList()).add(schema);
        }
        return schema;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        Optional.ofNullable(components).map(Components::getSchemas).map(Map::keySet).ifPresent(schemaNames -> {
            Set<String> unusedNames = this.unusedSchemaNames((Set<String>)schemaNames);
            while (!unusedNames.isEmpty()) {
                unusedNames.forEach(name -> this.remove((String)name, components));
                unusedNames = this.unusedSchemaNames((Set<String>)schemaNames);
            }
        });
    }

    String referencedName(Schema schema) {
        String ref = schema.getRef();
        if (ref != null && ref.startsWith("#/components/schemas/")) {
            return ModelUtil.nameFromRef(ref);
        }
        return null;
    }

    boolean notUsed(String schemaName) {
        return !this.references.containsKey(schemaName);
    }

    Set<String> unusedSchemaNames(Set<String> allSchemaNames) {
        return allSchemaNames.stream().filter(this::notUsed).collect(Collectors.toSet());
    }

    void remove(String schemaName, Components components) {
        Schema unusedSchema = (Schema)components.getSchemas().get(schemaName);
        this.removeReference(unusedSchema.getAdditionalPropertiesSchema());
        this.removeReferences(unusedSchema.getAllOf());
        this.removeReferences(unusedSchema.getAnyOf());
        this.removeReferences(unusedSchema.getOneOf());
        this.removeReference(unusedSchema.getItems());
        this.removeReference(unusedSchema.getNot());
        this.removeReferences(unusedSchema.getProperties());
        components.removeSchema(schemaName);
        UtilLogging.logger.unusedSchemaRemoved(schemaName);
    }

    void removeReference(Schema schema) {
        String name;
        if (schema != null && (name = this.referencedName(schema)) != null) {
            this.references.computeIfPresent(name, (k, v) -> {
                v.remove(schema);
                return v.isEmpty() ? null : v;
            });
        }
    }

    void removeReferences(Map<String, Schema> schemas) {
        if (schemas != null) {
            this.removeReferences(schemas.values());
        }
    }

    void removeReferences(Collection<Schema> schemas) {
        if (schemas != null) {
            schemas.forEach(schema -> {
                this.removeReference((Schema)schema);
                this.removeReference(schema.getAdditionalPropertiesSchema());
                this.removeReferences(schema.getAllOf());
                this.removeReferences(schema.getAnyOf());
                this.removeReferences(schema.getOneOf());
                this.removeReference(schema.getItems());
                this.removeReference(schema.getNot());
                this.removeReferences(schema.getProperties());
            });
        }
    }
}

