/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.james.mime4j.util;

import java.util.ArrayList;
import java.util.Optional;

public class BufferRecycler {
    static final boolean ENABLED = Optional.ofNullable(System.getProperty("james.mime4j.buffer.recycling.enabled")).map(Boolean::parseBoolean).orElse(true);
    protected final ArrayList<byte[]>[] _byteBuffers;
    protected final ArrayList<char[]>[] _charBuffers;
    protected final ArrayList<int[]> _intBuffers;

    public BufferRecycler() {
        this(4, 4);
    }

    protected BufferRecycler(int bbCount, int cbCount) {
        int i;
        this._byteBuffers = new ArrayList[bbCount];
        for (i = 0; i < bbCount; ++i) {
            this._byteBuffers[i] = new ArrayList();
        }
        this._charBuffers = new ArrayList[cbCount];
        for (i = 0; i < cbCount; ++i) {
            this._charBuffers[i] = new ArrayList();
        }
        this._intBuffers = new ArrayList();
    }

    public final byte[] allocByteBuffer(int ix) {
        return this.allocByteBuffer(ix, 0);
    }

    public final int[] allocintBuffer(int minSize) {
        int DEF_SIZE = 256;
        if (minSize < 256) {
            minSize = 256;
        }
        ArrayList<int[]> buffers = this._intBuffers;
        int[] buffer = null;
        if (buffers.size() > 0) {
            buffer = buffers.remove(buffers.size() - 1);
        }
        if (buffer == null || buffer.length < minSize) {
            buffer = new int[minSize];
        }
        return buffer;
    }

    public byte[] allocByteBuffer(int ix, int minSize) {
        int DEF_SIZE = 4000;
        if (minSize < 4000) {
            minSize = 4000;
        }
        ArrayList<byte[]> buffers = this._byteBuffers[ix];
        byte[] buffer = null;
        if (buffers.size() > 0) {
            buffer = buffers.remove(buffers.size() - 1);
        }
        if (buffer == null || buffer.length < minSize) {
            buffer = this.balloc(minSize);
        }
        return buffer;
    }

    public void releaseByteBuffer(int ix, byte[] buffer) {
        if (buffer == null) {
            return;
        }
        this._byteBuffers[ix].add(buffer);
    }

    public void releaseIntBuffer(int[] buffer) {
        if (buffer == null) {
            return;
        }
        if (ENABLED) {
            this._intBuffers.add(buffer);
        }
    }

    public final char[] allocCharBuffer(int ix) {
        return this.allocCharBuffer(ix, 0);
    }

    public char[] allocCharBuffer(int ix, int minSize) {
        int DEF_SIZE = 4000;
        if (minSize < 4000) {
            minSize = 4000;
        }
        ArrayList<char[]> buffers = this._charBuffers[ix];
        char[] buffer = null;
        if (buffers.size() > 0) {
            buffer = buffers.remove(buffers.size() - 1);
        }
        if (buffer == null || buffer.length < minSize) {
            buffer = this.calloc(minSize);
        }
        return buffer;
    }

    public void releaseCharBuffer(int ix, char[] buffer) {
        if (ENABLED) {
            this._charBuffers[ix].add(buffer);
        }
    }

    protected byte[] balloc(int size) {
        return new byte[size];
    }

    protected char[] calloc(int size) {
        return new char[size];
    }
}

