/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bval.jsr.groups.GroupConversion;
import org.apache.bval.jsr.metadata.AnnotationBehavior;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.metadata.HasAnnotationBehavior;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.metadata.MetadataBuilder;
import org.apache.bval.jsr.metadata.Signature;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.Validate;

public class EmptyBuilder {
    private static final Map<AnnotationBehavior, EmptyBuilder> INSTANCES = new EnumMap<AnnotationBehavior, EmptyBuilder>(AnnotationBehavior.class);
    private final AnnotationBehavior annotationBehavior;
    private final Lazy<ForBean> forBean;
    private final Lazy<ForContainer> forContainer;
    private final Lazy<ForExecutable> forExecutable;
    private final Lazy<ForElement> forElement;

    public static EmptyBuilder instance() {
        return EmptyBuilder.instance(AnnotationBehavior.ABSTAIN);
    }

    public static EmptyBuilder instance(AnnotationBehavior annotationBehavior) {
        return INSTANCES.computeIfAbsent(annotationBehavior, EmptyBuilder::new);
    }

    private EmptyBuilder(AnnotationBehavior annotationBehavior) {
        this.annotationBehavior = Validate.notNull(annotationBehavior, "annotationBehavior", new Object[0]);
        this.forBean = new Lazy<ForBean>(() -> new ForBean());
        this.forContainer = new Lazy<ForContainer>(() -> new ForContainer());
        this.forExecutable = new Lazy<ForExecutable>(() -> new ForExecutable());
        this.forElement = new Lazy<ForElement>(() -> new ForElement());
    }

    public <T> MetadataBuilder.ForBean<T> forBean() {
        return this.forBean.get();
    }

    public <E extends AnnotatedElement> MetadataBuilder.ForContainer<E> forContainer() {
        return this.forContainer.get();
    }

    public <E extends Executable> MetadataBuilder.ForExecutable<E> forExecutable() {
        return this.forExecutable.get();
    }

    public <E extends AnnotatedElement> MetadataBuilder.ForElement<E> forElement() {
        return this.forElement.get();
    }

    private class ForExecutable<E extends Executable>
    extends Level
    implements MetadataBuilder.ForExecutable<E> {
        private ForExecutable() {
        }

        @Override
        public MetadataBuilder.ForElement<E> getCrossParameter(Meta<E> meta) {
            return EmptyBuilder.this.forElement.get();
        }

        @Override
        public List<MetadataBuilder.ForContainer<Parameter>> getParameters(Meta<E> meta) {
            return Collections.emptyList();
        }

        @Override
        public MetadataBuilder.ForContainer<E> getReturnValue(Meta<E> meta) {
            return EmptyBuilder.this.forContainer.get();
        }
    }

    private class ForContainer<E extends AnnotatedElement>
    extends ForElement<E>
    implements MetadataBuilder.ForContainer<E> {
        private ForContainer() {
        }

        @Override
        public boolean isCascade(Meta<E> meta) {
            return false;
        }

        @Override
        public Set<GroupConversion> getGroupConversions(Meta<E> meta) {
            return Collections.emptySet();
        }

        @Override
        public Map<ContainerElementKey, MetadataBuilder.ForContainer<AnnotatedType>> getContainerElementTypes(Meta<E> meta) {
            return Collections.emptyMap();
        }
    }

    private class ForClass<T>
    extends ForElement<Class<T>>
    implements MetadataBuilder.ForClass<T> {
        private ForClass() {
        }

        @Override
        public List<Class<?>> getGroupSequence(Meta<Class<T>> meta) {
            return null;
        }
    }

    private class ForElement<E extends AnnotatedElement>
    extends Level
    implements MetadataBuilder.ForElement<E> {
        private ForElement() {
        }

        @Override
        public final Annotation[] getDeclaredConstraints(Meta<E> meta) {
            return ObjectUtils.EMPTY_ANNOTATION_ARRAY;
        }
    }

    private class ForBean<T>
    extends Level
    implements MetadataBuilder.ForBean<T> {
        private final Lazy<ForClass> forClass;

        private ForBean() {
            this.forClass = new Lazy<ForClass>(() -> new ForClass());
        }

        @Override
        public MetadataBuilder.ForClass<T> getClass(Meta<Class<T>> meta) {
            return this.forClass.get();
        }

        @Override
        public Map<String, MetadataBuilder.ForContainer<Field>> getFields(Meta<Class<T>> meta) {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, MetadataBuilder.ForContainer<Method>> getGetters(Meta<Class<T>> meta) {
            return Collections.emptyMap();
        }

        @Override
        public Map<Signature, MetadataBuilder.ForExecutable<Constructor<? extends T>>> getConstructors(Meta<Class<T>> meta) {
            return Collections.emptyMap();
        }

        @Override
        public Map<Signature, MetadataBuilder.ForExecutable<Method>> getMethods(Meta<Class<T>> meta) {
            return Collections.emptyMap();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    private class Level
    implements HasAnnotationBehavior {
        private Level() {
        }

        @Override
        public final AnnotationBehavior getAnnotationBehavior() {
            return EmptyBuilder.this.annotationBehavior;
        }
    }
}

