/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.security.impl;

import jakarta.servlet.ServletRequest;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.AccessControl;
import net.shibboleth.shared.security.AccessControlService;
import org.slf4j.Logger;

public class BasicAccessControlService
extends AbstractIdentifiableInitializableComponent
implements AccessControlService {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BasicAccessControlService.class);
    @Nonnull
    private Map<String, AccessControl> policyMap = CollectionSupport.emptyMap();

    public void setPolicyMap(@Nullable Map<String, AccessControl> map) {
        this.checkSetterPreconditions();
        if (map != null) {
            this.policyMap = new HashMap<String, AccessControl>(map.size());
            for (Map.Entry<String, AccessControl> entry : map.entrySet()) {
                String trimmed = StringSupport.trimOrNull((String)entry.getKey());
                if (trimmed == null || entry.getValue() == null) continue;
                this.policyMap.put(trimmed, entry.getValue());
            }
        } else {
            this.policyMap = CollectionSupport.emptyMap();
        }
    }

    @Override
    @Nonnull
    public AccessControl getInstance(@Nonnull String name) {
        AccessControl ac = this.policyMap.get(name);
        if (ac != null) {
            return ac;
        }
        this.log.warn("Access Control Service {}: No policy named '{}' found, returning default denial policy", (Object)this.getId(), (Object)name);
        return new AccessControl(){

            @Override
            public boolean checkAccess(@Nonnull ServletRequest request, @Nullable String operation, @Nullable String resource) {
                return false;
            }
        };
    }
}

