/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.txt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.metadata.Metadata;

public class BOMDetector
implements EncodingDetector {
    private static final ByteOrderMark[] BOMS = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE};
    private static final Charset[] CHARSETS = new Charset[BOMS.length];
    private static final int MIN_BYTES = 2;
    private static final int MAX_BYTES = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Charset detect(InputStream input, Metadata metadata) throws IOException {
        input.mark(4);
        byte[] bytes = new byte[4];
        try {
            int numRead = IOUtils.read(input, bytes);
            if (numRead < 2) {
                Charset charset = null;
                return charset;
            }
            if (numRead < 4) {
                byte[] tmpBytes = new byte[numRead];
                System.arraycopy(bytes, 0, tmpBytes, 0, numRead);
                bytes = tmpBytes;
            }
        }
        finally {
            input.reset();
        }
        for (int i = 0; i < BOMS.length; ++i) {
            ByteOrderMark bom = BOMS[i];
            if (!this.startsWith(bom, bytes)) continue;
            return CHARSETS[i];
        }
        return null;
    }

    private boolean startsWith(ByteOrderMark bom, byte[] bytes) {
        byte[] bomBytes = bom.getBytes();
        if (bytes.length < bomBytes.length) {
            return false;
        }
        for (int i = 0; i < bomBytes.length; ++i) {
            if (bomBytes[i] == bytes[i]) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < BOMS.length; ++i) {
            try {
                BOMDetector.CHARSETS[i] = Charset.forName(BOMS[i].getCharsetName());
                continue;
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
    }
}

