/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.util.Arrays;
import java.util.Map;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.EvalParameters;
import opennlp.tools.ml.naivebayes.LogProbabilities;
import opennlp.tools.ml.naivebayes.NaiveBayesEvalParameters;
import opennlp.tools.ml.naivebayes.Probabilities;

public class NaiveBayesModel
extends AbstractModel {
    protected double[] outcomeTotals;
    protected long vocabulary;

    NaiveBayesModel(Context[] params, String[] predLabels, Map<String, Context> pmap, String[] outcomeNames) {
        super(params, predLabels, pmap, outcomeNames);
        this.outcomeTotals = this.initOutcomeTotals(outcomeNames, params);
        this.evalParams = new NaiveBayesEvalParameters(params, outcomeNames.length, this.outcomeTotals, predLabels.length);
        this.modelType = AbstractModel.ModelType.NaiveBayes;
    }

    public NaiveBayesModel(Context[] params, String[] predLabels, String[] outcomeNames) {
        super(params, predLabels, outcomeNames);
        this.outcomeTotals = this.initOutcomeTotals(outcomeNames, params);
        this.evalParams = new NaiveBayesEvalParameters(params, outcomeNames.length, this.outcomeTotals, predLabels.length);
        this.modelType = AbstractModel.ModelType.NaiveBayes;
    }

    protected double[] initOutcomeTotals(String[] outcomeNames, Context[] params) {
        double[] outcomeTotals = new double[outcomeNames.length];
        for (Context context : params) {
            for (int j = 0; j < context.getOutcomes().length; ++j) {
                int outcome = context.getOutcomes()[j];
                double count = context.getParameters()[j];
                int n = outcome;
                outcomeTotals[n] = outcomeTotals[n] + count;
            }
        }
        return outcomeTotals;
    }

    @Override
    public double[] eval(String[] context) {
        return this.eval(context, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] context, float[] values) {
        return this.eval(context, values, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] context, double[] probs) {
        return this.eval(context, null, probs);
    }

    public double[] eval(String[] context, float[] values, double[] outsums) {
        Context[] scontexts = new Context[context.length];
        Arrays.fill(outsums, 0.0);
        for (int i = 0; i < context.length; ++i) {
            scontexts[i] = (Context)this.pmap.get(context[i]);
        }
        return NaiveBayesModel.eval(scontexts, values, outsums, this.evalParams, true);
    }

    public static double[] eval(int[] context, double[] prior, EvalParameters model) {
        return NaiveBayesModel.eval(context, null, prior, model, true);
    }

    static double[] eval(Context[] context, float[] values, double[] prior, EvalParameters model, boolean normalize) {
        int i;
        LogProbabilities<Integer> probabilities = new LogProbabilities<Integer>();
        double[] outcomeTotals = model instanceof NaiveBayesEvalParameters ? ((NaiveBayesEvalParameters)model).getOutcomeTotals() : new double[prior.length];
        long vocabulary = model instanceof NaiveBayesEvalParameters ? ((NaiveBayesEvalParameters)model).getVocabulary() : 0L;
        double value = 1.0;
        for (int ci = 0; ci < context.length; ++ci) {
            if (context[ci] == null) continue;
            Context predParams = context[ci];
            int[] activeOutcomes = predParams.getOutcomes();
            double[] activeParameters = predParams.getParameters();
            if (values != null) {
                value = values[ci];
            }
            int ai = 0;
            for (int i2 = 0; i2 < outcomeTotals.length && ai < activeOutcomes.length; ++i2) {
                int oid = activeOutcomes[ai];
                double numerator = oid == i2 ? activeParameters[ai++] * value : 0.0;
                double denominator = outcomeTotals[i2];
                ((Probabilities)probabilities).addIn(i2, NaiveBayesModel.getProbability(numerator, denominator, vocabulary, true), 1);
            }
        }
        double total = 0.0;
        for (double outcomeTotal : outcomeTotals) {
            total += outcomeTotal;
        }
        for (i = 0; i < outcomeTotals.length; ++i) {
            double numerator = outcomeTotals[i];
            ((Probabilities)probabilities).addIn(i, numerator / total, 1);
        }
        for (i = 0; i < outcomeTotals.length; ++i) {
            prior[i] = ((Probabilities)probabilities).get(i);
        }
        return prior;
    }

    static double[] eval(int[] context, float[] values, double[] prior, EvalParameters model, boolean normalize) {
        Context[] scontexts = new Context[context.length];
        for (int i = 0; i < context.length; ++i) {
            scontexts[i] = model.getParams()[context[i]];
        }
        return NaiveBayesModel.eval(scontexts, values, prior, model, normalize);
    }

    private static double getProbability(double numerator, double denominator, double vocabulary, boolean isSmoothed) {
        if (isSmoothed) {
            return NaiveBayesModel.getSmoothedProbability(numerator, denominator, vocabulary);
        }
        if (denominator == 0.0 || denominator <= Double.MIN_VALUE) {
            return 0.0;
        }
        return numerator / denominator;
    }

    private static double getSmoothedProbability(double numerator, double denominator, double vocabulary) {
        double delta = 0.05;
        return (numerator + 0.05) / (denominator + 0.05 * vocabulary);
    }
}

