/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import opennlp.tools.formats.conllu.ConlluSentence;
import opennlp.tools.formats.conllu.ConlluTagset;
import opennlp.tools.formats.conllu.ConlluWordLine;
import opennlp.tools.lemmatizer.LemmaSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class ConlluLemmaSampleStream
extends FilterObjectStream<ConlluSentence, LemmaSample> {
    private final ConlluTagset tagset;

    public ConlluLemmaSampleStream(ObjectStream<ConlluSentence> samples, ConlluTagset tagset) {
        super(samples);
        this.tagset = Objects.requireNonNull(tagset);
    }

    @Override
    public LemmaSample read() throws IOException {
        ConlluSentence sentence = (ConlluSentence)this.samples.read();
        if (sentence != null) {
            ArrayList<String> tokens = new ArrayList<String>();
            ArrayList<String> tags = new ArrayList<String>();
            ArrayList<String> lemmas = new ArrayList<String>();
            for (ConlluWordLine line : sentence.getWordLines()) {
                tokens.add(line.getForm());
                tags.add(line.getPosTag(this.tagset));
                lemmas.add(line.getLemma());
            }
            return new LemmaSample(tokens, tags, lemmas);
        }
        return null;
    }
}

