/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.request;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.types.ResourceDeassociationAction;

public class ResourceDR
implements BaseBean {
    private static final long serialVersionUID = 6295778399633883767L;
    private String key;
    private ResourceDeassociationAction action;
    private final List<String> resources = new ArrayList<String>();

    public String getKey() {
        return this.key;
    }

    @PathParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public ResourceDeassociationAction getAction() {
        return this.action;
    }

    @PathParam(value="action")
    public void setAction(ResourceDeassociationAction action) {
        this.action = action;
    }

    @JacksonXmlElementWrapper(localName="resources")
    @JacksonXmlProperty(localName="resource")
    public List<String> getResources() {
        return this.resources;
    }

    public static class Builder {
        private final ResourceDR instance = new ResourceDR();

        public Builder key(String key) {
            this.instance.setKey(key);
            return this;
        }

        public Builder action(ResourceDeassociationAction action) {
            this.instance.setAction(action);
            return this;
        }

        public Builder resource(String resource) {
            if (resource != null) {
                this.instance.getResources().add(resource);
            }
            return this;
        }

        public Builder resources(String ... resources) {
            this.instance.getResources().addAll(List.of(resources));
            return this;
        }

        public Builder resources(Collection<String> resources) {
            if (resources != null) {
                this.instance.getResources().addAll(resources);
            }
            return this;
        }

        public ResourceDR build() {
            return this.instance;
        }
    }
}

