/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.oauthbearer.internals.secured.Retryable;
import org.apache.kafka.common.utils.Utils;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.lang.JoseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class OAuthBearerTest {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ObjectMapper mapper = new ObjectMapper();

    protected void assertThrowsWithMessage(Class<? extends Exception> clazz, Executable executable, String substring) {
        this.assertErrorMessageContains(((Exception)Assertions.assertThrows(clazz, (Executable)executable)).getMessage(), substring);
    }

    protected void assertErrorMessageContains(String actual, String expectedSubstring) {
        Assertions.assertTrue((boolean)actual.contains(expectedSubstring), (String)String.format("Expected exception message (\"%s\") to contain substring (\"%s\")", actual, expectedSubstring));
    }

    protected void configureHandler(AuthenticateCallbackHandler handler, Map<String, ?> configs, Map<String, Object> jaasConfig) {
        TestJaasConfig config = new TestJaasConfig();
        config.createOrUpdateEntry("KafkaClient", OAuthBearerLoginModule.class.getName(), jaasConfig);
        AppConfigurationEntry kafkaClient = config.getAppConfigurationEntry("KafkaClient")[0];
        handler.configure(configs, "OAUTHBEARER", Collections.singletonList(kafkaClient));
    }

    protected String createBase64JsonJwtSection(Consumer<ObjectNode> c) {
        String json = this.createJsonJwtSection(c);
        try {
            return Utils.utf8((byte[])Base64.getEncoder().encode(Utils.utf8((String)json)));
        }
        catch (Throwable t) {
            Assertions.fail((Throwable)t);
            return null;
        }
    }

    protected String createJsonJwtSection(Consumer<ObjectNode> c) {
        ObjectNode node = this.mapper.createObjectNode();
        c.accept(node);
        try {
            return this.mapper.writeValueAsString((Object)node);
        }
        catch (Throwable t) {
            Assertions.fail((Throwable)t);
            return null;
        }
    }

    protected Retryable<String> createRetryable(Exception[] attempts) {
        Iterator<Exception> i = Arrays.asList(attempts).iterator();
        return () -> {
            Exception e;
            Exception exception = e = i.hasNext() ? (Exception)i.next() : null;
            if (e == null) {
                return "success!";
            }
            if (e instanceof IOException) {
                throw new ExecutionException(e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        };
    }

    protected HttpURLConnection createHttpURLConnection(String response) throws IOException {
        HttpURLConnection mockedCon = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)mockedCon.getURL()).thenReturn((Object)new URL("https://www.example.com"));
        Mockito.when((Object)mockedCon.getResponseCode()).thenReturn((Object)200);
        Mockito.when((Object)mockedCon.getOutputStream()).thenReturn((Object)new ByteArrayOutputStream());
        Mockito.when((Object)mockedCon.getInputStream()).thenReturn((Object)new ByteArrayInputStream(Utils.utf8((String)response)));
        return mockedCon;
    }

    protected File createTempDir(String directory) throws IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        if (directory != null) {
            tmpDir = new File(tmpDir, directory);
        }
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException("Could not create " + tmpDir);
        }
        tmpDir.deleteOnExit();
        this.log.debug("Created temp directory {}", (Object)tmpDir);
        return tmpDir;
    }

    protected File createTempFile(File tmpDir, String prefix, String suffix, String contents) throws IOException {
        File file = File.createTempFile(prefix, suffix, tmpDir);
        this.log.debug("Created new temp file {}", (Object)file);
        file.deleteOnExit();
        try (FileWriter writer = new FileWriter(file);){
            writer.write(contents);
        }
        return file;
    }

    protected Map<String, ?> getSaslConfigs(Map<String, ?> configs) {
        ConfigDef configDef = new ConfigDef();
        configDef.withClientSaslSupport();
        AbstractConfig sslClientConfig = new AbstractConfig(configDef, configs);
        return sslClientConfig.values();
    }

    protected Map<String, ?> getSaslConfigs(String name, Object value) {
        return this.getSaslConfigs(Collections.singletonMap(name, value));
    }

    protected Map<String, ?> getSaslConfigs() {
        return this.getSaslConfigs(Collections.emptyMap());
    }

    protected PublicJsonWebKey createRsaJwk() throws JoseException {
        RsaJsonWebKey jwk = RsaJwkGenerator.generateJwk((int)2048);
        jwk.setKeyId("key-1");
        return jwk;
    }

    protected PublicJsonWebKey createEcJwk() throws JoseException {
        PublicJsonWebKey jwk = PublicJsonWebKey.Factory.newPublicJwk((String)"{  \"kty\": \"EC\",  \"d\": \"Tk7qzHNnSBMioAU7NwZ9JugFWmWbUCyzeBRjVcTp_so\",  \"use\": \"sig\",  \"crv\": \"P-256\",  \"kid\": \"key-1\",  \"x\": \"qqeGjWmYZU5M5bBrRw1zqZcbPunoFVxsfaa9JdA0R5I\",  \"y\": \"wnoj0YjheNP80XYh1SEvz1-wnKByEoHvb6KrDcjMuWc\"}");
        jwk.setKeyId("key-1");
        return jwk;
    }
}

