/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.Arrays;
import java.util.Random;
import org.apache.kafka.common.metrics.stats.Histogram;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HistogramTest {
    private static final double EPS = 1.0E-7;

    @Test
    public void testHistogram() {
        int i;
        Histogram.ConstantBinScheme scheme = new Histogram.ConstantBinScheme(10, -5.0, 5.0);
        Histogram hist = new Histogram((Histogram.BinScheme)scheme);
        for (i = -5; i < 5; ++i) {
            hist.record((double)i);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((double)scheme.fromBin(i), (double)hist.value((double)i / 10.0 + 1.0E-7), (double)1.0E-7);
        }
    }

    @Test
    public void testConstantBinScheme() {
        Histogram.ConstantBinScheme scheme = new Histogram.ConstantBinScheme(5, -5.0, 5.0);
        Assertions.assertEquals((int)0, (int)scheme.toBin(-5.01), (String)"A value below the lower bound should map to the first bin");
        Assertions.assertEquals((int)4, (int)scheme.toBin(5.01), (String)"A value above the upper bound should map to the last bin");
        Assertions.assertEquals((int)0, (int)scheme.toBin(-5.0001), (String)"Check boundary of bucket 0");
        Assertions.assertEquals((int)0, (int)scheme.toBin(-5.0), (String)"Check boundary of bucket 0");
        Assertions.assertEquals((int)0, (int)scheme.toBin(-4.99999), (String)"Check boundary of bucket 0");
        Assertions.assertEquals((int)0, (int)scheme.toBin(-3.00001), (String)"Check boundary of bucket 0");
        Assertions.assertEquals((int)1, (int)scheme.toBin(-3.0), (String)"Check boundary of bucket 1");
        Assertions.assertEquals((int)1, (int)scheme.toBin(-1.00001), (String)"Check boundary of bucket 1");
        Assertions.assertEquals((int)2, (int)scheme.toBin(-1.0), (String)"Check boundary of bucket 2");
        Assertions.assertEquals((int)2, (int)scheme.toBin(0.99999), (String)"Check boundary of bucket 2");
        Assertions.assertEquals((int)3, (int)scheme.toBin(1.0), (String)"Check boundary of bucket 3");
        Assertions.assertEquals((int)3, (int)scheme.toBin(2.99999), (String)"Check boundary of bucket 3");
        Assertions.assertEquals((int)4, (int)scheme.toBin(3.0), (String)"Check boundary of bucket 4");
        Assertions.assertEquals((int)4, (int)scheme.toBin(4.9999), (String)"Check boundary of bucket 4");
        Assertions.assertEquals((int)4, (int)scheme.toBin(5.0), (String)"Check boundary of bucket 4");
        Assertions.assertEquals((int)4, (int)scheme.toBin(5.001), (String)"Check boundary of bucket 4");
        Assertions.assertEquals((double)Double.NEGATIVE_INFINITY, (double)scheme.fromBin(-1), (double)0.001);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)scheme.fromBin(5), (double)0.001);
        Assertions.assertEquals((double)-5.0, (double)scheme.fromBin(0), (double)0.001);
        Assertions.assertEquals((double)-3.0, (double)scheme.fromBin(1), (double)0.001);
        Assertions.assertEquals((double)-1.0, (double)scheme.fromBin(2), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)scheme.fromBin(3), (double)0.001);
        Assertions.assertEquals((double)3.0, (double)scheme.fromBin(4), (double)0.001);
        this.checkBinningConsistency((Histogram.BinScheme)scheme);
    }

    @Test
    public void testConstantBinSchemeWithPositiveRange() {
        Histogram.ConstantBinScheme scheme = new Histogram.ConstantBinScheme(5, 0.0, 5.0);
        Assertions.assertEquals((int)0, (int)scheme.toBin(-1.0), (String)"A value below the lower bound should map to the first bin");
        Assertions.assertEquals((int)4, (int)scheme.toBin(5.01), (String)"A value above the upper bound should map to the last bin");
        Assertions.assertEquals((int)0, (int)scheme.toBin(-1.0E-4), (String)"Check boundary of bucket 0");
        Assertions.assertEquals((int)0, (int)scheme.toBin(0.0), (String)"Check boundary of bucket 0");
        Assertions.assertEquals((int)0, (int)scheme.toBin(1.0E-4), (String)"Check boundary of bucket 0");
        Assertions.assertEquals((int)0, (int)scheme.toBin(0.9999), (String)"Check boundary of bucket 0");
        Assertions.assertEquals((int)1, (int)scheme.toBin(1.0), (String)"Check boundary of bucket 1");
        Assertions.assertEquals((int)1, (int)scheme.toBin(1.0001), (String)"Check boundary of bucket 1");
        Assertions.assertEquals((int)1, (int)scheme.toBin(1.9999), (String)"Check boundary of bucket 1");
        Assertions.assertEquals((int)2, (int)scheme.toBin(2.0), (String)"Check boundary of bucket 2");
        Assertions.assertEquals((int)2, (int)scheme.toBin(2.0001), (String)"Check boundary of bucket 2");
        Assertions.assertEquals((int)2, (int)scheme.toBin(2.9999), (String)"Check boundary of bucket 2");
        Assertions.assertEquals((int)3, (int)scheme.toBin(3.0), (String)"Check boundary of bucket 3");
        Assertions.assertEquals((int)3, (int)scheme.toBin(3.0001), (String)"Check boundary of bucket 3");
        Assertions.assertEquals((int)3, (int)scheme.toBin(3.9999), (String)"Check boundary of bucket 3");
        Assertions.assertEquals((int)4, (int)scheme.toBin(4.0), (String)"Check boundary of bucket 4");
        Assertions.assertEquals((int)4, (int)scheme.toBin(4.9999), (String)"Check boundary of bucket 4");
        Assertions.assertEquals((int)4, (int)scheme.toBin(5.0), (String)"Check boundary of bucket 4");
        Assertions.assertEquals((int)4, (int)scheme.toBin(5.0001), (String)"Check boundary of bucket 4");
        Assertions.assertEquals((double)Double.NEGATIVE_INFINITY, (double)scheme.fromBin(-1), (double)0.001);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)scheme.fromBin(5), (double)0.001);
        Assertions.assertEquals((double)0.0, (double)scheme.fromBin(0), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)scheme.fromBin(1), (double)0.001);
        Assertions.assertEquals((double)2.0, (double)scheme.fromBin(2), (double)0.001);
        Assertions.assertEquals((double)3.0, (double)scheme.fromBin(3), (double)0.001);
        Assertions.assertEquals((double)4.0, (double)scheme.fromBin(4), (double)0.001);
        this.checkBinningConsistency((Histogram.BinScheme)scheme);
    }

    @Test
    public void testLinearBinScheme() {
        Histogram.LinearBinScheme scheme = new Histogram.LinearBinScheme(10, 10.0);
        Assertions.assertEquals((double)Double.NEGATIVE_INFINITY, (double)scheme.fromBin(-1), (double)0.001);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)scheme.fromBin(11), (double)0.001);
        Assertions.assertEquals((double)0.0, (double)scheme.fromBin(0), (double)0.001);
        Assertions.assertEquals((double)0.2222, (double)scheme.fromBin(1), (double)0.001);
        Assertions.assertEquals((double)0.6666, (double)scheme.fromBin(2), (double)0.001);
        Assertions.assertEquals((double)1.3333, (double)scheme.fromBin(3), (double)0.001);
        Assertions.assertEquals((double)2.2222, (double)scheme.fromBin(4), (double)0.001);
        Assertions.assertEquals((double)3.3333, (double)scheme.fromBin(5), (double)0.001);
        Assertions.assertEquals((double)4.6667, (double)scheme.fromBin(6), (double)0.001);
        Assertions.assertEquals((double)6.2222, (double)scheme.fromBin(7), (double)0.001);
        Assertions.assertEquals((double)8.0, (double)scheme.fromBin(8), (double)0.001);
        Assertions.assertEquals((double)10.0, (double)scheme.fromBin(9), (double)0.001);
        Assertions.assertEquals((int)0, (int)scheme.toBin(0.0));
        Assertions.assertEquals((int)0, (int)scheme.toBin(0.2221));
        Assertions.assertEquals((int)1, (int)scheme.toBin(0.2223));
        Assertions.assertEquals((int)2, (int)scheme.toBin(0.6667));
        Assertions.assertEquals((int)3, (int)scheme.toBin(1.3334));
        Assertions.assertEquals((int)4, (int)scheme.toBin(2.2223));
        Assertions.assertEquals((int)5, (int)scheme.toBin(3.3334));
        Assertions.assertEquals((int)6, (int)scheme.toBin(4.6667));
        Assertions.assertEquals((int)7, (int)scheme.toBin(6.2223));
        Assertions.assertEquals((int)8, (int)scheme.toBin(8.0));
        Assertions.assertEquals((int)9, (int)scheme.toBin(10.0));
        Assertions.assertEquals((int)9, (int)scheme.toBin(10.001));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)scheme.fromBin(10), (double)0.001);
        this.checkBinningConsistency((Histogram.BinScheme)scheme);
    }

    private void checkBinningConsistency(Histogram.BinScheme scheme) {
        for (int bin = 0; bin < scheme.bins(); ++bin) {
            double fromBin = scheme.fromBin(bin);
            int binAgain = scheme.toBin(fromBin + 1.0E-7);
            Assertions.assertEquals((int)bin, (int)binAgain, (String)("unbinning and rebinning the bin " + bin + " gave a different result (" + fromBin + " was placed in bin " + binAgain + " )"));
        }
    }

    public static void main(String[] args) {
        double quantile;
        Histogram h;
        Random random = new Random();
        System.out.println("[-100, 100]:");
        for (Histogram.BinScheme binScheme : Arrays.asList(new Histogram.ConstantBinScheme(1000, -100.0, 100.0), new Histogram.ConstantBinScheme(100, -100.0, 100.0), new Histogram.ConstantBinScheme(10, -100.0, 100.0))) {
            h = new Histogram(binScheme);
            for (int i = 0; i < 10000; ++i) {
                h.record(200.0 * random.nextDouble() - 100.0);
            }
            for (quantile = 0.0; quantile < 1.0; quantile += 0.05) {
                System.out.printf("%5.2f: %.1f, ", quantile, h.value(quantile));
            }
            System.out.println();
        }
        System.out.println("[0, 1000]");
        for (Histogram.BinScheme binScheme : Arrays.asList(new Histogram.LinearBinScheme(1000, 1000.0), new Histogram.LinearBinScheme(100, 1000.0), new Histogram.LinearBinScheme(10, 1000.0))) {
            h = new Histogram(binScheme);
            for (int i = 0; i < 10000; ++i) {
                h.record(1000.0 * random.nextDouble());
            }
            for (quantile = 0.0; quantile < 1.0; quantile += 0.05) {
                System.out.printf("%5.2f: %.1f, ", quantile, h.value(quantile));
            }
            System.out.println();
        }
    }
}

