/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.webflow.config.FlowBuilderInfo;
import org.springframework.webflow.config.FlowElementAttribute;
import org.springframework.webflow.config.FlowLocation;
import org.w3c.dom.Element;

class FlowRegistryBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String DEFAULT_CONVERSION_SERVICE_CLASS_NAME = "org.springframework.binding.convert.service.DefaultConversionService";
    private static final String WEB_FLOW_SPRING_EL_EXPRESSION_PARSER_CLASS_NAME = "org.springframework.webflow.expression.spel.WebFlowSpringELExpressionParser";
    private static final String SPRING_EL_EXPRESSION_PARSER_CLASS_NAME = "org.springframework.expression.spel.standard.SpelExpressionParser";
    private static final String FLOW_BUILDER_SERVICES_CLASS_NAME = "org.springframework.webflow.engine.builder.support.FlowBuilderServices";
    private static final String FLOW_REGISTRY_FACTORY_BEAN_CLASS_NAME = "org.springframework.webflow.config.FlowRegistryFactoryBean";
    private static final String MVC_VIEW_FACTORY_CREATOR_CLASS_NAME = "org.springframework.webflow.mvc.builder.MvcViewFactoryCreator";

    FlowRegistryBeanDefinitionParser() {
    }

    protected String getBeanClassName(Element element) {
        return FLOW_REGISTRY_FACTORY_BEAN_CLASS_NAME;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder definitionBuilder) {
        String basePath;
        CompositeComponentDefinition componentDefinition = new CompositeComponentDefinition(element.getLocalName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(componentDefinition);
        this.parseFlowBuilderServices(element, parserContext, definitionBuilder);
        String parent = element.getAttribute("parent");
        if (StringUtils.hasText((String)parent)) {
            definitionBuilder.addPropertyReference("parent", parent);
        }
        if (StringUtils.hasText((String)(basePath = element.getAttribute("base-path")))) {
            definitionBuilder.addPropertyValue("basePath", (Object)basePath);
        }
        definitionBuilder.addPropertyValue("flowLocations", this.parseLocations(element));
        definitionBuilder.addPropertyValue("flowLocationPatterns", this.parseLocationPatterns(element));
        definitionBuilder.addPropertyValue("flowBuilders", this.parseFlowBuilders(element));
        parserContext.popAndRegisterContainingComponent();
    }

    private List<FlowLocation> parseLocations(Element element) {
        List locationElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flow-location");
        if (locationElements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FlowLocation> locations = new ArrayList<FlowLocation>(locationElements.size());
        for (Element locationElement : locationElements) {
            String id = locationElement.getAttribute("id");
            String path = locationElement.getAttribute("path");
            locations.add(new FlowLocation(id, path, this.parseAttributes(locationElement)));
        }
        return locations;
    }

    private List<String> parseLocationPatterns(Element element) {
        List locationPatternElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flow-location-pattern");
        if (locationPatternElements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> locationPatterns = new ArrayList<String>(locationPatternElements.size());
        for (Element locationPatternElement : locationPatternElements) {
            String value = locationPatternElement.getAttribute("value");
            locationPatterns.add(value);
        }
        return locationPatterns;
    }

    private Set<FlowElementAttribute> parseAttributes(Element element) {
        Element definitionAttributesElement = DomUtils.getChildElementByTagName((Element)element, (String)"flow-definition-attributes");
        if (definitionAttributesElement != null) {
            List attributeElements = DomUtils.getChildElementsByTagName((Element)definitionAttributesElement, (String)"attribute");
            HashSet<FlowElementAttribute> attributes = new HashSet<FlowElementAttribute>(attributeElements.size());
            for (Element attributeElement : attributeElements) {
                String name = attributeElement.getAttribute("name");
                String value = attributeElement.getAttribute("value");
                String type = attributeElement.getAttribute("type");
                attributes.add(new FlowElementAttribute(name, value, type));
            }
            return attributes;
        }
        return null;
    }

    private List<FlowBuilderInfo> parseFlowBuilders(Element element) {
        List builderElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flow-builder");
        if (builderElements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FlowBuilderInfo> builders = new ArrayList<FlowBuilderInfo>(builderElements.size());
        for (Element builderElement : builderElements) {
            String id = builderElement.getAttribute("id");
            String className = builderElement.getAttribute("class");
            builders.add(new FlowBuilderInfo(id, className, this.parseAttributes(builderElement)));
        }
        return builders;
    }

    private void parseFlowBuilderServices(Element element, ParserContext context, BeanDefinitionBuilder definitionBuilder) {
        String flowBuilderServices = element.getAttribute("flow-builder-services");
        if (!StringUtils.hasText((String)flowBuilderServices)) {
            BeanDefinitionBuilder flowBuilderServicesBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)FLOW_BUILDER_SERVICES_CLASS_NAME);
            BeanDefinitionBuilder conversionServiceBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)DEFAULT_CONVERSION_SERVICE_CLASS_NAME);
            String conversionService = this.registerInfrastructureComponent(element, context, conversionServiceBuilder);
            flowBuilderServicesBuilder.addPropertyReference("conversionService", conversionService);
            BeanDefinitionBuilder springElExpressionParserBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)SPRING_EL_EXPRESSION_PARSER_CLASS_NAME);
            BeanDefinitionBuilder webFlowElExpressionParserBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)WEB_FLOW_SPRING_EL_EXPRESSION_PARSER_CLASS_NAME);
            webFlowElExpressionParserBuilder.addConstructorArgValue((Object)springElExpressionParserBuilder.getBeanDefinition());
            String expressionParser = this.registerInfrastructureComponent(element, context, webFlowElExpressionParserBuilder);
            flowBuilderServicesBuilder.addPropertyReference("expressionParser", expressionParser);
            BeanDefinitionBuilder viewFactoryCreatorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)MVC_VIEW_FACTORY_CREATOR_CLASS_NAME);
            String viewFactoryCreator = this.registerInfrastructureComponent(element, context, viewFactoryCreatorBuilder);
            flowBuilderServicesBuilder.addPropertyReference("viewFactoryCreator", viewFactoryCreator);
            flowBuilderServices = this.registerInfrastructureComponent(element, context, flowBuilderServicesBuilder);
        }
        definitionBuilder.addPropertyReference("flowBuilderServices", flowBuilderServices);
    }

    private String registerInfrastructureComponent(Element element, ParserContext context, BeanDefinitionBuilder viewFactoryCreatorBuilder) {
        String beanName = context.getReaderContext().generateBeanName((BeanDefinition)viewFactoryCreatorBuilder.getRawBeanDefinition());
        viewFactoryCreatorBuilder.getRawBeanDefinition().setSource(context.extractSource((Object)element));
        viewFactoryCreatorBuilder.getRawBeanDefinition().setRole(2);
        context.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)viewFactoryCreatorBuilder.getBeanDefinition(), beanName));
        return beanName;
    }
}

