/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.internal.util;

import com.yubico.internal.util.BinaryUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class CertificateParser {
    public static final String ID_FIDO_GEN_CE_AAGUID = "1.3.6.1.4.1.45724.1.1.4";
    public static final String OID_CRL_DISTRIBUTION_POINTS = "2.5.29.31";
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final List<String> FIXSIG = Arrays.asList("CN=Yubico U2F EE Serial 776137165", "CN=Yubico U2F EE Serial 1086591525", "CN=Yubico U2F EE Serial 1973679733", "CN=Yubico U2F EE Serial 13503277888", "CN=Yubico U2F EE Serial 13831167861", "CN=Yubico U2F EE Serial 14803321578");
    private static final int UNUSED_BITS_BYTE_INDEX_FROM_END = 257;

    public static X509Certificate parsePem(String pemEncodedCert) throws CertificateException {
        return CertificateParser.parseDer(pemEncodedCert.replaceAll("-----BEGIN CERTIFICATE-----", "").replaceAll("-----END CERTIFICATE-----", "").replaceAll("\n", ""));
    }

    public static X509Certificate parseDer(String base64DerEncodedCert) throws CertificateException {
        return CertificateParser.parseDer(BASE64_DECODER.decode(base64DerEncodedCert));
    }

    public static X509Certificate parseDer(byte[] derEncodedCert) throws CertificateException {
        return CertificateParser.parseDer(new ByteArrayInputStream(derEncodedCert));
    }

    public static X509Certificate parseDer(InputStream is) throws CertificateException {
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
        if (FIXSIG.contains(cert.getSubjectX500Principal().getName())) {
            byte[] encoded = cert.getEncoded();
            if (encoded.length < 257) {
                throw new IllegalArgumentException(String.format("Expected DER encoded cert to be at least %d bytes, was %d: %s", 257, encoded.length, cert));
            }
            encoded[encoded.length - 257] = 0;
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(encoded));
        }
        return cert;
    }

    public static byte[] computeSubjectKeyIdentifier(Certificate cert) throws NoSuchAlgorithmException {
        byte[] spki = cert.getPublicKey().getEncoded();
        byte algLength = spki[3];
        int spkBitsStart = 6 + algLength + 1;
        return MessageDigest.getInstance("SHA-1").digest(Arrays.copyOfRange(spki, spkBitsStart, spki.length));
    }

    private static byte[] parseAaguid(byte[] bytes) {
        ByteBuffer buffer;
        if (bytes != null && bytes.length == 20 && (buffer = ByteBuffer.wrap(bytes)).get() == 4 && buffer.get() == 18 && buffer.get() == 4 && buffer.get() == 16) {
            byte[] aaguidBytes = new byte[16];
            buffer.get(aaguidBytes);
            return aaguidBytes;
        }
        throw new IllegalArgumentException("X.509 extension 1.3.6.1.4.1.45724.1.1.4 (id-fido-gen-ce-aaguid) is not valid.");
    }

    public static Optional<byte[]> parseFidoAaguidExtension(X509Certificate cert) {
        Optional<byte[]> result = Optional.ofNullable(cert.getExtensionValue(ID_FIDO_GEN_CE_AAGUID)).map(CertificateParser::parseAaguid);
        result.ifPresent(aaguid -> {
            if (cert.getCriticalExtensionOIDs().contains(ID_FIDO_GEN_CE_AAGUID)) {
                throw new IllegalArgumentException(String.format("X.509 extension %s (id-fido-gen-ce-aaguid) must not be marked critical.", ID_FIDO_GEN_CE_AAGUID));
            }
        });
        return result;
    }

    public static ParseCrlDistributionPointsExtensionResult parseCrlDistributionPointsExtension(X509Certificate cert) {
        byte[] crldpExtension = cert.getExtensionValue(OID_CRL_DISTRIBUTION_POINTS);
        if (crldpExtension != null) {
            BinaryUtil.ParseDerResult<byte[]> octetString = BinaryUtil.parseDerOctetString(crldpExtension, 0);
            try {
                BinaryUtil.ParseDerResult distributionPoints = BinaryUtil.parseDerSequence((byte[])octetString.result, 0, (outerSequenceDer, distributionPointOffset) -> BinaryUtil.parseDerSequence(outerSequenceDer, distributionPointOffset, (innerSequenceDer, distributionPointChoiceOffset) -> {
                    BinaryUtil.ParseDerResult<Optional<Integer>> dpElementOffsets = BinaryUtil.parseDerTaggedOrSkip(innerSequenceDer, distributionPointChoiceOffset, (byte)0, true, BinaryUtil.DerTagClass.CONTEXT_SPECIFIC);
                    if (((Optional)dpElementOffsets.result).isPresent()) {
                        BinaryUtil.ParseDerResult<Optional<Integer>> dpNameElementOffsets = BinaryUtil.parseDerTaggedOrSkip(innerSequenceDer, (Integer)((Optional)dpElementOffsets.result).get(), (byte)0, true, BinaryUtil.DerTagClass.CONTEXT_SPECIFIC);
                        if (((Optional)dpNameElementOffsets.result).isPresent()) {
                            return BinaryUtil.parseDerSequenceContents(innerSequenceDer, (Integer)((Optional)dpNameElementOffsets.result).get(), dpNameElementOffsets.nextOffset, (generalNamesDer, generalNamesElementOffset) -> {
                                BinaryUtil.ParseDerResult<Optional<Integer>> generalNameOffsets = BinaryUtil.parseDerTaggedOrSkip(generalNamesDer, generalNamesElementOffset, (byte)6, false, BinaryUtil.DerTagClass.CONTEXT_SPECIFIC);
                                if (((Optional)generalNameOffsets.result).isPresent()) {
                                    String uriString = new String(Arrays.copyOfRange(generalNamesDer, (int)((Integer)((Optional)generalNameOffsets.result).get()), generalNameOffsets.nextOffset), StandardCharsets.US_ASCII);
                                    try {
                                        return new BinaryUtil.ParseDerResult<Optional<URL>>(Optional.of(new URL(uriString)), generalNameOffsets.nextOffset);
                                    }
                                    catch (MalformedURLException e) {
                                        throw new IllegalArgumentException(String.format("Invalid URL in CRLDistributionPoints: %s", uriString), e);
                                    }
                                }
                                return new BinaryUtil.ParseDerResult(Optional.empty(), generalNameOffsets.nextOffset);
                            });
                        }
                    }
                    return new BinaryUtil.ParseDerResult(Collections.emptyList(), dpElementOffsets.nextOffset);
                }));
                return ((List)distributionPoints.result).stream().flatMap(Collection::stream).flatMap(Collection::stream).reduce(new ParseCrlDistributionPointsExtensionResult(new ArrayList<URL>(), false), (result, next) -> {
                    if (next.isPresent()) {
                        ArrayList<URL> dp = new ArrayList<URL>(((ParseCrlDistributionPointsExtensionResult)result).distributionPoints);
                        dp.add((URL)next.get());
                        return new ParseCrlDistributionPointsExtensionResult(dp, ((ParseCrlDistributionPointsExtensionResult)result).anyDistributionPointUnsupported);
                    }
                    return new ParseCrlDistributionPointsExtensionResult(((ParseCrlDistributionPointsExtensionResult)result).distributionPoints, true);
                }, (resultA, resultB) -> {
                    ArrayList<URL> dp = new ArrayList<URL>(((ParseCrlDistributionPointsExtensionResult)resultA).distributionPoints);
                    dp.addAll(((ParseCrlDistributionPointsExtensionResult)resultB).distributionPoints);
                    return new ParseCrlDistributionPointsExtensionResult(dp, ((ParseCrlDistributionPointsExtensionResult)resultA).anyDistributionPointUnsupported || ((ParseCrlDistributionPointsExtensionResult)resultB).anyDistributionPointUnsupported);
                });
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("X.509 extension %s (id-ce-cRLDistributionPoints) is incorrectly encoded.", OID_CRL_DISTRIBUTION_POINTS), e);
            }
        }
        return new ParseCrlDistributionPointsExtensionResult(Collections.emptySet(), false);
    }

    public static final class ParseCrlDistributionPointsExtensionResult {
        private final Collection<URL> distributionPoints;
        private final boolean anyDistributionPointUnsupported;

        @Generated
        public ParseCrlDistributionPointsExtensionResult(Collection<URL> distributionPoints, boolean anyDistributionPointUnsupported) {
            this.distributionPoints = distributionPoints;
            this.anyDistributionPointUnsupported = anyDistributionPointUnsupported;
        }

        @Generated
        public Collection<URL> getDistributionPoints() {
            return this.distributionPoints;
        }

        @Generated
        public boolean isAnyDistributionPointUnsupported() {
            return this.anyDistributionPointUnsupported;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParseCrlDistributionPointsExtensionResult)) {
                return false;
            }
            ParseCrlDistributionPointsExtensionResult other = (ParseCrlDistributionPointsExtensionResult)o;
            if (this.isAnyDistributionPointUnsupported() != other.isAnyDistributionPointUnsupported()) {
                return false;
            }
            Collection<URL> this$distributionPoints = this.getDistributionPoints();
            Collection<URL> other$distributionPoints = other.getDistributionPoints();
            return !(this$distributionPoints == null ? other$distributionPoints != null : !((Object)this$distributionPoints).equals(other$distributionPoints));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAnyDistributionPointUnsupported() ? 79 : 97);
            Collection<URL> $distributionPoints = this.getDistributionPoints();
            result = result * 59 + ($distributionPoints == null ? 43 : ((Object)$distributionPoints).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CertificateParser.ParseCrlDistributionPointsExtensionResult(distributionPoints=" + this.getDistributionPoints() + ", anyDistributionPointUnsupported=" + this.isAnyDistributionPointUnsupported() + ")";
        }
    }
}

