/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.support;

import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.springframework.jdbc.core.SqlTypeValue;
import org.springframework.lang.Nullable;

public class SqlCharacterValue
implements SqlTypeValue {
    private final Object content;
    private final long length;

    public SqlCharacterValue(CharSequence string) {
        this.content = string;
        this.length = string.length();
    }

    public SqlCharacterValue(char[] characters) {
        this.content = characters;
        this.length = characters.length;
    }

    public SqlCharacterValue(Reader reader, long length) {
        this.content = reader;
        this.length = length;
    }

    public SqlCharacterValue(InputStream asciiStream, long length) {
        this.content = asciiStream;
        this.length = length;
    }

    @Override
    public void setTypeValue(PreparedStatement ps, int paramIndex, int sqlType, @Nullable String typeName) throws SQLException {
        if (this.content instanceof CharSequence) {
            this.setString(ps, paramIndex, sqlType, this.content.toString());
        } else {
            Object object = this.content;
            if (object instanceof char[]) {
                char[] chars = (char[])object;
                this.setReader(ps, paramIndex, sqlType, new CharArrayReader(chars), this.length);
            } else {
                object = this.content;
                if (object instanceof Reader) {
                    Reader reader = (Reader)object;
                    this.setReader(ps, paramIndex, sqlType, reader, this.length);
                } else {
                    object = this.content;
                    if (object instanceof InputStream) {
                        InputStream asciiStream = (InputStream)object;
                        ps.setAsciiStream(paramIndex, asciiStream, this.length);
                    } else {
                        throw new IllegalArgumentException("Illegal content type: " + this.content.getClass().getName());
                    }
                }
            }
        }
    }

    private void setString(PreparedStatement ps, int paramIndex, int sqlType, String string) throws SQLException {
        if (sqlType == 2005) {
            ps.setClob(paramIndex, new StringReader(string), string.length());
        } else if (sqlType == 2011) {
            ps.setNClob(paramIndex, new StringReader(string), string.length());
        } else {
            ps.setString(paramIndex, string);
        }
    }

    private void setReader(PreparedStatement ps, int paramIndex, int sqlType, Reader reader, long length) throws SQLException {
        if (sqlType == 2005) {
            ps.setClob(paramIndex, reader, length);
        } else if (sqlType == 2011) {
            ps.setNClob(paramIndex, reader, length);
        } else {
            ps.setCharacterStream(paramIndex, reader, length);
        }
    }
}

