/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.imap.ImapRequestHandler;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionImpl;
import com.icegreen.greenmail.server.AbstractSocketProtocolHandler;
import com.icegreen.greenmail.server.BuildInfo;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.LoggingInputStream;
import com.icegreen.greenmail.util.LoggingOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class ImapHandler
extends AbstractSocketProtocolHandler
implements ImapConstants {
    private final ImapRequestHandler requestHandler = new ImapRequestHandler();
    private ImapSession session;
    private ImapResponse response;
    final UserManager userManager;
    private final ImapHostManager imapHost;

    public ImapHandler(UserManager userManager, ImapHostManager imapHost, Socket socket) {
        super(socket);
        this.userManager = userManager;
        this.imapHost = imapHost;
    }

    public void forceConnectionClose(String message) {
        this.response.byeResponse(message);
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (InputStream ins = this.prepareInputStream();
             OutputStream outs = this.prepareOutputStream();){
            this.response = new ImapResponse(outs);
            String responseBuffer = "IMAP4rev1 Server GreenMail v" + BuildInfo.INSTANCE.getProjectVersion() + " ready";
            this.response.okResponse(null, responseBuffer);
            this.session = new ImapSessionImpl(this.imapHost, this.userManager, this, this.socket.getInetAddress().getHostAddress());
            while (!this.isQuitting() && this.requestHandler.handleRequest(ins, outs, this.session)) {
            }
        }
        catch (Exception e) {
            if (!this.isQuitting()) {
                throw new IllegalStateException("Can not handle IMAP connection", e);
            }
        }
        finally {
            this.close();
        }
    }

    private InputStream prepareInputStream() throws IOException {
        FilterInputStream is = new BufferedInputStream(this.socket.getInputStream(), 512);
        if (this.log.isDebugEnabled()) {
            is = new LoggingInputStream(is, "C: ");
        }
        return is;
    }

    private OutputStream prepareOutputStream() throws IOException {
        FilterOutputStream outputStream = new BufferedOutputStream(this.socket.getOutputStream(), 1024);
        if (this.log.isDebugEnabled()) {
            outputStream = new LoggingOutputStream(outputStream, "S: ");
        }
        return outputStream;
    }

    @Override
    public void close() {
        super.close();
        this.session = null;
        this.response = null;
    }
}

