/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.util.Assert;

public final class ChannelInitializer
implements BeanFactoryAware,
InitializingBean {
    private static final Log LOGGER = LogFactory.getLog(ChannelInitializer.class);
    private volatile DefaultListableBeanFactory beanFactory;
    private volatile boolean autoCreate = true;

    ChannelInitializer() {
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (DefaultListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.beanFactory, (String)"'beanFactory' must not be null");
        if (this.autoCreate) {
            AutoCreateCandidatesCollector channelCandidatesCollector = (AutoCreateCandidatesCollector)this.beanFactory.getBean("$autoCreateChannelCandidates", AutoCreateCandidatesCollector.class);
            Collection<String> channelNames = channelCandidatesCollector.channelNames;
            if (channelNames != null) {
                for (String channelName : channelNames) {
                    if (this.beanFactory.containsBean(channelName)) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Auto-creating channel '" + channelName + "' as DirectChannel"));
                    }
                    DirectChannel channelToRegister = new DirectChannel();
                    this.beanFactory.registerSingleton(channelName, (Object)channelToRegister);
                    this.beanFactory.initializeBean((Object)channelToRegister, channelName);
                }
            }
        }
    }

    public record AutoCreateCandidatesCollector(Collection<String> channelNames) {
    }
}

