/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.api.common.typeutils.base.BigIntSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class BigIntComparator
extends BasicTypeComparator<BigInteger> {
    private static final long serialVersionUID = 1L;

    public BigIntComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        BigInteger bi1 = BigIntSerializer.readBigInteger(firstSource);
        BigInteger bi2 = BigIntSerializer.readBigInteger(secondSource);
        int comp = bi1.compareTo(bi2);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public int getNormalizeKeyLen() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return true;
    }

    @Override
    public void putNormalizedKey(BigInteger record, MemorySegment target, int offset, int len) {
        int bitLen = 0;
        if (len > 0) {
            int normBitLen;
            int signum = record.signum();
            bitLen = record.bitLength();
            int n = normBitLen = signum < 0 ? Integer.MAX_VALUE - bitLen : bitLen;
            if (signum >= 0) {
                normBitLen |= Integer.MIN_VALUE;
            }
            for (int i = 0; i < 4 && len > 0; ++i, --len) {
                byte b = (byte)(normBitLen >>> 8 * (3 - i));
                target.put(offset++, b);
            }
        }
        int bitPos = bitLen - 1;
        while (len > 0) {
            byte b = 0;
            for (int bytePos = 0; bytePos < 8 && bitPos >= 0; ++bytePos, --bitPos) {
                b = (byte)(b << 1);
                if (!record.testBit(bitPos)) continue;
                b = (byte)(b | 1);
            }
            target.put(offset++, b);
            --len;
        }
    }

    public BigIntComparator duplicate() {
        return new BigIntComparator(this.ascendingComparison);
    }
}

