/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.watcher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.util.Timeout;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.flink.kubernetes.ChangeEventBus;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatchController;
import org.apache.streampark.flink.kubernetes.MetricWatcherConfig;
import org.apache.streampark.flink.kubernetes.event.FlinkClusterMetricChangeEvent;
import org.apache.streampark.flink.kubernetes.model.ClusterKey;
import org.apache.streampark.flink.kubernetes.model.ClusterKey$;
import org.apache.streampark.flink.kubernetes.model.FlinkMetricCV;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import org.apache.streampark.flink.kubernetes.watcher.FlinkMetricWatcher$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkRestJmConfigItem$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkRestOverview;
import org.apache.streampark.flink.kubernetes.watcher.FlinkRestOverview$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkWatcher;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u000b\u0017\u0001\rB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011)\u0019!C\u0002y!A\u0001\t\u0001B\u0001B\u0003%Q\b\u0003\u0005B\u0001\t\u0015\r\u0011b\u0001C\u0011!1\u0005A!A!\u0002\u0013\u0019\u0005\"B$\u0001\t\u0003A\u0005b\u0002(\u0001\u0005\u0004%Ya\u0014\u0005\u0007-\u0002\u0001\u000b\u0011\u0002)\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0013A\u0006\"\u00038\u0001\u0001\u0004\u0005\r\u0011\"\u0003p\u0011%1\u0007\u00011A\u0001B\u0003&\u0011\fC\u0003z\u0001\u0011\u0005#\u0010C\u0003|\u0001\u0011\u0005#\u0010C\u0003}\u0001\u0011\u0005#\u0010C\u0003~\u0001\u0011\u0005#\u0010C\u0003\u007f\u0001\u0011%qpB\u0005\u00022Y\t\t\u0011#\u0001\u00024\u0019AQCFA\u0001\u0012\u0003\t)\u0004\u0003\u0004H%\u0011\u0005\u0011q\u0007\u0005\n\u0003s\u0011\u0012\u0013!C\u0001\u0003w\u0011!C\u00127j].lU\r\u001e:jG^\u000bGo\u00195fe*\u0011q\u0003G\u0001\bo\u0006$8\r[3s\u0015\tI\"$\u0001\u0006lk\n,'O\\3uKNT!a\u0007\u000f\u0002\u000b\u0019d\u0017N\\6\u000b\u0005uq\u0012AC:ue\u0016\fW\u000e]1sW*\u0011q\u0004I\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0013+eA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\tU$\u0018\u000e\u001c\u0006\u0003_q\taaY8n[>t\u0017BA\u0019-\u0005\u0019aunZ4feB\u00111\u0007N\u0007\u0002-%\u0011QG\u0006\u0002\r\r2Lgn[,bi\u000eDWM]\u0001\u0005G>tg\r\u0005\u00029s5\t\u0001$\u0003\u0002;1\t\u0019R*\u001a;sS\u000e<\u0016\r^2iKJ\u001cuN\u001c4jO\u0006yq/\u0019;dQ\u000e{g\u000e\u001e:pY2,'/F\u0001>!\tAd(\u0003\u0002@1\t9b\t\\5oW.C4oV1uG\"\u001cuN\u001c;s_2dWM]\u0001\u0011o\u0006$8\r[\"p]R\u0014x\u000e\u001c7fe\u0002\n\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002\u0007B\u0011\u0001\bR\u0005\u0003\u000bb\u0011ab\u00115b]\u001e,WI^3oi\n+8/A\u0005fm\u0016tGOQ;tA\u00051A(\u001b8jiz\"\"!S'\u0015\u0007)[E\n\u0005\u00024\u0001!)1H\u0002a\u0002{!)\u0011I\u0002a\u0002\u0007\"9aG\u0002I\u0001\u0002\u00049\u0014!\u0005;sC\u000e\\G+Y:l\u000bb,7-\u001e;peV\t\u0001\u000b\u0005\u0002R)6\t!K\u0003\u0002TM\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005U\u0013&aH#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;peN+'O^5dK\u0006\u0011BO]1dWR\u000b7o[#yK\u000e,Ho\u001c:!\u00035!\u0018.\\3s'\u000eDW\rZ;mKV\t\u0011\f\r\u0002[IB\u00191\f\u00192\u000e\u0003qS!aU/\u000b\u00055r&\"A0\u0002\t)\fg/Y\u0005\u0003Cr\u0013qbU2iK\u0012,H.\u001a3GkR,(/\u001a\t\u0003G\u0012d\u0001\u0001B\u0005f\u0017\u0005\u0005\t\u0011!B\u0001O\n\u0019q\fJ\u0019\u0002\u001dQLW.\u001a:TG\",G-\u001e7fAE\u0011\u0001n\u001b\t\u0003K%L!A\u001b\u0014\u0003\u000f9{G\u000f[5oOB\u0011Q\u0005\\\u0005\u0003[\u001a\u00121!\u00118z\u0003E!\u0018.\\3s'\u000eDW\rZ;mK~#S-\u001d\u000b\u0003aN\u0004\"!J9\n\u0005I4#\u0001B+oSRDq\u0001\u001e\u0006\u0002\u0002\u0003\u0007Q/A\u0002yIE\u0002$A\u001e=\u0011\u0007m\u0003w\u000f\u0005\u0002dq\u0012IQm]A\u0001\u0002\u0003\u0015\taZ\u0001\bI>\u001cF/\u0019:u)\u0005\u0001\u0018A\u00023p'R|\u0007/A\u0004e_\u000ecwn]3\u0002\u000f\u0011|w+\u0019;dQ\u0006q1m\u001c7mK\u000e$X*\u001a;sS\u000e\u001cH\u0003BA\u0001\u0003'\u0001R!JA\u0002\u0003\u000fI1!!\u0002'\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000ea\tQ!\\8eK2LA!!\u0005\u0002\f\tia\t\\5oW6+GO]5d\u0007ZCq!!\u0006\u0011\u0001\u0004\t9\"\u0001\u0002jIB!\u0011\u0011BA\r\u0013\u0011\tY\"a\u0003\u0003\u000fQ\u0013\u0018mY6JI\"\u001a\u0001!a\b\u0011\t\u0005\u0005\u0012QF\u0007\u0003\u0003GQ1aUA\u0013\u0015\u0011\t9#!\u000b\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u0002,\u0005)!.\u0019<bq&!\u0011qFA\u0012\u0005)!\u0006N]3bIN\u000bg-Z\u0001\u0013\r2Lgn['fiJL7mV1uG\",'\u000f\u0005\u00024%M\u0011!\u0003\n\u000b\u0003\u0003g\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTCAA\u001fU\r9\u0014qH\u0016\u0003\u0003\u0003\u0002B!a\u0011\u0002L5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0005\u0014\n\t\u00055\u0013Q\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
@ThreadSafe
public class FlinkMetricWatcher
implements Logger,
FlinkWatcher {
    private final MetricWatcherConfig conf;
    private final FlinkK8sWatchController watchController;
    private final ChangeEventBus eventBus;
    private final ExecutionContextExecutorService trackTaskExecutor;
    private ScheduledFuture<?> timerSchedule;
    private Timeout FLINK_CLIENT_TIMEOUT_SEC;
    private Timeout FLINK_REST_AWAIT_TIMEOUT_SEC;
    private final AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    private final int org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM;
    private final ScheduledThreadPoolExecutor watchExecutor;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    public static MetricWatcherConfig $lessinit$greater$default$1() {
        return FlinkMetricWatcher$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public void start() {
        FlinkWatcher.start$(this);
    }

    @Override
    public void stop() {
        FlinkWatcher.stop$(this);
    }

    @Override
    public void close() {
        FlinkWatcher.close$(this);
    }

    @Override
    public void restart() {
        FlinkWatcher.restart$(this);
    }

    @Override
    public Runnable funcToRunnable(Function0<BoxedUnit> fun) {
        return FlinkWatcher.funcToRunnable$(this, fun);
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    private Timeout FLINK_CLIENT_TIMEOUT_SEC$lzycompute() {
        FlinkMetricWatcher flinkMetricWatcher = this;
        synchronized (flinkMetricWatcher) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.FLINK_CLIENT_TIMEOUT_SEC = FlinkWatcher.FLINK_CLIENT_TIMEOUT_SEC$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.FLINK_CLIENT_TIMEOUT_SEC;
    }

    @Override
    public Timeout FLINK_CLIENT_TIMEOUT_SEC() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.FLINK_CLIENT_TIMEOUT_SEC$lzycompute() : this.FLINK_CLIENT_TIMEOUT_SEC;
    }

    private Timeout FLINK_REST_AWAIT_TIMEOUT_SEC$lzycompute() {
        FlinkMetricWatcher flinkMetricWatcher = this;
        synchronized (flinkMetricWatcher) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.FLINK_REST_AWAIT_TIMEOUT_SEC = FlinkWatcher.FLINK_REST_AWAIT_TIMEOUT_SEC$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.FLINK_REST_AWAIT_TIMEOUT_SEC;
    }

    @Override
    public Timeout FLINK_REST_AWAIT_TIMEOUT_SEC() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.FLINK_REST_AWAIT_TIMEOUT_SEC$lzycompute() : this.FLINK_REST_AWAIT_TIMEOUT_SEC;
    }

    @Override
    public AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started() {
        return this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    }

    @Override
    public int org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM() {
        return this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM;
    }

    @Override
    public ScheduledThreadPoolExecutor watchExecutor() {
        return this.watchExecutor;
    }

    @Override
    public final void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started_$eq(AtomicBoolean x$1) {
        this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started = x$1;
    }

    @Override
    public final void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM_$eq(int x$1) {
        this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM = x$1;
    }

    @Override
    public void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$watchExecutor_$eq(ScheduledThreadPoolExecutor x$1) {
        this.watchExecutor = x$1;
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public FlinkK8sWatchController watchController() {
        return this.watchController;
    }

    public ChangeEventBus eventBus() {
        return this.eventBus;
    }

    private ExecutionContextExecutorService trackTaskExecutor() {
        return this.trackTaskExecutor;
    }

    private ScheduledFuture<?> timerSchedule() {
        return this.timerSchedule;
    }

    private void timerSchedule_$eq(ScheduledFuture<?> x$1) {
        this.timerSchedule = x$1;
    }

    @Override
    public void doStart() {
        this.timerSchedule_$eq(this.watchExecutor().scheduleAtFixedRate(() -> this.doWatch(), 0L, this.conf.requestIntervalSec(), TimeUnit.SECONDS));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkMetricWatcher started.");
    }

    @Override
    public void doStop() {
        Object object = !this.timerSchedule().isCancelled() ? BoxesRunTime.boxToBoolean((boolean)this.timerSchedule().cancel(true)) : BoxedUnit.UNIT;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkMetricWatcher stopped.");
    }

    @Override
    public void doClose() {
        Object object = Option$.MODULE$.apply(this.timerSchedule()).isDefined() && !this.timerSchedule().isCancelled() ? BoxesRunTime.boxToBoolean((boolean)this.timerSchedule().cancel(true)) : BoxedUnit.UNIT;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkMetricWatcher closed.");
    }

    @Override
    public void doWatch() {
        Object object = new Object();
        try {
            Set trackIds = (Set)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.watchController().getActiveWatchingIds()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            });
            Set futures = (Set)trackIds.map((Function1 & Serializable & scala.Serializable)id -> {
                void var2_2;
                Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.collectMetrics((TrackId)id), (ExecutionContext)this.trackTaskExecutor());
                future.onComplete((Function1 & Serializable & scala.Serializable)x$2 -> {
                    FlinkMetricWatcher.$anonfun$doWatch$6(this, id, x$2);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)this.trackTaskExecutor());
                return var2_2;
            }, Set$.MODULE$.canBuildFrom());
            Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, Set$.MODULE$.canBuildFrom(), (ExecutionContext)this.trackTaskExecutor()), (Duration)new package.DurationLong(package$.MODULE$.DurationLong($this.conf.requestTimeoutSec())).seconds())).failed().map((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("[FlinkMetricWatcher] tracking flink metrics on kubernetes mode timeout,").append(new StringBuilder(15).append(" limitSeconds=").append($this.conf.requestTimeoutSec()).append(",").toString()).append(new StringBuilder(21).append(" trackingClusterKeys=").append(trackIds$1.mkString(",")).toString()).toString());
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private Option<FlinkMetricCV> collectMetrics(TrackId id) {
        Option option;
        Object object = new Object();
        try {
            ClusterKey clusterKey = ClusterKey$.MODULE$.of(id);
            String flinkJmRestUrl = (String)this.watchController().getClusterRestUrl(clusterKey).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FlinkMetricWatcher.$anonfun$collectMetrics$1(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            FlinkRestOverview flinkOverview = (FlinkRestOverview)FlinkRestOverview$.MODULE$.as(Request.get((String)new StringBuilder(9).append(flinkJmRestUrl).append("/overview").toString()).connectTimeout(this.FLINK_REST_AWAIT_TIMEOUT_SEC()).responseTimeout(this.FLINK_CLIENT_TIMEOUT_SEC()).execute().returnContent().asString(StandardCharsets.UTF_8)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            Map flinkJmConfigs = (Map)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)FlinkRestJmConfigItem$.MODULE$.as(Request.get((String)new StringBuilder(18).append(flinkJmRestUrl).append("/jobmanager/config").toString()).connectTimeout(this.FLINK_REST_AWAIT_TIMEOUT_SEC()).responseTimeout(this.FLINK_CLIENT_TIMEOUT_SEC()).execute().returnContent().asString(StandardCharsets.UTF_8)).map((Function1 & Serializable & scala.Serializable)e -> new Tuple2((Object)e.key(), (Object)e.value()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            long ackTime = System.currentTimeMillis();
            String tmMemStr = (String)flinkJmConfigs.getOrElse((Object)TaskManagerOptions.TOTAL_PROCESS_MEMORY.key(), (Function0 & Serializable & scala.Serializable)() -> "0b");
            String jmMemStr = (String)flinkJmConfigs.getOrElse((Object)JobManagerOptions.TOTAL_PROCESS_MEMORY.key(), (Function0 & Serializable & scala.Serializable)() -> "0b");
            FlinkMetricCV flinkMetricCV = new FlinkMetricCV(id.groupId(), Predef$.MODULE$.int2Integer(MemorySize.parse((String)jmMemStr).getMebiBytes()), Predef$.MODULE$.int2Integer(MemorySize.parse((String)tmMemStr).getMebiBytes() * Predef$.MODULE$.Integer2int(flinkOverview.taskManagers())), flinkOverview.taskManagers(), flinkOverview.slotsTotal(), flinkOverview.slotsAvailable(), flinkOverview.jobsRunning(), flinkOverview.jobsFinished(), flinkOverview.jobsCancelled(), flinkOverview.jobsFailed(), ackTime);
            option = new Some((Object)flinkMetricCV);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static final /* synthetic */ void $anonfun$doWatch$6(FlinkMetricWatcher $this, TrackId id$1, Try x$2) {
        Option option = (Option)x$2.getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            boolean isMetricChanged;
            Some some = (Some)option;
            FlinkMetricCV metric = (FlinkMetricCV)some.value();
            ClusterKey clusterKey = id$1.toClusterKey();
            FlinkMetricCV preMetric = $this.watchController().flinkMetrics().get(clusterKey);
            boolean bl = isMetricChanged = preMetric == null || !preMetric.equalsPayload(metric);
            if (isMetricChanged) {
                $this.eventBus().postAsync(new FlinkClusterMetricChangeEvent(id$1, metric));
                $this.watchController().flinkMetrics().put(clusterKey, metric);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$collectMetrics$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public FlinkMetricWatcher(MetricWatcherConfig conf, FlinkK8sWatchController watchController, ChangeEventBus eventBus) {
        this.conf = conf;
        this.watchController = watchController;
        this.eventBus = eventBus;
        Logger.$init$((Logger)this);
        FlinkWatcher.$init$(this);
        this.trackTaskExecutor = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.watchExecutor());
    }
}

