/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluentImpl;
import java.util.Objects;

public class IngressBackendBuilder
extends IngressBackendFluentImpl<IngressBackendBuilder>
implements VisitableBuilder<IngressBackend, IngressBackendBuilder> {
    IngressBackendFluent<?> fluent;
    Boolean validationEnabled;

    public IngressBackendBuilder() {
        this(true);
    }

    public IngressBackendBuilder(Boolean validationEnabled) {
        this(new IngressBackend(), validationEnabled);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressBackend(), validationEnabled);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, IngressBackend instance) {
        this(fluent, instance, true);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, IngressBackend instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withResource(instance.getResource());
        fluent.withServiceName(instance.getServiceName());
        fluent.withServicePort(instance.getServicePort());
        this.validationEnabled = validationEnabled;
    }

    public IngressBackendBuilder(IngressBackend instance) {
        this(instance, (Boolean)true);
    }

    public IngressBackendBuilder(IngressBackend instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withResource(instance.getResource());
        this.withServiceName(instance.getServiceName());
        this.withServicePort(instance.getServicePort());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public IngressBackend build() {
        IngressBackend buildable = new IngressBackend(this.fluent.getResource(), this.fluent.getServiceName(), this.fluent.getServicePort());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBackendBuilder that = (IngressBackendBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

