/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.types.Row;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.flink.core.SqlCommand;
import org.apache.streampark.flink.core.SqlCommand$BEGIN_STATEMENT_SET$;
import org.apache.streampark.flink.core.SqlCommand$DELETE$;
import org.apache.streampark.flink.core.SqlCommand$DESC$;
import org.apache.streampark.flink.core.SqlCommand$DESCRIBE$;
import org.apache.streampark.flink.core.SqlCommand$END_STATEMENT_SET$;
import org.apache.streampark.flink.core.SqlCommand$EXPLAIN$;
import org.apache.streampark.flink.core.SqlCommand$INSERT$;
import org.apache.streampark.flink.core.SqlCommand$RESET$;
import org.apache.streampark.flink.core.SqlCommand$RESET_ALL$;
import org.apache.streampark.flink.core.SqlCommand$SELECT$;
import org.apache.streampark.flink.core.SqlCommand$SET$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_CATALOGS$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_CURRENT_CATALOG$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_CURRENT_DATABASE$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_DATABASES$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_FUNCTIONS$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_MODULES$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_TABLES$;
import org.apache.streampark.flink.core.SqlCommand$UPDATE$;
import org.apache.streampark.flink.core.SqlCommandCall;
import org.apache.streampark.flink.core.SqlCommandParser$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.util.Try$;

public final class FlinkSqlExecutor$
implements Logger {
    public static final FlinkSqlExecutor$ MODULE$;
    public final ReentrantReadWriteLock.WriteLock org$apache$streampark$flink$core$FlinkSqlExecutor$$lock;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new FlinkSqlExecutor$();
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public String logName() {
        return Logger.class.logName((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.class.logger((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.class.logInfo((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.class.logInfo((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.class.logDebug((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.class.logDebug((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.class.logTrace((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.class.logTrace((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.class.logWarn((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.class.logWarn((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.class.logError((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.class.logError((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.class.isTraceEnabled((Logger)this);
    }

    public void executeSql(String sql, ParameterTool parameter, TableEnvironment context, Function1<String, BoxedUnit> callbackFunc) {
        String flinkSql = StringUtils.isBlank((CharSequence)sql) ? parameter.get(ConfigConst$.MODULE$.KEY_FLINK_SQL(ConfigConst$.MODULE$.KEY_FLINK_SQL$default$1())) : parameter.get(sql);
        Predef$.MODULE$.require(StringUtils.isNotBlank((CharSequence)flinkSql), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "verify failed: flink sql cannot be empty";
            }
        });
        String runMode = parameter.get(ExecutionOptions.RUNTIME_MODE.key());
        BooleanRef hasInsert = BooleanRef.create((boolean)false);
        StatementSet statementSet = context.createStatementSet();
        SqlCommandParser$.MODULE$.parseSQL(flinkSql, SqlCommandParser$.MODULE$.parseSQL$default$2()).foreach((Function1)new Serializable(context, callbackFunc, runMode, hasInsert, statementSet){
            public static final long serialVersionUID = 0L;
            private final TableEnvironment context$1;
            private final Function1 callbackFunc$1;
            private final String runMode$1;
            private final BooleanRef hasInsert$1;
            private final StatementSet statementSet$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void apply(SqlCommandCall x) {
                String args = Predef$.MODULE$.refArrayOps((Object[])x.operands()).isEmpty() ? null : (String)Predef$.MODULE$.refArrayOps((Object[])x.operands()).head();
                String command = x.command().name();
                SqlCommand sqlCommand = x.command();
                if (SqlCommand$SHOW_CATALOGS$.MODULE$.equals(sqlCommand)) {
                    String[] catalogs = this.context$1.listCatalogs();
                    FlinkSqlExecutor$.MODULE$.org$apache$streampark$flink$core$FlinkSqlExecutor$$callback$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, Predef$.MODULE$.refArrayOps((Object[])catalogs).mkString("\n")})), this.callbackFunc$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (SqlCommand$SHOW_CURRENT_CATALOG$.MODULE$.equals(sqlCommand)) {
                    String catalog = this.context$1.getCurrentCatalog();
                    FlinkSqlExecutor$.MODULE$.org$apache$streampark$flink$core$FlinkSqlExecutor$$callback$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, catalog})), this.callbackFunc$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (SqlCommand$SHOW_DATABASES$.MODULE$.equals(sqlCommand)) {
                    String[] databases = this.context$1.listDatabases();
                    FlinkSqlExecutor$.MODULE$.org$apache$streampark$flink$core$FlinkSqlExecutor$$callback$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, Predef$.MODULE$.refArrayOps((Object[])databases).mkString("\n")})), this.callbackFunc$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (SqlCommand$SHOW_CURRENT_DATABASE$.MODULE$.equals(sqlCommand)) {
                    String database = this.context$1.getCurrentDatabase();
                    FlinkSqlExecutor$.MODULE$.org$apache$streampark$flink$core$FlinkSqlExecutor$$callback$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, database})), this.callbackFunc$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (SqlCommand$SHOW_TABLES$.MODULE$.equals(sqlCommand)) {
                    String[] tables = (String[])Predef$.MODULE$.refArrayOps((Object[])this.context$1.listTables()).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$1) {
                            return !x$1.startsWith("UnnamedTable");
                        }
                    });
                    FlinkSqlExecutor$.MODULE$.org$apache$streampark$flink$core$FlinkSqlExecutor$$callback$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, Predef$.MODULE$.refArrayOps((Object[])tables).mkString("\n")})), this.callbackFunc$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (SqlCommand$SHOW_FUNCTIONS$.MODULE$.equals(sqlCommand)) {
                    String[] functions = this.context$1.listUserDefinedFunctions();
                    FlinkSqlExecutor$.MODULE$.org$apache$streampark$flink$core$FlinkSqlExecutor$$callback$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, Predef$.MODULE$.refArrayOps((Object[])functions).mkString("\n")})), this.callbackFunc$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (SqlCommand$SHOW_MODULES$.MODULE$.equals(sqlCommand)) {
                    String[] modules = this.context$1.listModules();
                    FlinkSqlExecutor$.MODULE$.org$apache$streampark$flink$core$FlinkSqlExecutor$$callback$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, Predef$.MODULE$.refArrayOps((Object[])modules).mkString("\n")})), this.callbackFunc$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                boolean bl = SqlCommand$DESC$.MODULE$.equals(sqlCommand) ? true : SqlCommand$DESCRIBE$.MODULE$.equals(sqlCommand);
                if (bl) {
                    TableSchema schema = this.context$1.scan(new String[]{args}).getSchema();
                    StringBuilder builder = new StringBuilder();
                    builder.append("Column\tType\n");
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), schema.getFieldCount()).foreach((Function1)new Serializable(this, schema, builder){
                        public static final long serialVersionUID = 0L;
                        private final TableSchema schema$1;
                        private final StringBuilder builder$1;

                        public final StringBuilder apply(int i) {
                            return this.builder$1.append(new StringBuilder().append((Object)((String)this.schema$1.getFieldName(i).get())).append((Object)"\t").append(this.schema$1.getFieldDataType(i).get()).append((Object)"\n").toString());
                        }
                        {
                            this.schema$1 = schema$1;
                            this.builder$1 = builder$1;
                        }
                    });
                    FlinkSqlExecutor$.MODULE$.org$apache$streampark$flink$core$FlinkSqlExecutor$$callback$1(builder.toString(), this.callbackFunc$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (SqlCommand$EXPLAIN$.MODULE$.equals(sqlCommand)) {
                    TableResult tableResult = this.context$1.executeSql(x.originSql());
                    String r = ((Row)tableResult.collect().next()).getField(0).toString();
                    FlinkSqlExecutor$.MODULE$.org$apache$streampark$flink$core$FlinkSqlExecutor$$callback$1(r, this.callbackFunc$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (SqlCommand$SET$.MODULE$.equals(sqlCommand)) {
                    String operand = x.operands()[1];
                    FlinkSqlExecutor$.MODULE$.logInfo((Function0<String>)new Serializable(this, args, command, operand){
                        public static final long serialVersionUID = 0L;
                        private final String args$1;
                        private final String command$1;
                        private final String operand$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", " --> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.command$1, this.args$1, this.operand$1}));
                        }
                        {
                            this.args$1 = args$1;
                            this.command$1 = command$1;
                            this.operand$1 = operand$1;
                        }
                    });
                    this.context$1.getConfig().getConfiguration().setString(args, operand);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                boolean bl2 = SqlCommand$RESET$.MODULE$.equals(sqlCommand) ? true : SqlCommand$RESET_ALL$.MODULE$.equals(sqlCommand);
                if (bl2) {
                    HashMap confData;
                    Field confDataField = Configuration.class.getDeclaredField("confData");
                    confDataField.setAccessible(true);
                    HashMap hashMap = confData = (HashMap)confDataField.get(this.context$1.getConfig().getConfiguration());
                    synchronized (hashMap) {
                        Object object;
                        SqlCommand sqlCommand2 = x.command();
                        SqlCommand$RESET$ sqlCommand$RESET$ = SqlCommand$RESET$.MODULE$;
                        if (!(sqlCommand2 != null ? !sqlCommand2.equals(sqlCommand$RESET$) : sqlCommand$RESET$ != null)) {
                            object = confData.remove(args);
                        } else {
                            confData.clear();
                            object = BoxedUnit.UNIT;
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 14] lbl75 : MonitorExitStatement: MONITOREXIT : hashMap
                        FlinkSqlExecutor$.MODULE$.logInfo((Function0<String>)new Serializable(this, args, command){
                            public static final long serialVersionUID = 0L;
                            private final String args$1;
                            private final String command$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.command$1, this.args$1}));
                            }
                            {
                                this.args$1 = args$1;
                                this.command$1 = command$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                boolean bl3 = SqlCommand$BEGIN_STATEMENT_SET$.MODULE$.equals(sqlCommand) ? true : SqlCommand$END_STATEMENT_SET$.MODULE$.equals(sqlCommand);
                if (bl3) {
                    FlinkSqlExecutor$.MODULE$.logWarn((Function0<String>)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final SqlCommandCall x$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SQL Client Syntax: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x$2.command().name()}));
                        }
                        {
                            this.x$2 = x$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (SqlCommand$INSERT$.MODULE$.equals(sqlCommand)) {
                    this.statementSet$1.addInsertSql(x.originSql());
                    this.hasInsert$1.elem = true;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (SqlCommand$SELECT$.MODULE$.equals(sqlCommand)) {
                    FlinkSqlExecutor$.MODULE$.logError((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "StreamPark dose not support 'SELECT' statement now!";
                        }
                    });
                    throw new RuntimeException("StreamPark dose not support 'select' statement now!");
                }
                boolean bl4 = SqlCommand$DELETE$.MODULE$.equals(sqlCommand) ? true : SqlCommand$UPDATE$.MODULE$.equals(sqlCommand);
                if (bl4) {
                    String string = this.runMode$1;
                    String string2 = "STREAMING";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw new UnsupportedOperationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Currently, ", " statement only supports in batch mode, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command.toUpperCase()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and it requires the target table connector implements the SupportsRowLevelDelete, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"For more details please refer to: https://nightlies.apache.org/flink/flink-docs-release-1.18/docs/dev/table/sql/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command}))).toString());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                try {
                    FlinkSqlExecutor$.MODULE$.org$apache$streampark$flink$core$FlinkSqlExecutor$$lock.lock();
                    TableResult result = this.context$1.executeSql(x.originSql());
                    FlinkSqlExecutor$.MODULE$.logInfo((Function0<String>)new Serializable(this, args, command){
                        public static final long serialVersionUID = 0L;
                        private final String args$1;
                        private final String command$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.command$1, this.args$1}));
                        }
                        {
                            this.args$1 = args$1;
                            this.command$1 = command$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                finally {
                    if (FlinkSqlExecutor$.MODULE$.org$apache$streampark$flink$core$FlinkSqlExecutor$$lock.isHeldByCurrentThread()) {
                        FlinkSqlExecutor$.MODULE$.org$apache$streampark$flink$core$FlinkSqlExecutor$$lock.unlock();
                    }
                }
            }
            {
                this.context$1 = context$1;
                this.callbackFunc$1 = callbackFunc$1;
                this.runMode$1 = runMode$1;
                this.hasInsert$1 = hasInsert$1;
                this.statementSet$1 = statementSet$1;
            }
        });
        if (hasInsert.elem) {
            TableResult tableResult = statementSet.execute();
            if (tableResult == null) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                JobID jobID = (JobID)Try$.MODULE$.apply((Function0)new Serializable(tableResult){
                    public static final long serialVersionUID = 0L;
                    private final TableResult x1$2;

                    public final JobID apply() {
                        return ((JobClient)this.x1$2.getJobClient().get()).getJobID();
                    }
                    {
                        this.x1$2 = x1$2;
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
                if (jobID == null) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.logInfo((Function0<String>)new Serializable(jobID){
                        public static final long serialVersionUID = 0L;
                        private final JobID x1$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jobId:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1}));
                        }
                        {
                            this.x1$1 = x1$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.logInfo((Function0<String>)new Serializable(flinkSql){
                public static final long serialVersionUID = 0L;
                private final String flinkSql$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n\\n\\n==============flinkSql==============\\n\\n ", "\\n\\n============================\\n\\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flinkSql$1}));
                }
                {
                    this.flinkSql$1 = flinkSql$1;
                }
            });
            return;
        }
        this.logError((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "No 'INSERT' statement to trigger the execution of the Flink job.";
            }
        });
        throw new RuntimeException("No 'INSERT' statement to trigger the execution of the Flink job.");
    }

    public Function1<String, BoxedUnit> executeSql$default$4(String sql, ParameterTool parameter, TableEnvironment context) {
        return null;
    }

    public final void org$apache$streampark$flink$core$FlinkSqlExecutor$$callback$1(String r, Function1 callbackFunc$1) {
        Function1 function1 = callbackFunc$1;
        if (function1 == null) {
            this.logInfo((Function0<String>)new Serializable(r){
                public static final long serialVersionUID = 0L;
                private final String r$1;

                public final String apply() {
                    return this.r$1;
                }
                {
                    this.r$1 = r$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = (BoxedUnit)function1.apply((Object)r);
        }
    }

    private FlinkSqlExecutor$() {
        MODULE$ = this;
        Logger.class.$init$((Logger)this);
        this.org$apache$streampark$flink$core$FlinkSqlExecutor$$lock = new ReentrantReadWriteLock().writeLock();
    }
}

