/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.runtime.operators.coordination.OperatorEventDispatcher;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;

@Experimental
public class StreamOperatorParameters<OUT> {
    private final StreamTask<?, ?> containingTask;
    private final StreamConfig config;
    private final Output<StreamRecord<OUT>> output;
    private final Supplier<ProcessingTimeService> processingTimeServiceFactory;
    private final OperatorEventDispatcher operatorEventDispatcher;
    @Nullable
    private ProcessingTimeService processingTimeService;

    public StreamOperatorParameters(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<OUT>> output, Supplier<ProcessingTimeService> processingTimeServiceFactory, OperatorEventDispatcher operatorEventDispatcher) {
        this.containingTask = containingTask;
        this.config = config;
        this.output = output;
        this.processingTimeServiceFactory = processingTimeServiceFactory;
        this.operatorEventDispatcher = operatorEventDispatcher;
    }

    public StreamTask<?, ?> getContainingTask() {
        return this.containingTask;
    }

    public StreamConfig getStreamConfig() {
        return this.config;
    }

    public Output<StreamRecord<OUT>> getOutput() {
        return this.output;
    }

    public ProcessingTimeService getProcessingTimeService() {
        if (this.processingTimeService == null) {
            this.processingTimeService = this.processingTimeServiceFactory.get();
        }
        return this.processingTimeService;
    }

    public OperatorEventDispatcher getOperatorEventDispatcher() {
        return this.operatorEventDispatcher;
    }
}

